/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.misc;

import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import javax.annotation.Nonnull;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2402;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public class LiquidBlockContainerTransfer
implements IFluidTransfer {
    protected final class_2402 liquidContainer;
    protected final class_1937 world;
    protected final class_2338 blockPos;

    public LiquidBlockContainerTransfer(class_2402 liquidContainer, class_1937 world, class_2338 blockPos) {
        this.liquidContainer = liquidContainer;
        this.world = world;
        this.blockPos = blockPos;
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return FluidStack.empty();
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        this.fill(0, fluidStack, false, false);
    }

    @Override
    public long getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    @Override
    @Nonnull
    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        return FluidStack.empty();
    }

    @Override
    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        class_2680 state;
        if (resource.getAmount() >= FluidHelper.getBucket() && this.liquidContainer.method_10310((class_1922)this.world, this.blockPos, state = this.world.method_8320(this.blockPos), resource.getFluid()) && (simulate || this.liquidContainer.method_10311((class_1936)this.world, this.blockPos, state, resource.getFluid().method_15785()))) {
            return FluidHelper.getBucket();
        }
        return 0L;
    }

    @Override
    public boolean supportsFill(int tank) {
        return true;
    }

    @Override
    public boolean supportsDrain(int tank) {
        return false;
    }

    @Override
    @NotNull
    public Object createSnapshot() {
        return this.world.method_8320(this.blockPos);
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
        if (snapshot instanceof class_2680) {
            class_2680 state = (class_2680)snapshot;
            this.world.method_8501(this.blockPos, state);
        }
    }

    public static class BlockWrapper
    implements IFluidTransfer {
        protected final class_2680 state;
        protected final class_1937 world;
        protected final class_2338 blockPos;

        public BlockWrapper(class_2680 state, class_1937 world, class_2338 blockPos) {
            this.state = state;
            this.world = world;
            this.blockPos = blockPos;
        }

        @Override
        public int getTanks() {
            return 1;
        }

        @Override
        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.empty();
        }

        @Override
        public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
            this.fill(0, fluidStack, false, false);
        }

        @Override
        public long getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        @Override
        @Nonnull
        public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
            return FluidStack.empty();
        }

        @Override
        public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
            if (resource.getAmount() < FluidHelper.getBucket()) {
                return 0L;
            }
            if (!simulate) {
                FluidTransferHelper.destroyBlockOnFluidPlacement(this.world, this.blockPos);
                this.world.method_8652(this.blockPos, this.state, 11);
            }
            return FluidHelper.getBucket();
        }

        @Override
        public boolean supportsFill(int tank) {
            return true;
        }

        @Override
        public boolean supportsDrain(int tank) {
            return false;
        }

        @Override
        @NotNull
        public Object createSnapshot() {
            return this.state;
        }

        @Override
        public void restoreFromSnapshot(Object snapshot) {
            this.world.method_8501(this.blockPos, this.state);
        }
    }
}

