/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.misc;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class ItemTransferList
implements IItemTransfer,
ITagSerializable<class_2487> {
    public final IItemTransfer[] transfers;
    protected Predicate<class_1799> filter = item -> true;

    public ItemTransferList(IItemTransfer ... transfers) {
        this.transfers = transfers;
    }

    public ItemTransferList(List<IItemTransfer> transfers) {
        this.transfers = (IItemTransfer[])transfers.toArray(IItemTransfer[]::new);
    }

    @Override
    public int getSlots() {
        return Arrays.stream(this.transfers).mapToInt(IItemTransfer::getSlots).sum();
    }

    @Override
    @NotNull
    public class_1799 getStackInSlot(int slot) {
        int index = 0;
        for (IItemTransfer transfer : this.transfers) {
            if (slot - index < transfer.getSlots()) {
                return transfer.getStackInSlot(slot - index);
            }
            index += transfer.getSlots();
        }
        return class_1799.field_8037;
    }

    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        int index = 0;
        for (IItemTransfer transfer : this.transfers) {
            if (slot - index < transfer.getSlots()) {
                transfer.setStackInSlot(slot - index, stack);
                return;
            }
            index += transfer.getSlots();
        }
    }

    @Override
    @NotNull
    public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate, boolean notifyChanges) {
        if (!this.filter.test(stack)) {
            return stack;
        }
        int index = 0;
        for (IItemTransfer transfer : this.transfers) {
            if (slot - index < transfer.getSlots()) {
                return transfer.insertItem(slot - index, stack, simulate, notifyChanges);
            }
            index += transfer.getSlots();
        }
        return stack;
    }

    @Override
    @NotNull
    public class_1799 extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
        int index = 0;
        for (IItemTransfer transfer : this.transfers) {
            if (slot - index < transfer.getSlots()) {
                return transfer.extractItem(slot - index, amount, simulate, notifyChanges);
            }
            index += transfer.getSlots();
        }
        return class_1799.field_8037;
    }

    @Override
    public int getSlotLimit(int slot) {
        int index = 0;
        for (IItemTransfer transfer : this.transfers) {
            if (slot - index < transfer.getSlots()) {
                return transfer.getSlotLimit(slot - index);
            }
            index += transfer.getSlots();
        }
        return 0;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        if (!this.filter.test(stack)) {
            return false;
        }
        int index = 0;
        for (IItemTransfer transfer : this.transfers) {
            if (slot - index < transfer.getSlots()) {
                return transfer.isItemValid(slot - index, stack);
            }
            index += transfer.getSlots();
        }
        return false;
    }

    @Override
    public final void onContentsChanged() {
        for (IItemTransfer transfer : this.transfers) {
            transfer.onContentsChanged();
        }
    }

    @Override
    @NotNull
    public Object createSnapshot() {
        return Arrays.stream(this.transfers).map(IItemTransfer::createSnapshot).toArray(Object[]::new);
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
        Object[] array;
        if (snapshot instanceof Object[] && (array = (Object[])snapshot).length == this.transfers.length) {
            for (int i = 0; i < array.length; ++i) {
                this.transfers[i].restoreFromSnapshot(array[i]);
            }
        }
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();
        for (IItemTransfer transfer : this.transfers) {
            if (transfer instanceof ITagSerializable) {
                ITagSerializable serializable = (ITagSerializable)((Object)transfer);
                list.add(serializable.serializeNBT());
                continue;
            }
            LDLib.LOGGER.warn("[ItemTransferList] internal container doesn't support serialization");
        }
        tag.method_10566("slots", (class_2520)list);
        tag.method_10567("type", list.method_10601());
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        class_2499 list = nbt.method_10554("slots", (int)nbt.method_10571("type"));
        for (int i = 0; i < list.size(); ++i) {
            IItemTransfer iItemTransfer = this.transfers[i];
            if (iItemTransfer instanceof ITagSerializable) {
                ITagSerializable serializable = (ITagSerializable)((Object)iItemTransfer);
                serializable.deserializeNBT(list.method_10534(i));
                continue;
            }
            LDLib.LOGGER.warn("[ItemTransferList] internal container doesn't support serialization");
        }
    }

    public void setFilter(Predicate<class_1799> filter) {
        this.filter = filter;
    }
}

