/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.misc;

import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class ItemStackTransfer
implements IItemTransfer,
ITagSerializable<class_2487>,
IContentChangeAware {
    protected class_2371<class_1799> stacks;
    private Runnable onContentsChanged;
    private Function<class_1799, Boolean> filter;

    public ItemStackTransfer() {
        this(1);
    }

    public ItemStackTransfer(int size) {
        this.onContentsChanged = () -> {};
        this.stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    public ItemStackTransfer(class_2371<class_1799> stacks) {
        this.onContentsChanged = () -> {};
        this.stacks = stacks;
    }

    public ItemStackTransfer(class_1799 stack) {
        this((class_2371<class_1799>)class_2371.method_10212((Object)class_1799.field_8037, (Object[])new class_1799[]{stack}));
    }

    public void setSize(int size) {
        this.stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull class_1799 stack) {
        this.validateSlotIndex(slot);
        this.stacks.set(slot, (Object)stack);
    }

    @Override
    public int getSlots() {
        return this.stacks.size();
    }

    @Override
    @Nonnull
    public class_1799 getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (class_1799)this.stacks.get(slot);
    }

    @Override
    @Nonnull
    public class_1799 insertItem(int slot, @Nonnull class_1799 stack, boolean simulate, boolean notifyChanges) {
        boolean reachedLimit;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        class_1799 existing = (class_1799)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.method_7960()) {
            if (!ItemTransferHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.method_7947();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.method_7947() > limit;
        if (!simulate) {
            if (existing.method_7960()) {
                this.stacks.set(slot, (Object)(reachedLimit ? ItemTransferHelper.copyStackWithSize(stack, limit) : stack));
            } else {
                existing.method_7933(reachedLimit ? limit : stack.method_7947());
            }
            if (notifyChanges) {
                this.onContentsChanged(slot);
            }
        }
        return reachedLimit ? ItemTransferHelper.copyStackWithSize(stack, stack.method_7947() - limit) : class_1799.field_8037;
    }

    @Override
    @Nonnull
    public class_1799 extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
        if (amount == 0) {
            return class_1799.field_8037;
        }
        this.validateSlotIndex(slot);
        class_1799 existing = (class_1799)this.stacks.get(slot);
        if (existing.method_7960()) {
            return class_1799.field_8037;
        }
        int toExtract = Math.min(amount, existing.method_7914());
        if (existing.method_7947() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)class_1799.field_8037);
                if (notifyChanges) {
                    this.onContentsChanged(slot);
                }
                return existing;
            }
            return existing.method_7972();
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemTransferHelper.copyStackWithSize(existing, existing.method_7947() - toExtract));
            if (notifyChanges) {
                this.onContentsChanged(slot);
            }
        }
        return ItemTransferHelper.copyStackWithSize(existing, toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @Nonnull class_1799 stack) {
        return Math.min(this.getSlotLimit(slot), stack.method_7914());
    }

    @Override
    public boolean isItemValid(int slot, @Nonnull class_1799 stack) {
        return this.filter == null || this.filter.apply(stack) != false;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((class_1799)this.stacks.get(i)).method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            ((class_1799)this.stacks.get(i)).method_7953(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", (class_2520)nbtTagList);
        nbt.method_10569("Size", this.stacks.size());
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.setSize(nbt.method_10573("Size", 3) ? nbt.method_10550("Size") : this.stacks.size());
        class_2499 tagList = nbt.method_10554("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)class_1799.method_7915((class_2487)itemTags));
        }
        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    protected void onLoad() {
    }

    @Override
    public void onContentsChanged() {
        this.onContentsChanged.run();
    }

    public void onContentsChanged(int slot) {
        this.onContentsChanged();
    }

    @Override
    @NotNull
    public Object createSnapshot() {
        return this.stacks.stream().map(class_1799::method_7972).toArray(class_1799[]::new);
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
        class_1799[] copied;
        if (snapshot instanceof class_1799[] && (copied = (class_1799[])snapshot).length == this.stacks.size()) {
            for (int i = 0; i < this.stacks.size(); ++i) {
                this.stacks.set(i, (Object)copied[i].method_7972());
            }
        }
    }

    public ItemStackTransfer copy() {
        class_2371 copiedStack = class_2371.method_10213((int)this.stacks.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < this.stacks.size(); ++i) {
            copiedStack.set(i, (Object)((class_1799)this.stacks.get(i)).method_7972());
        }
        ItemStackTransfer copied = new ItemStackTransfer((class_2371<class_1799>)copiedStack);
        copied.setFilter(this.filter);
        return copied;
    }

    @Override
    public Runnable getOnContentsChanged() {
        return this.onContentsChanged;
    }

    @Override
    public void setOnContentsChanged(Runnable onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
    }

    public void setFilter(Function<class_1799, Boolean> filter) {
        this.filter = filter;
    }
}

