/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.misc;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class FluidTransferList
implements IFluidTransfer,
ITagSerializable<class_2487> {
    public final IFluidTransfer[] transfers;
    protected Predicate<FluidStack> filter = fluid -> true;

    public FluidTransferList(IFluidTransfer ... transfers) {
        this.transfers = transfers;
    }

    public FluidTransferList(List<IFluidTransfer> transfers) {
        this.transfers = (IFluidTransfer[])transfers.toArray(IFluidTransfer[]::new);
    }

    @Override
    public int getTanks() {
        return Arrays.stream(this.transfers).mapToInt(IFluidTransfer::getTanks).sum();
    }

    @Override
    @NotNull
    public FluidStack getFluidInTank(int tank) {
        int index = 0;
        for (IFluidTransfer transfer : this.transfers) {
            if (tank - index < transfer.getTanks()) {
                return transfer.getFluidInTank(tank - index);
            }
            index += transfer.getTanks();
        }
        return FluidStack.empty();
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        int index = 0;
        for (IFluidTransfer transfer : this.transfers) {
            if (tank - index < transfer.getTanks()) {
                transfer.setFluidInTank(tank - index, fluidStack);
                return;
            }
            index += transfer.getTanks();
        }
    }

    @Override
    public long getTankCapacity(int tank) {
        int index = 0;
        for (IFluidTransfer transfer : this.transfers) {
            if (tank - index < transfer.getTanks()) {
                return transfer.getTankCapacity(tank - index);
            }
            index += transfer.getTanks();
        }
        return 0L;
    }

    @Override
    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        if (!this.filter.test(stack)) {
            return false;
        }
        int index = 0;
        for (IFluidTransfer transfer : this.transfers) {
            if (tank - index < transfer.getTanks()) {
                return transfer.isFluidValid(tank - index, stack);
            }
            index += transfer.getTanks();
        }
        return false;
    }

    @Override
    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        int index = 0;
        for (IFluidTransfer transfer : this.transfers) {
            if (tank - index < transfer.getTanks()) {
                return transfer.fill(tank - index, resource, simulate, notifyChanges);
            }
            index += transfer.getTanks();
        }
        return 0L;
    }

    @Override
    public long fill(FluidStack resource, boolean simulate, boolean notifyChange) {
        if (resource.isEmpty() || !this.filter.test(resource)) {
            return 0L;
        }
        FluidStack copied = resource.copy();
        for (IFluidTransfer transfer : this.transfers) {
            FluidStack candidate = copied.copy();
            copied.shrink(transfer.fill(candidate, simulate, notifyChange));
            if (copied.isEmpty()) break;
        }
        return resource.getAmount() - copied.getAmount();
    }

    @Override
    @NotNull
    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        int index = 0;
        for (IFluidTransfer transfer : this.transfers) {
            if (tank - index < transfer.getTanks()) {
                return transfer.drain(tank - index, resource, simulate, notifyChanges);
            }
            index += transfer.getTanks();
        }
        return FluidStack.empty();
    }

    @Override
    @NotNull
    public FluidStack drain(FluidStack resource, boolean simulate, boolean notifyChange) {
        if (resource.isEmpty() || !this.filter.test(resource)) {
            return FluidStack.empty();
        }
        FluidStack copied = resource.copy();
        for (IFluidTransfer transfer : this.transfers) {
            FluidStack candidate = copied.copy();
            copied.shrink(transfer.drain(candidate, simulate, notifyChange).getAmount());
            if (copied.isEmpty()) break;
        }
        copied.setAmount(resource.getAmount() - copied.getAmount());
        return copied;
    }

    @Override
    @NotNull
    public FluidStack drain(long maxDrain, boolean simulate, boolean notifyChange) {
        if (maxDrain == 0L) {
            return FluidStack.empty();
        }
        FluidStack totalDrained = null;
        for (IFluidTransfer storage : this.transfers) {
            if (totalDrained == null || totalDrained.isEmpty()) {
                totalDrained = storage.drain(maxDrain, simulate, notifyChange);
                if (totalDrained.isEmpty()) {
                    totalDrained = null;
                } else {
                    maxDrain -= totalDrained.getAmount();
                }
            } else {
                FluidStack copy = totalDrained.copy();
                copy.setAmount(maxDrain);
                FluidStack drain = storage.drain(copy, simulate, notifyChange);
                totalDrained.grow(drain.getAmount());
                maxDrain -= drain.getAmount();
            }
            if (maxDrain <= 0L) break;
        }
        return totalDrained == null ? FluidStack.empty() : totalDrained;
    }

    @Override
    public final void onContentsChanged() {
        for (IFluidTransfer transfer : this.transfers) {
            transfer.onContentsChanged();
        }
    }

    @Override
    @NotNull
    public Object createSnapshot() {
        return Arrays.stream(this.transfers).map(IFluidTransfer::createSnapshot).toArray(Object[]::new);
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
        Object[] array;
        if (snapshot instanceof Object[] && (array = (Object[])snapshot).length == this.transfers.length) {
            for (int i = 0; i < array.length; ++i) {
                this.transfers[i].restoreFromSnapshot(array[i]);
            }
        }
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();
        for (IFluidTransfer transfer : this.transfers) {
            if (transfer instanceof ITagSerializable) {
                ITagSerializable serializable = (ITagSerializable)((Object)transfer);
                list.add(serializable.serializeNBT());
                continue;
            }
            LDLib.LOGGER.warn("[FluidTransferList] internal tank doesn't support serialization");
        }
        tag.method_10566("tanks", (class_2520)list);
        tag.method_10567("type", list.method_10601());
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        class_2499 list = nbt.method_10554("tanks", (int)nbt.method_10571("type"));
        for (int i = 0; i < list.size(); ++i) {
            IFluidTransfer iFluidTransfer = this.transfers[i];
            if (iFluidTransfer instanceof ITagSerializable) {
                ITagSerializable serializable = (ITagSerializable)((Object)iFluidTransfer);
                serializable.deserializeNBT(list.method_10534(i));
                continue;
            }
            LDLib.LOGGER.warn("[FluidTransferList] internal tank doesn't support serialization");
        }
    }

    @Override
    public boolean supportsFill(int tank) {
        for (IFluidTransfer transfer : this.transfers) {
            if (tank >= transfer.getTanks()) {
                tank -= transfer.getTanks();
                continue;
            }
            return transfer.supportsFill(tank);
        }
        return false;
    }

    @Override
    public boolean supportsDrain(int tank) {
        for (IFluidTransfer transfer : this.transfers) {
            if (tank >= transfer.getTanks()) {
                tank -= transfer.getTanks();
                continue;
            }
            return transfer.supportsDrain(tank);
        }
        return false;
    }

    public void setFilter(Predicate<FluidStack> filter) {
        this.filter = filter;
    }
}

