/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.misc;

import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.mixin.transfer.BucketItemAccessor;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_3610;
import org.jetbrains.annotations.NotNull;

public class BucketPickupTransfer
implements IFluidTransfer {
    protected final class_2263 bucketPickupHandler;
    protected final class_1937 world;
    protected final class_2338 blockPos;

    public BucketPickupTransfer(class_2263 bucketPickupHandler, class_1937 world, class_2338 blockPos) {
        this.bucketPickupHandler = bucketPickupHandler;
        this.world = world;
        this.blockPos = blockPos;
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        class_3610 fluidState;
        if (tank == 0 && !(fluidState = this.world.method_8316(this.blockPos)).method_15769()) {
            return FluidStack.create(fluidState.method_15772(), FluidHelper.getBucket());
        }
        return FluidStack.empty();
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
    }

    @Override
    public long getTankCapacity(int tank) {
        return FluidHelper.getBucket();
    }

    @Override
    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    @Override
    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        return 0L;
    }

    @Override
    @Nonnull
    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        class_3610 fluidState;
        if (!resource.isEmpty() && FluidHelper.getBucket() <= resource.getAmount() && !(fluidState = this.world.method_8316(this.blockPos)).method_15769() && resource.getFluid() == fluidState.method_15772()) {
            if (!simulate) {
                class_1792 class_17922;
                class_1799 itemStack = this.bucketPickupHandler.method_9700((class_1936)this.world, this.blockPos, this.world.method_8320(this.blockPos));
                if (itemStack != class_1799.field_8037 && (class_17922 = itemStack.method_7909()) instanceof BucketItemAccessor) {
                    BucketItemAccessor bucket = (BucketItemAccessor)class_17922;
                    FluidStack extracted = FluidStack.create(bucket.fabric_getFluid(), FluidHelper.getBucket());
                    if (!resource.isFluidEqual(extracted)) {
                        return FluidStack.empty();
                    }
                    return extracted;
                }
            } else {
                FluidStack extracted = FluidStack.create(fluidState.method_15772(), FluidHelper.getBucket());
                if (resource.isFluidEqual(extracted)) {
                    return extracted;
                }
            }
        }
        return FluidStack.empty();
    }

    @Override
    public boolean supportsFill(int tank) {
        return false;
    }

    @Override
    public boolean supportsDrain(int tank) {
        return true;
    }

    @Override
    @NotNull
    public Object createSnapshot() {
        return new Object();
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
    }
}

