/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.json;

import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.ShaderTexture;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class SimpleIGuiTextureJsonUtils {
    /*
     * Enabled aggressive block sorting
     */
    public static JsonObject toJson(IGuiTexture texture) {
        JsonObject jsonObject = new JsonObject();
        if (texture instanceof ResourceTexture) {
            ResourceTexture resourceTexture = (ResourceTexture)texture;
            jsonObject.addProperty("type", "resource");
            jsonObject.addProperty("res", resourceTexture.imageLocation.toString());
            return jsonObject;
        }
        if (texture instanceof ItemStackTexture) {
            ItemStackTexture itemStackTexture = (ItemStackTexture)texture;
            if (itemStackTexture.itemStack.length > 0) {
                jsonObject.addProperty("type", "item");
                jsonObject.addProperty("res", class_7923.field_41178.method_10221((Object)itemStackTexture.itemStack[0].method_7909()).toString());
                return jsonObject;
            }
        }
        if (!(texture instanceof ShaderTexture)) return jsonObject;
        ShaderTexture shaderTexture = (ShaderTexture)texture;
        if (shaderTexture.location == null) return jsonObject;
        jsonObject.addProperty("type", "shader");
        jsonObject.addProperty("res", shaderTexture.location.toString());
        return jsonObject;
    }

    public static IGuiTexture fromJson(JsonObject jsonObject) {
        return switch (jsonObject.get("type").getAsString()) {
            case "resource" -> new ResourceTexture(jsonObject.get("res").getAsString());
            case "item" -> new ItemStackTexture((class_1792)class_7923.field_41178.method_10223(new class_2960(jsonObject.get("res").getAsString())));
            case "shader" -> ShaderTexture.createShader(new class_2960(jsonObject.get("res").getAsString()));
            default -> IGuiTexture.EMPTY;
        };
    }
}

