/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.jei;

import com.lowdragmc.lowdraglib.core.mixins.jei.RecipeSlotAccessor;
import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.RecipeLayoutWrapper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.library.gui.ingredients.RecipeSlot;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_6328;
import net.minecraft.class_768;
import org.jetbrains.annotations.Unmodifiable;

@class_6328
@ParametersAreNonnullByDefault
public class RecipeSlotWrapper
extends RecipeSlot {
    private final Widget widget;
    private final RecipeSlot wrapperSlot;
    private ImmutableRect2i area;

    public RecipeSlotWrapper(Widget widget, RecipeSlot wrapperSlot, int xPos, int yPos) {
        super(((RecipeSlotAccessor)wrapperSlot).getIngredientManager(), wrapperSlot.getRole(), 0, 0, 0);
        this.widget = widget;
        this.wrapperSlot = wrapperSlot;
        this.area = new ImmutableRect2i(xPos, yPos, widget.getSize().width, widget.getSize().height);
        ((RecipeSlotAccessor)((Object)this)).setArea(this.area);
        ((RecipeSlotAccessor)wrapperSlot).setArea(this.area);
        if (widget instanceof IRecipeIngredientSlot) {
            IRecipeIngredientSlot slot = (IRecipeIngredientSlot)((Object)widget);
            slot.clearTooltipCallback();
        }
    }

    public @Unmodifiable Stream<ITypedIngredient<?>> getAllIngredients() {
        return this.wrapperSlot.getAllIngredients();
    }

    public boolean isEmpty() {
        return this.wrapperSlot.isEmpty();
    }

    public <T> Stream<T> getIngredients(IIngredientType<T> ingredientType) {
        return this.wrapperSlot.getIngredients(ingredientType);
    }

    public Optional<ITypedIngredient<?>> getDisplayedIngredient() {
        return this.getDisplayIngredient();
    }

    public <T> Optional<T> getDisplayedIngredient(IIngredientType<T> ingredientType) {
        return this.wrapperSlot.getDisplayedIngredient(ingredientType);
    }

    public Optional<String> getSlotName() {
        return this.wrapperSlot.getSlotName();
    }

    public RecipeIngredientRole getRole() {
        return this.wrapperSlot.getRole();
    }

    public void drawHighlight(class_332 guiGraphics, int color) {
        int x = this.area.getX();
        int y = this.area.getY();
        int width = this.area.getWidth();
        int height = this.area.getHeight();
        RenderSystem.disableDepthTest();
        guiGraphics.method_25294(x, y, x + width, y + height, color);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setBackground(IDrawable background) {
        this.wrapperSlot.setBackground(background);
    }

    public void setOverlay(IDrawable overlay) {
        this.wrapperSlot.setOverlay(overlay);
    }

    public void set(List<Optional<ITypedIngredient<?>>> ingredients, Set<Integer> focusMatches, IIngredientVisibility ingredientVisibility) {
        this.wrapperSlot.set(ingredients, focusMatches, ingredientVisibility);
    }

    public List<class_2561> getTooltip() {
        return this.wrapperSlot.getTooltip();
    }

    public void addTooltipCallback(IRecipeSlotTooltipCallback tooltipCallback) {
        this.wrapperSlot.addTooltipCallback(tooltipCallback);
        if (this.widget instanceof IRecipeIngredientSlot) {
            ((IRecipeIngredientSlot)((Object)this.widget)).addTooltipCallback((List<class_2561> tooltips) -> {
                ArrayList additional = new ArrayList();
                tooltipCallback.onTooltip((IRecipeSlotView)this, additional);
                tooltips.addAll(additional);
            });
        }
    }

    public <T> void addRenderOverride(IIngredientType<T> ingredientType, IIngredientRenderer<T> ingredientRenderer) {
        this.wrapperSlot.addRenderOverride(ingredientType, ingredientRenderer);
    }

    public void draw(class_332 guiGraphics) {
        this.wrapperSlot.draw(guiGraphics);
    }

    public void drawHoverOverlays(class_332 guiGraphics) {
        this.wrapperSlot.drawHoverOverlays(guiGraphics);
    }

    public class_768 getRect() {
        return this.area.toMutable();
    }

    public void setSlotName(String slotName) {
        this.wrapperSlot.setSlotName(slotName);
    }

    public void onPositionUpdate(RecipeLayoutWrapper<?> layoutWrapper) {
        this.area = new ImmutableRect2i(this.widget.getPosition().x - layoutWrapper.getWrapper().getLeft(), this.widget.getPosition().y - layoutWrapper.getWrapper().getTop(), this.widget.getSize().width, this.widget.getSize().height);
        ((RecipeSlotAccessor)((Object)this)).setArea(this.area);
        ((RecipeSlotAccessor)this.wrapperSlot).setArea(this.area);
    }

    private Optional<ITypedIngredient<?>> getDisplayIngredient() {
        Widget widget = this.widget;
        if (widget instanceof IRecipeIngredientSlot) {
            IRecipeIngredientSlot slot = (IRecipeIngredientSlot)((Object)widget);
            List<Object> ingredients = slot.getXEIIngredients();
            for (Object ingredient : ingredients) {
                if (!(ingredient instanceof IClickableIngredient)) continue;
                IClickableIngredient clickableIngredient = (IClickableIngredient)ingredient;
                return Optional.of(clickableIngredient.getTypedIngredient());
            }
        }
        return Optional.empty();
    }
}

