/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.jei;

import com.lowdragmc.lowdraglib.core.mixins.jei.RecipeLayoutAccessor;
import com.lowdragmc.lowdraglib.core.mixins.jei.RecipeSlotsAccessor;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import com.lowdragmc.lowdraglib.jei.RecipeSlotWrapper;
import com.lowdragmc.lowdraglib.utils.Position;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryDecorator;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.library.gui.ingredients.RecipeSlot;
import mezz.jei.library.gui.ingredients.RecipeSlotsView;
import mezz.jei.library.gui.recipes.RecipeLayout;
import mezz.jei.library.gui.recipes.RecipeLayoutBuilder;
import mezz.jei.library.gui.recipes.ShapelessIcon;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_768;
import org.jetbrains.annotations.NotNull;

public class RecipeLayoutWrapper<R>
extends RecipeLayout<R> {
    private static final int RECIPE_BORDER_PADDING = 4;
    private final RecipeLayoutAccessor accessor = (RecipeLayoutAccessor)((Object)this);
    private final ModularWrapper<?> wrapper;

    public static <T> RecipeLayout<T> createWrapper(IRecipeCategory<T> recipeCategory, Collection<IRecipeCategoryDecorator<T>> decorators, T recipe, IFocusGroup focuses, IIngredientManager ingredientManager, IIngredientVisibility ingredientVisibility, IModIdHelper modIdHelper, Textures textures) {
        RecipeLayoutWrapper<T> wrapper = new RecipeLayoutWrapper<T>(recipeCategory, decorators, recipe, ingredientManager, modIdHelper, textures);
        if (wrapper.setRecipeLayout(recipeCategory, recipe, focuses, ingredientVisibility)) {
            return wrapper;
        }
        return null;
    }

    public void setPosition(int posX, int posY) {
        super.setPosition(posX, posY);
        ModularWrapper<?> recipe = this.getWrapper();
        recipe.setRecipeLayout(posX, posY);
        ArrayList<RecipeSlot> recipeSlots = new ArrayList<RecipeSlot>();
        List<Widget> allWidgets = recipe.modularUI.getFlatWidgetCollection();
        for (RecipeSlot slot : this.getRecipeSlots().getSlots()) {
            class_768 rect = slot.getRect();
            Widget widget = allWidgets.get(rect.method_3321());
            Position position = widget.getPosition();
            recipeSlots.add(new RecipeSlotWrapper(widget, slot, position.x - posX, position.y - posY));
        }
        String uid = recipe.getUid();
        if (uid != null) {
            this.addOutputTooltips(recipeSlots, uid);
        }
        this.setRecipeSlots(recipeSlots);
    }

    private boolean setRecipeLayout(IRecipeCategory<R> recipeCategory, R recipe, IFocusGroup focuses, IIngredientVisibility ingredientVisibility) {
        RecipeLayoutBuilder builder = new RecipeLayoutBuilder(this.accessor.getIngredientManager(), this.accessor.getIngredientCycleOffset());
        try {
            recipeCategory.setRecipe((IRecipeLayoutBuilder)builder, recipe, focuses);
            if (builder.isUsed()) {
                builder.setRecipeLayout((RecipeLayout)this, focuses, ingredientVisibility);
                return true;
            }
        }
        catch (LinkageError | RuntimeException e) {
            this.accessor.getLogger().error("Error caught from Recipe Category: {}", (Object)recipeCategory.getRecipeType().getUid(), (Object)e);
        }
        return false;
    }

    private void setRecipeSlots(List<RecipeSlot> recipeSlots) {
        ((RecipeSlotsAccessor)this.getRecipeSlots()).setSlots(recipeSlots);
        ((RecipeSlotsAccessor)this.getRecipeSlots()).setView((IRecipeSlotsView)new RecipeSlotsView(recipeSlots));
    }

    public RecipeLayoutWrapper(IRecipeCategory<R> recipeCategory, Collection<IRecipeCategoryDecorator<R>> decorators, R recipe, IIngredientManager ingredientManager, IModIdHelper modIdHelper, Textures textures) {
        super(recipeCategory, decorators, recipe, ingredientManager, modIdHelper, textures);
        this.wrapper = (ModularWrapper)((Object)recipe);
    }

    public ModularWrapper<?> getWrapper() {
        return this.wrapper;
    }

    public void drawRecipe(@Nonnull class_332 graphics, int mouseX, int mouseY) {
        IRecipeCategory recipeCategory = this.getRecipeCategory();
        IDrawable background = recipeCategory.getBackground();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int posX = this.accessor.getPosX();
        int posY = this.accessor.getPosY();
        int recipeMouseX = mouseX - posX;
        int recipeMouseY = mouseY - posY;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)posX, (float)posY, 0.0f);
        IDrawable categoryBackground = recipeCategory.getBackground();
        int width = categoryBackground.getWidth() + 8;
        int height = categoryBackground.getHeight() + 8;
        this.accessor.getRecipeBorder().draw(graphics, -4, -4, width, height);
        background.draw(graphics);
        graphics.method_51448().method_22903();
        this.wrapper.draw(graphics, recipeMouseX, recipeMouseY, class_310.method_1551().method_1534());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_51448().method_22909();
        ShapelessIcon shapelessIcon = this.accessor.getShapelessIcon();
        if (shapelessIcon != null) {
            shapelessIcon.draw(graphics);
        }
        graphics.method_51448().method_22909();
        RenderSystem.disableBlend();
    }

    public void drawOverlays(@Nonnull @NotNull class_332 graphics, int mouseX, int mouseY) {
        if (this.wrapper.tooltipTexts != null && !this.wrapper.tooltipTexts.isEmpty()) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 240.0f);
            graphics.method_51437(class_310.method_1551().field_1772, this.wrapper.tooltipTexts, Optional.ofNullable(this.wrapper.tooltipComponent), mouseX, mouseY);
            graphics.method_51448().method_22909();
        }
    }

    public void onPositionUpdate() {
        this.getRecipeSlots().getSlots().stream().filter(RecipeSlotWrapper.class::isInstance).map(RecipeSlotWrapper.class::cast).forEach(slotWrapper -> slotWrapper.onPositionUpdate(this));
    }

    private void addOutputTooltips(List<RecipeSlot> recipeSlots, String uid) {
        List<RecipeSlot> outputSlots = recipeSlots.stream().filter(r -> r.getRole() == RecipeIngredientRole.OUTPUT).toList();
        if (outputSlots.isEmpty()) {
            return;
        }
        for (RecipeSlot outputSlot : outputSlots) {
            outputSlot.addTooltipCallback((IRecipeSlotTooltipCallback)new RegisterNameTooltipCallback(uid, this.accessor.getModIdHelper()));
        }
    }

    private static class RegisterNameTooltipCallback
    implements IRecipeSlotTooltipCallback {
        private final class_2960 uid;
        private final IModIdHelper modIdHelper;

        private RegisterNameTooltipCallback(String uid, IModIdHelper modIdHelper) {
            this.uid = new class_2960(uid);
            this.modIdHelper = modIdHelper;
        }

        public void onTooltip(@NotNull IRecipeSlotView recipeSlotView, @NotNull List<class_2561> tooltip) {
            boolean showAdvanced;
            if (recipeSlotView.getRole() != RecipeIngredientRole.OUTPUT) {
                return;
            }
            if (this.modIdHelper.isDisplayingModNameEnabled()) {
                String modName = this.modIdHelper.getFormattedModNameForModId(this.uid.method_12836());
                class_5250 recipeBy = class_2561.method_43469((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName});
                tooltip.add((class_2561)recipeBy.method_27692(class_124.field_1080));
            }
            class_310 minecraft = class_310.method_1551();
            boolean bl = showAdvanced = minecraft.field_1690.field_1827 || class_437.method_25442();
            if (showAdvanced) {
                String recipeUid = "minecraft".equals(this.uid.method_12836()) ? this.uid.method_12832() : this.uid.toString();
                class_5250 recipeId = class_2561.method_43469((String)"jei.tooltip.recipe.id", (Object[])new Object[]{recipeUid});
                tooltip.add((class_2561)recipeId.method_27692(class_124.field_1063));
            }
        }
    }
}

