/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.jei;

import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IClickableIngredient;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
public abstract class ModularUIRecipeCategory<T extends ModularWrapper<?>>
implements IRecipeCategory<T> {
    public void setRecipe(IRecipeLayoutBuilder builder, T wrapper, IFocusGroup focuses) {
        List<Widget> flatVisibleWidgetCollection = ((ModularWrapper)((Object)wrapper)).modularUI.getFlatWidgetCollection();
        for (int i = 0; i < flatVisibleWidgetCollection.size(); ++i) {
            Widget widget = flatVisibleWidgetCollection.get(i);
            if (!(widget instanceof IRecipeIngredientSlot)) continue;
            IRecipeIngredientSlot slot = (IRecipeIngredientSlot)((Object)widget);
            RecipeIngredientRole role = this.mapToRole(slot.getIngredientIO());
            if (role == null) {
                ModularUIRecipeCategory.addJEISlot(builder, slot, RecipeIngredientRole.INPUT, i);
                ModularUIRecipeCategory.addJEISlot(builder, slot, RecipeIngredientRole.OUTPUT, i);
                continue;
            }
            ModularUIRecipeCategory.addJEISlot(builder, slot, role, i);
        }
    }

    private static void addJEISlot(IRecipeLayoutBuilder builder, IRecipeIngredientSlot slot, RecipeIngredientRole role, int index) {
        IRecipeSlotBuilder slotBuilder = builder.addSlot(role, index, -1);
        HashMap<IIngredientType, List> map = new HashMap<IIngredientType, List>();
        slot.getXEIIngredients().stream().filter(IClickableIngredient.class::isInstance).map(IClickableIngredient.class::cast).forEach(clickableIngredient -> map.computeIfAbsent(clickableIngredient.getTypedIngredient().getType(), a -> new ArrayList()).add(clickableIngredient.getTypedIngredient().getIngredient()));
        map.forEach((ingredient, list) -> slotBuilder.addIngredients(ingredient, list));
    }

    @Nullable
    private RecipeIngredientRole mapToRole(IngredientIO ingredientIO) {
        return switch (ingredientIO) {
            default -> throw new IncompatibleClassChangeError();
            case IngredientIO.INPUT -> RecipeIngredientRole.INPUT;
            case IngredientIO.OUTPUT -> RecipeIngredientRole.OUTPUT;
            case IngredientIO.CATALYST -> RecipeIngredientRole.CATALYST;
            case IngredientIO.RENDER_ONLY -> RecipeIngredientRole.RENDER_ONLY;
            case IngredientIO.BOTH -> null;
        };
    }
}

