/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.google.common.base.Preconditions;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.animation.Animation;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.lowdragmc.lowdraglib.gui.modular.WidgetUIAccess;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Rect;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_6880;
import net.minecraft.class_768;

@Configurable(name="ldlib.gui.editor.group.basic_info")
public class Widget {
    protected ModularUI gui;
    protected WidgetUIAccess uiAccess;
    @Configurable(tips={"ldlib.gui.editor.tips.id"})
    protected String id = "";
    private Position parentPosition = Position.ORIGIN;
    @Configurable(name="ldlib.gui.editor.name.pos", tips={"ldlib.gui.editor.tips.pos"})
    private Position selfPosition;
    private Position position;
    @Configurable
    private Size size;
    private boolean isVisible;
    private boolean isActive;
    private boolean isFocus;
    protected boolean isClientSideWidget;
    @Configurable(name="ldlib.gui.editor.name.hover_tips", tips={"ldlib.gui.editor.tips.hover_tips"})
    protected final List<class_2561> tooltipTexts = new ArrayList<class_2561>();
    @Configurable(name="ldlib.gui.editor.name.background")
    protected IGuiTexture backgroundTexture;
    @Configurable(name="ldlib.gui.editor.name.hover_texture")
    protected IGuiTexture hoverTexture;
    protected WidgetGroup parent;
    protected Animation animation;
    protected boolean initialized;
    protected boolean tryToDrag = false;
    protected Supplier<Object> draggingProvider;
    protected BiFunction<Object, Position, IGuiTexture> draggingRenderer;
    protected Predicate<Object> draggingAccept = o -> false;
    protected Consumer<Object> draggingIn;
    protected Consumer<Object> draggingOut;
    protected Consumer<Object> draggingSuccess;
    protected Object draggingElement;

    public Widget(Position selfPosition, Size size) {
        Preconditions.checkNotNull((Object)selfPosition, (Object)"selfPosition");
        Preconditions.checkNotNull((Object)size, (Object)"size");
        this.selfPosition = selfPosition;
        this.size = size;
        this.position = this.parentPosition.add(selfPosition);
        this.isVisible = true;
        this.isActive = true;
    }

    public Widget(int x, int y, int width, int height) {
        this(new Position(x, y), new Size(width, height));
    }

    public Widget setClientSideWidget() {
        this.isClientSideWidget = true;
        return this;
    }

    public Widget setHoverTooltips(String ... tooltipText) {
        this.tooltipTexts.clear();
        Arrays.stream(tooltipText).filter(Objects::nonNull).filter(s -> !s.isEmpty()).map(class_2561::method_43471).forEach(this.tooltipTexts::add);
        return this;
    }

    public Widget setHoverTooltips(class_2561 ... tooltipText) {
        this.tooltipTexts.clear();
        Arrays.stream(tooltipText).filter(Objects::nonNull).forEach(this.tooltipTexts::add);
        return this;
    }

    public Widget setHoverTooltips(List<class_2561> tooltipText) {
        this.tooltipTexts.clear();
        this.tooltipTexts.addAll(tooltipText);
        return this;
    }

    public Widget setKJSHoverTooltips(class_2561 ... tooltipText) {
        this.tooltipTexts.clear();
        Arrays.stream(tooltipText).filter(Objects::nonNull).forEach(this.tooltipTexts::add);
        return this;
    }

    public Widget setBackground(IGuiTexture ... backgroundTexture) {
        this.backgroundTexture = backgroundTexture.length > 1 ? new GuiTextureGroup(backgroundTexture) : backgroundTexture[0];
        return this;
    }

    public Widget setHoverTexture(IGuiTexture ... hoverTexture) {
        this.hoverTexture = hoverTexture.length > 1 ? new GuiTextureGroup(hoverTexture) : hoverTexture[0];
        return this;
    }

    public <T> Widget setDraggingProvider(Supplier<T> draggingProvider, BiFunction<T, Position, IGuiTexture> draggingRenderer) {
        this.draggingProvider = draggingProvider;
        this.draggingRenderer = draggingRenderer;
        return this;
    }

    public Widget setDraggingConsumer(Predicate<Object> draggingAccept, Consumer<Object> draggingIn, Consumer<Object> draggingOut, Consumer<Object> draggingSuccess) {
        this.draggingAccept = draggingAccept;
        this.draggingIn = draggingIn;
        this.draggingOut = draggingOut;
        this.draggingSuccess = draggingSuccess;
        return this;
    }

    public void animation(Animation animation) {
        if (this.isRemote()) {
            this.animation = animation;
            this.animation.setWidget(this);
        } else {
            Runnable runnable = animation.getOnFinish();
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public boolean inAnimate() {
        return this.animation != null && !this.animation.isFinish();
    }

    public void setGui(ModularUI gui) {
        this.gui = gui;
    }

    public ModularUI getGui() {
        return this.gui;
    }

    public void setUiAccess(WidgetUIAccess uiAccess) {
        this.uiAccess = uiAccess;
    }

    public void setParentPosition(Position parentPosition) {
        this.parentPosition = parentPosition;
        this.recomputePosition();
    }

    @ConfigSetter(field="selfPosition")
    public void setSelfPosition(Position selfPosition) {
        this.selfPosition = selfPosition;
        this.recomputePosition();
        if (this.isParent(this.parent)) {
            this.parent.onChildSelfPositionUpdate(this);
        }
    }

    public Position addSelfPosition(int addX, int addY) {
        this.setSelfPosition(new Position(this.selfPosition.x + addX, this.selfPosition.y + addY));
        return this.selfPosition;
    }

    public Position getSelfPosition() {
        return this.selfPosition;
    }

    @ConfigSetter(field="size")
    public void setSize(Size size) {
        if (this.size.equals(size)) {
            return;
        }
        this.size = size;
        this.onSizeUpdate();
        if (this.isParent(this.parent)) {
            this.parent.onChildSizeUpdate(this);
        }
    }

    public final Position getPosition() {
        return this.position;
    }

    public final Size getSize() {
        return this.size;
    }

    public final Rect getRect() {
        return Rect.of(this.position, this.size);
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    @Environment(value=EnvType.CLIENT)
    public class_768 toRectangleBox() {
        Position pos = this.getPosition();
        Size size = this.getSize();
        return new class_768(pos.x, pos.y, size.width, size.height);
    }

    protected void recomputePosition() {
        this.position = this.parentPosition.add(this.selfPosition);
        this.onPositionUpdate();
    }

    protected void onPositionUpdate() {
    }

    protected void onSizeUpdate() {
    }

    public boolean isMouseOverElement(double mouseX, double mouseY) {
        Position position = this.getPosition();
        Size size = this.getSize();
        return Widget.isMouseOver(position.x, position.y, size.width, size.height, mouseX, mouseY);
    }

    @Nullable
    public Widget getHoverElement(double mouseX, double mouseY) {
        Position position = this.getPosition();
        Size size = this.getSize();
        if (Widget.isMouseOver(position.x, position.y, size.width, size.height, mouseX, mouseY)) {
            return this;
        }
        return null;
    }

    public static boolean isMouseOver(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseY >= (double)y && (double)(x + width) > mouseX && (double)(y + height) > mouseY;
    }

    public Position getParentPosition() {
        return this.parentPosition;
    }

    public WidgetGroup getParent() {
        return this.parent;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initWidget() {
        this.initialized = true;
    }

    public void writeInitialData(class_2540 buffer) {
    }

    public void readInitialData(class_2540 buffer) {
    }

    public void detectAndSendChanges() {
    }

    @Environment(value=EnvType.CLIENT)
    public void updateScreen() {
        if (this.backgroundTexture != null) {
            this.backgroundTexture.updateTick();
        }
        if (this.hoverTexture != null) {
            this.hoverTexture.updateTick();
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected void drawTooltipTexts(int mouseX, int mouseY) {
        if (this.tooltipTexts.size() > 0 && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this && this.gui != null && this.gui.getModularUIGui() != null) {
            this.gui.getModularUIGui().setHoverTooltip(this.tooltipTexts, class_1799.field_8037, null, null);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void drawInForeground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawTooltipTexts(mouseX, mouseY);
    }

    @Environment(value=EnvType.CLIENT)
    protected void drawBackgroundTexture(@Nonnull class_332 graphics, int mouseX, int mouseY) {
        Size size;
        Position pos;
        if (this.backgroundTexture != null) {
            pos = this.getPosition();
            size = this.getSize();
            this.backgroundTexture.draw(graphics, mouseX, mouseY, pos.x, pos.y, size.width, size.height);
        }
        if (this.hoverTexture != null && this.isMouseOverElement(mouseX, mouseY)) {
            pos = this.getPosition();
            size = this.getSize();
            this.hoverTexture.draw(graphics, mouseX, mouseY, pos.x, pos.y, size.width, size.height);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawBackgroundTexture(graphics, mouseX, mouseY);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.draggingElement = null;
        this.tryToDrag = false;
        if (this.draggingProvider != null && this.isMouseOverElement(mouseX, mouseY)) {
            this.tryToDrag = true;
            return false;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Object element;
        if (!this.isMouseOverElement(mouseX, mouseY) && this.tryToDrag && this.draggingProvider != null && this.draggingRenderer != null && (element = this.draggingProvider.get()) != null) {
            this.getGui().getModularUIGui().setDraggingElement(element, this.draggingRenderer.apply(element, new Position((int)mouseX, (int)mouseY)));
        }
        if (this.isMouseOverElement(mouseX, mouseY) && this.draggingAccept.test(this.getGui().getModularUIGui().getDraggingElement())) {
            element = this.getGui().getModularUIGui().getDraggingElement();
            if (this.draggingElement != element && this.draggingIn != null) {
                this.draggingElement = element;
                this.draggingIn.accept(element);
            }
            return true;
        }
        if (this.draggingElement != null && this.draggingOut != null) {
            this.draggingOut.accept(this.draggingElement);
            this.draggingElement = null;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean mouseMoved(double mouseX, double mouseY) {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        Object element;
        this.tryToDrag = false;
        if (this.isMouseOverElement(mouseX, mouseY) && this.draggingAccept.test(this.getGui().getModularUIGui().getDraggingElement()) && this.draggingElement == (element = this.getGui().getModularUIGui().getDraggingElement()) && this.draggingSuccess != null) {
            this.draggingSuccess.accept(element);
            this.draggingElement = null;
            return true;
        }
        this.draggingElement = null;
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean charTyped(char codePoint, int modifiers) {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public final void setFocus(boolean focus) {
        if (this.gui != null) {
            ModularUIGuiContainer guiContainer = this.gui.getModularUIGui();
            Widget lastFocus = guiContainer.lastFocus;
            if (!focus) {
                this.isFocus = false;
                if (guiContainer.lastFocus == this) {
                    guiContainer.lastFocus = null;
                }
                this.onFocusChanged(lastFocus, guiContainer.lastFocus);
            } else if (guiContainer.switchFocus(this)) {
                this.isFocus = true;
                this.onFocusChanged(lastFocus, guiContainer.lastFocus);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public final boolean isFocus() {
        return this.isFocus;
    }

    @Environment(value=EnvType.CLIENT)
    public void onFocusChanged(@Nullable Widget lastFocus, Widget focus) {
    }

    @Environment(value=EnvType.CLIENT)
    public void readUpdateInfo(int id, class_2540 buffer) {
    }

    public void handleClientAction(int id, class_2540 buffer) {
    }

    protected final void writeUpdateInfo(int id, Consumer<class_2540> FriendlyByteBufWriter) {
        if (this.uiAccess != null && this.gui != null) {
            this.uiAccess.writeUpdateInfo(this, id, FriendlyByteBufWriter);
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected final void writeClientAction(int id, Consumer<class_2540> FriendlyByteBufWriter) {
        if (this.uiAccess != null && !this.isClientSideWidget) {
            this.uiAccess.writeClientAction(this, id, FriendlyByteBufWriter);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void playButtonClickSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isShiftDown() {
        long id = class_310.method_1551().method_22683().method_4490();
        return class_3675.method_15987((long)id, (int)340) || class_3675.method_15987((long)id, (int)340);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isCtrlDown() {
        long id = class_310.method_1551().method_22683().method_4490();
        return class_3675.method_15987((long)id, (int)341) || class_3675.method_15987((long)id, (int)345);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isAltDown() {
        long id = class_310.method_1551().method_22683().method_4490();
        return class_3675.method_15987((long)id, (int)342) || class_3675.method_15987((long)id, (int)346);
    }

    public boolean isRemote() {
        return this.gui != null && this.gui.holder != null ? this.gui.holder.isRemote() : LDLib.isRemote();
    }

    protected void setParent(WidgetGroup parent) {
        this.parent = parent;
    }

    public boolean isParent(WidgetGroup widgetGroup) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent == widgetGroup) {
            return true;
        }
        return this.parent.isParent(widgetGroup);
    }

    @Environment(value=EnvType.CLIENT)
    public void onScreenSizeUpdate(int screenWidth, int screenHeight) {
    }

    @Environment(value=EnvType.CLIENT)
    public List<class_768> getGuiExtraAreas(class_768 guiRect, List<class_768> list) {
        class_768 rect2i = this.toRectangleBox();
        if (rect2i.method_3321() < guiRect.method_3321() || rect2i.method_3321() + rect2i.method_3319() > guiRect.method_3321() + guiRect.method_3319() || rect2i.method_3322() < guiRect.method_3322() || rect2i.method_3322() + rect2i.method_3320() > guiRect.method_3322() + guiRect.method_3320()) {
            list.add(this.toRectangleBox());
        }
        return list;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Animation getAnimation() {
        return this.animation;
    }
}

