/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;

@Configurable(name="ldlib.gui.editor.register.widget.text_field", collapse=false)
@LDLRegister(name="text_field", group="widget.basic")
public class TextFieldWidget
extends Widget
implements IConfigurableWidget {
    @Environment(value=EnvType.CLIENT)
    protected class_342 textField;
    @Configurable
    @NumberRange(range={0.0, 2.147483647E9})
    protected int maxStringLength = Integer.MAX_VALUE;
    protected Function<String, String> textValidator = s -> s;
    protected Supplier<String> textSupplier;
    protected Consumer<String> textResponder;
    @Configurable
    protected String currentString;
    @Configurable
    protected boolean isBordered;
    @Configurable
    @NumberColor
    protected int textColor = -1;
    protected float wheelDur;
    protected NumberFormat numberInstance;
    protected class_2561 hover;
    private boolean isDragging;

    public TextFieldWidget() {
        this(0, 0, 60, 15, null, null);
    }

    public TextFieldWidget(int xPosition, int yPosition, int width, int height, Supplier<String> textSupplier, Consumer<String> textResponder) {
        super(new Position(xPosition, yPosition), new Size(width, height));
        if (this.isRemote()) {
            class_327 fontRenderer = class_310.method_1551().field_1772;
            this.textField = new class_342(fontRenderer, xPosition, yPosition, width, height, (class_2561)class_2561.method_43470((String)"text field"));
            this.textField.method_1858(true);
            this.isBordered = true;
            this.textField.method_1880(this.maxStringLength);
            this.textField.method_1863(this::onTextChanged);
        }
        this.textSupplier = textSupplier;
        this.textResponder = textResponder;
    }

    public TextFieldWidget setTextSupplier(Supplier<String> textSupplier) {
        this.textSupplier = textSupplier;
        return this;
    }

    public TextFieldWidget setTextResponder(Consumer<String> textResponder) {
        this.textResponder = textResponder;
        return this;
    }

    public TextFieldWidget setBackground(IGuiTexture background) {
        super.setBackground(background);
        return this;
    }

    @ConfigSetter(field="currentString")
    public TextFieldWidget setCurrentString(Object currentString) {
        this.currentString = currentString.toString();
        if (this.isRemote() && !this.textField.method_1882().equals(currentString)) {
            this.textField.method_1852(currentString.toString());
        }
        return this;
    }

    public String getCurrentString() {
        return this.currentString == null ? "" : this.currentString;
    }

    public String getRawCurrentString() {
        if (this.isRemote()) {
            return this.textField.method_1882();
        }
        return this.getCurrentString();
    }

    @Override
    public void onFocusChanged(@Nullable Widget lastFocus, Widget focus) {
        this.textField.method_25365(this.isFocus());
    }

    @Override
    protected void onPositionUpdate() {
        if (this.isRemote() && this.textField != null) {
            int n;
            Position position = this.getPosition();
            Size size = this.getSize();
            this.textField.method_46421(this.isBordered ? position.x : position.x + 2);
            if (this.isBordered) {
                n = position.y;
            } else {
                int n2 = position.y;
                int n3 = size.height;
                Objects.requireNonNull(class_310.method_1551().field_1772);
                n = n2 + (n3 - 9) / 2 + 1;
            }
            this.textField.method_46419(n);
        }
    }

    @Override
    protected void onSizeUpdate() {
        if (this.isRemote() && this.textField != null) {
            int n;
            Position position = this.getPosition();
            Size size = this.getSize();
            this.textField.method_25358(this.isBordered ? size.width : size.width - 2);
            if (this.isBordered) {
                n = position.y;
            } else {
                int n2 = position.y;
                int n3 = this.getSize().height;
                Objects.requireNonNull(class_310.method_1551().field_1772);
                n = n2 + (n3 - 9) / 2 + 1;
            }
            this.textField.method_46419(n);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        this.textField.method_25394(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.isDragging = true;
        }
        this.setFocus(this.isMouseOverElement(mouseX, mouseY));
        this.textField.method_25365(this.isMouseOverElement(mouseX, mouseY));
        return this.textField.method_25402(mouseX, mouseY, button);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return keyCode != 256 && (this.textField.method_25404(keyCode, scanCode, modifiers) || this.isFocus());
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        return this.textField.method_25400(codePoint, modifiers);
    }

    @Override
    public void updateScreen() {
        if (this.isVisible() && this.isActive() && this.textSupplier != null && this.isClientSideWidget && !this.textSupplier.get().equals(this.getCurrentString())) {
            this.setCurrentString(this.textSupplier.get());
        }
    }

    @Override
    public void writeInitialData(class_2540 buffer) {
        super.writeInitialData(buffer);
        buffer.method_10814(this.getCurrentString());
    }

    @Override
    public void readInitialData(class_2540 buffer) {
        super.readInitialData(buffer);
        this.setCurrentString(buffer.method_19772());
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.textSupplier != null && !this.textSupplier.get().equals(this.getCurrentString())) {
            this.setCurrentString(this.textSupplier.get());
            this.writeUpdateInfo(1, buffer -> buffer.method_10814(this.getCurrentString()));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void readUpdateInfo(int id, class_2540 buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1) {
            this.setCurrentString(buffer.method_19772());
        }
    }

    protected void onTextChanged(String newTextString) {
        String lastText = this.currentString;
        String newText = this.textValidator.apply(newTextString);
        if (!newText.equals(lastText)) {
            this.textField.method_1868(this.textColor);
            this.setCurrentString(newText);
            if (this.isClientSideWidget && this.textResponder != null) {
                this.textResponder.accept(newText);
            }
            this.writeClientAction(1, buffer -> buffer.method_10814(newText));
        } else if (!newTextString.equals(newText)) {
            this.textField.method_1868(-2162688);
        } else {
            this.textField.method_1868(this.textColor);
        }
    }

    @Override
    public void handleClientAction(int id, class_2540 buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            String lastText = this.getCurrentString();
            String newText = this.textValidator.apply(buffer.method_19772());
            newText = newText.substring(0, Math.min(newText.length(), this.maxStringLength));
            if (lastText == null || !lastText.equals(newText)) {
                this.setCurrentString(newText);
                if (this.textResponder != null) {
                    this.textResponder.accept(newText);
                }
            }
        }
    }

    @ConfigSetter(field="isBordered")
    public TextFieldWidget setBordered(boolean bordered) {
        this.isBordered = bordered;
        if (this.isRemote()) {
            this.textField.method_1858(bordered);
            this.onPositionUpdate();
            this.onSizeUpdate();
        }
        return this;
    }

    @ConfigSetter(field="textColor")
    public TextFieldWidget setTextColor(int textColor) {
        this.textColor = textColor;
        if (this.isRemote()) {
            this.textField.method_1868(textColor);
        }
        return this;
    }

    @ConfigSetter(field="maxStringLength")
    public TextFieldWidget setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
        if (this.isRemote()) {
            this.textField.method_1880(maxStringLength);
        }
        return this;
    }

    public TextFieldWidget setValidator(Function<String, String> validator) {
        this.textValidator = validator;
        return this;
    }

    public TextFieldWidget setResourceLocationOnly() {
        this.setValidator(s -> {
            try {
                s = s.toLowerCase();
                s = s.replace(' ', '_');
                if (class_2960.method_20207((String)s)) {
                    return s;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return this.currentString;
        });
        this.hover = class_2561.method_43471((String)"ldlib.gui.text_field.resourcelocation");
        return this;
    }

    public TextFieldWidget setNumbersOnly(long minValue, long maxValue) {
        this.setValidator(s -> {
            try {
                if (s == null || s.isEmpty()) {
                    return "" + minValue;
                }
                long value = Long.parseLong(s);
                if (minValue <= value && value <= maxValue) {
                    return s;
                }
                if (value < minValue) {
                    return "" + minValue;
                }
                return "" + maxValue;
            }
            catch (NumberFormatException numberFormatException) {
                return this.currentString;
            }
        });
        this.hover = minValue == Long.MIN_VALUE && maxValue == Long.MAX_VALUE ? class_2561.method_43471((String)"ldlib.gui.text_field.number.3") : (minValue == Long.MIN_VALUE ? class_2561.method_43469((String)"ldlib.gui.text_field.number.2", (Object[])new Object[]{maxValue}) : (maxValue == Long.MAX_VALUE ? class_2561.method_43469((String)"ldlib.gui.text_field.number.1", (Object[])new Object[]{minValue}) : class_2561.method_43469((String)"ldlib.gui.text_field.number.0", (Object[])new Object[]{minValue, maxValue})));
        return this.setWheelDur(1.0f);
    }

    public TextFieldWidget setNumbersOnly(int minValue, int maxValue) {
        this.setValidator(s -> {
            try {
                if (s == null || s.isEmpty()) {
                    return "" + minValue;
                }
                int value = Integer.parseInt(s);
                if (minValue <= value && value <= maxValue) {
                    return s;
                }
                if (value < minValue) {
                    return "" + minValue;
                }
                return "" + maxValue;
            }
            catch (NumberFormatException numberFormatException) {
                return this.currentString;
            }
        });
        this.hover = minValue == Integer.MIN_VALUE && maxValue == Integer.MAX_VALUE ? class_2561.method_43471((String)"ldlib.gui.text_field.number.3") : (minValue == Integer.MIN_VALUE ? class_2561.method_43469((String)"ldlib.gui.text_field.number.2", (Object[])new Object[]{maxValue}) : (maxValue == Integer.MAX_VALUE ? class_2561.method_43469((String)"ldlib.gui.text_field.number.1", (Object[])new Object[]{minValue}) : class_2561.method_43469((String)"ldlib.gui.text_field.number.0", (Object[])new Object[]{minValue, maxValue})));
        return this.setWheelDur(1.0f);
    }

    public TextFieldWidget setNumbersOnly(float minValue, float maxValue) {
        this.setValidator(s -> {
            try {
                if (s == null || s.isEmpty()) {
                    return "" + minValue;
                }
                float value = Float.parseFloat(s);
                if (minValue <= value && value <= maxValue) {
                    return s;
                }
                if (value < minValue) {
                    return "" + minValue;
                }
                return "" + maxValue;
            }
            catch (NumberFormatException numberFormatException) {
                return this.currentString;
            }
        });
        this.hover = minValue == -3.4028235E38f && maxValue == Float.MAX_VALUE ? class_2561.method_43471((String)"ldlib.gui.text_field.number.3") : (minValue == -3.4028235E38f ? class_2561.method_43469((String)"ldlib.gui.text_field.number.2", (Object[])new Object[]{Float.valueOf(maxValue)}) : (maxValue == Float.MAX_VALUE ? class_2561.method_43469((String)"ldlib.gui.text_field.number.1", (Object[])new Object[]{Float.valueOf(minValue)}) : class_2561.method_43469((String)"ldlib.gui.text_field.number.0", (Object[])new Object[]{Float.valueOf(minValue), Float.valueOf(maxValue)})));
        return this.setWheelDur(0.1f);
    }

    public TextFieldWidget setWheelDur(float wheelDur) {
        this.wheelDur = wheelDur;
        this.numberInstance = NumberFormat.getNumberInstance();
        this.numberInstance.setMaximumFractionDigits(4);
        return this;
    }

    public TextFieldWidget setWheelDur(int digits, float wheelDur) {
        this.wheelDur = wheelDur;
        this.numberInstance = NumberFormat.getNumberInstance();
        this.numberInstance.setMaximumFractionDigits(digits);
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        if (this.wheelDur > 0.0f && this.numberInstance != null && this.isMouseOverElement(mouseX, mouseY) && this.isFocus()) {
            try {
                this.onTextChanged(this.numberInstance.format(Float.parseFloat(this.getCurrentString()) + (float)(wheelDelta > 0.0 ? 1 : -1) * this.wheelDur));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setFocus(true);
            return true;
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging && this.numberInstance != null && this.isFocus()) {
            try {
                this.onTextChanged(this.numberInstance.format((double)Float.parseFloat(this.getCurrentString()) + dragX * (double)this.wheelDur));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setFocus(true);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInForeground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null && this.gui.getModularUIGui() != null) {
            ArrayList<class_2561> tips = new ArrayList<class_2561>();
            if (this.tooltipTexts != null) {
                tips.addAll(this.tooltipTexts);
            }
            if (this.hover != null) {
                tips.add(this.hover);
            }
            if (this.wheelDur > 0.0f && this.numberInstance != null && this.isFocus()) {
                tips.add((class_2561)class_2561.method_43469((String)"ldlib.gui.text_field.number.wheel", (Object[])new Object[]{this.numberInstance.format(this.wheelDur)}));
            }
            if (!tips.isEmpty()) {
                this.gui.getModularUIGui().setHoverTooltip(tips, class_1799.field_8037, null, null);
            }
        }
    }
}

