/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;

@Configurable(name="ldlib.gui.editor.register.widget.text_box", collapse=false)
@LDLRegister(name="text_box", group="widget.basic")
public class TextBoxWidget
extends Widget
implements IConfigurableWidget {
    @Configurable
    public final List<String> content = new ArrayList<String>();
    @Configurable
    public int space = 1;
    @Configurable
    public int fontSize = 9;
    @Configurable
    @NumberColor
    public int fontColor = -16777216;
    @Configurable
    public boolean isShadow = false;
    @Configurable
    public boolean isCenter = false;
    private transient List<String> textLines;

    public TextBoxWidget() {
        this(0, 0, 60, List.of());
    }

    @Override
    public void initTemplate() {
        this.setContent(List.of("ldlib.author", "Lorem ipsum"));
        this.setFontColor(-1);
    }

    public TextBoxWidget(int x, int y, int width, List<String> content) {
        super(x, y, width, 0);
        this.content.addAll(content);
        this.calculate();
    }

    @Override
    @ConfigSetter(field="size")
    public void setSize(Size size) {
        int lastWidth = this.getSize().width;
        super.setSize(size);
        if (size.width != lastWidth) {
            this.calculate();
        }
    }

    @ConfigSetter(field="content")
    public TextBoxWidget setContent(List<String> content) {
        if (this.content != content) {
            this.content.clear();
            this.content.addAll(content);
        }
        this.calculate();
        return this;
    }

    @ConfigSetter(field="space")
    public TextBoxWidget setSpace(int space) {
        this.space = space;
        this.calculate();
        return this;
    }

    @ConfigSetter(field="fontSize")
    public TextBoxWidget setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.calculate();
        return this;
    }

    public TextBoxWidget setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public TextBoxWidget setShadow(boolean shadow) {
        this.isShadow = shadow;
        return this;
    }

    public TextBoxWidget setCenter(boolean center) {
        this.isCenter = center;
        return this;
    }

    public int getMaxContentWidth() {
        return this.content.stream().mapToInt(arg_0 -> ((class_327)class_310.method_1551().field_1772).method_1727(arg_0)).max().orElse(0);
    }

    protected void calculate() {
        if (this.isRemote()) {
            this.textLines = new ArrayList<String>();
            class_327 font = class_310.method_1551().field_1772;
            this.space = Math.max(this.space, 0);
            this.fontSize = Math.max(this.fontSize, 1);
            int n = this.getSize().width;
            Objects.requireNonNull(font);
            int wrapWidth = n * 9 / this.fontSize;
            for (String textLine : this.content) {
                this.textLines.addAll(font.method_27527().method_27498(LocalizationUtils.format(textLine, new Object[0]), wrapWidth, class_2583.field_24360).stream().map(class_5348::getString).toList());
            }
            this.setSize(new Size(this.getSize().width, this.textLines.size() * (this.fontSize + this.space)));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        if (!this.textLines.isEmpty()) {
            Position position = this.getPosition();
            Size size = this.getSize();
            class_327 font = class_310.method_1551().field_1772;
            float f = (float)this.fontSize * 1.0f;
            Objects.requireNonNull(font);
            float scale = f / 9.0f;
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22905(scale, scale, 1.0f);
            graphics.method_51448().method_46416((float)position.x / scale, (float)position.y / scale, 0.0f);
            float x = 0.0f;
            float y = 0.0f;
            Objects.requireNonNull(font);
            float ySpace = 9.0f + (float)this.space / scale;
            for (String textLine : this.textLines) {
                if (this.isCenter) {
                    x = ((float)size.width / scale - (float)font.method_1727(textLine)) / 2.0f;
                }
                graphics.method_51433(font, textLine, (int)x, (int)y, this.fontColor, this.isShadow);
                y += ySpace;
            }
            graphics.method_51448().method_22909();
        }
    }

    @Override
    public boolean handleDragging(Object dragging) {
        if (dragging instanceof String) {
            String string = (String)dragging;
            ArrayList<String> list = new ArrayList<String>();
            list.add(string);
            this.setContent(list);
            return true;
        }
        return IConfigurableWidget.super.handleDragging(dragging);
    }
}

