/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.fabric.TankWidgetImpl;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidActionResult;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.emi.emi.api.stack.FluidEmiStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;

@LDLRegister(name="fluid_slot", group="widget.container")
public class TankWidget
extends Widget
implements IRecipeIngredientSlot,
IConfigurableWidget {
    @Nullable
    protected IFluidStorage fluidTank;
    @Configurable
    protected boolean showAmount;
    @Configurable
    protected boolean allowClickFilled;
    @Configurable
    protected boolean allowClickDrained;
    @Configurable
    public boolean drawHoverOverlay = true;
    @Configurable
    protected boolean drawHoverTips;
    @Configurable
    protected ProgressTexture.FillDirection fillDirection = ProgressTexture.FillDirection.ALWAYS_FULL;
    @Configurable
    protected IGuiTexture overlay;
    protected BiConsumer<TankWidget, List<class_2561>> onAddedTooltips;
    protected IngredientIO ingredientIO = IngredientIO.RENDER_ONLY;
    protected float XEIChance = 1.0f;
    protected FluidStack lastFluidInTank;
    protected long lastTankCapacity;
    protected Runnable changeListener;
    @NotNull
    protected List<Consumer<List<class_2561>>> tooltipCallback = new ArrayList<Consumer<List<class_2561>>>();

    public TankWidget() {
        this(null, 0, 0, 18, 18, true, true);
    }

    @Override
    public void initTemplate() {
        this.setBackground((IGuiTexture)new ResourceTexture("ldlib:textures/gui/fluid_slot.png"));
        this.setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP);
    }

    public TankWidget(IFluidStorage fluidTank, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        this(fluidTank, x, y, 18, 18, allowClickContainerFilling, allowClickContainerEmptying);
    }

    public TankWidget(@Nullable IFluidStorage fluidTank, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        super(new Position(x, y), new Size(width, height));
        this.fluidTank = fluidTank;
        this.showAmount = true;
        this.allowClickFilled = allowClickContainerFilling;
        this.allowClickDrained = allowClickContainerEmptying;
        this.drawHoverTips = true;
    }

    public TankWidget setFluidTank(IFluidStorage fluidTank) {
        this.fluidTank = fluidTank;
        if (this.isClientSideWidget) {
            this.setClientSideWidget();
        }
        return this;
    }

    @Override
    public TankWidget setClientSideWidget() {
        super.setClientSideWidget();
        if (this.fluidTank != null) {
            this.fluidTank.getFluid();
            this.lastFluidInTank = this.fluidTank.getFluid().copy();
        } else {
            this.lastFluidInTank = null;
        }
        this.lastTankCapacity = this.fluidTank != null ? this.fluidTank.getCapacity() : 0L;
        return this;
    }

    public TankWidget setBackground(IGuiTexture background) {
        super.setBackground(background);
        return this;
    }

    @Override
    @Nullable
    public Object getXEIIngredientOverMouse(double mouseX, double mouseY) {
        if (this.self().isMouseOverElement(mouseX, mouseY)) {
            if (this.lastFluidInTank == null || this.lastFluidInTank.isEmpty()) {
                return null;
            }
            if (LDLib.isJeiLoaded()) {
                return TankWidget.getPlatformFluidTypeForJEI(this.lastFluidInTank, this.getPosition(), this.getSize());
            }
            if (LDLib.isReiLoaded()) {
                return EntryStacks.of((dev.architectury.fluid.FluidStack)dev.architectury.fluid.FluidStack.create((class_3611)this.lastFluidInTank.getFluid(), (long)this.lastFluidInTank.getAmount(), (class_2487)this.lastFluidInTank.getTag()));
            }
            if (LDLib.isEmiLoaded()) {
                return new FluidEmiStack(this.lastFluidInTank.getFluid(), this.lastFluidInTank.getTag(), this.lastFluidInTank.getAmount()).setChance(this.XEIChance);
            }
        }
        return null;
    }

    @Override
    public List<Object> getXEIIngredients() {
        if (this.lastFluidInTank == null || this.lastFluidInTank.isEmpty()) {
            return Collections.emptyList();
        }
        if (LDLib.isJeiLoaded()) {
            return List.of(TankWidget.getPlatformFluidTypeForJEI(this.lastFluidInTank, this.getPosition(), this.getSize()));
        }
        if (LDLib.isReiLoaded()) {
            return List.of(EntryStacks.of((dev.architectury.fluid.FluidStack)dev.architectury.fluid.FluidStack.create((class_3611)this.lastFluidInTank.getFluid(), (long)this.lastFluidInTank.getAmount(), (class_2487)this.lastFluidInTank.getTag())));
        }
        if (LDLib.isEmiLoaded()) {
            return List.of(new FluidEmiStack(this.lastFluidInTank.getFluid(), this.lastFluidInTank.getTag(), this.lastFluidInTank.getAmount()).setChance(this.XEIChance));
        }
        return List.of(FluidHelper.toRealFluidStack(this.lastFluidInTank));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Object getPlatformFluidTypeForJEI(FluidStack fluidStack, Position pos, Size size) {
        void var2_2;
        void var1_1;
        return TankWidgetImpl.getPlatformFluidTypeForJEI(fluidStack, (Position)var1_1, (Size)var2_2);
    }

    private List<class_2561> getToolTips(List<class_2561> list) {
        if (this.onAddedTooltips != null) {
            this.onAddedTooltips.accept(this, list);
        }
        for (Consumer<List<class_2561>> callback : this.tooltipCallback) {
            callback.accept(list);
        }
        return list;
    }

    @Override
    public void addTooltipCallback(Consumer<List<class_2561>> callback) {
        this.tooltipCallback.add(callback);
    }

    @Override
    public void clearTooltipCallback() {
        this.tooltipCallback.clear();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        if (this.isClientSideWidget && this.fluidTank != null) {
            FluidStack fluidStack = this.fluidTank.getFluid();
            if (this.fluidTank.getCapacity() != this.lastTankCapacity) {
                this.lastTankCapacity = this.fluidTank.getCapacity();
            }
            if (!fluidStack.isFluidEqual(this.lastFluidInTank)) {
                this.lastFluidInTank = fluidStack.copy();
            } else if (fluidStack.getAmount() != this.lastFluidInTank.getAmount()) {
                this.lastFluidInTank.setAmount(fluidStack.getAmount());
            }
        }
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.lastFluidInTank != null) {
            RenderSystem.disableBlend();
            if (!this.lastFluidInTank.isEmpty()) {
                double progress = (double)this.lastFluidInTank.getAmount() * 1.0 / (double)Math.max(Math.max(this.lastFluidInTank.getAmount(), this.lastTankCapacity), 1L);
                float drawnU = (float)this.fillDirection.getDrawnU(progress);
                float drawnV = (float)this.fillDirection.getDrawnV(progress);
                float drawnWidth = (float)this.fillDirection.getDrawnWidth(progress);
                float drawnHeight = (float)this.fillDirection.getDrawnHeight(progress);
                int width = size.width - 2;
                int height = size.height - 2;
                int x = pos.x + 1;
                int y = pos.y + 1;
                DrawerHelper.drawFluidForGui(graphics, this.lastFluidInTank, this.lastFluidInTank.getAmount(), (int)((float)x + drawnU * (float)width), (int)((float)y + drawnV * (float)height), (int)((float)width * drawnWidth), (int)((float)height * drawnHeight));
            }
            if (this.showAmount && !this.lastFluidInTank.isEmpty()) {
                graphics.method_51448().method_22903();
                graphics.method_51448().method_22905(0.5f, 0.5f, 1.0f);
                String s = TextFormattingUtil.formatLongToCompactStringBuckets(this.lastFluidInTank.getAmount(), 3) + "B";
                class_327 fontRenderer = class_310.method_1551().field_1772;
                graphics.method_51433(fontRenderer, s, (int)(((float)pos.x + (float)size.width / 3.0f) * 2.0f - (float)fontRenderer.method_1727(s) + 21.0f), (int)(((float)pos.y + (float)size.height / 3.0f + 6.0f) * 2.0f), 0xFFFFFF, true);
                graphics.method_51448().method_22909();
            }
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.overlay != null) {
            this.overlay.draw(graphics, mouseX, mouseY, pos.x, pos.y, size.width, size.height);
        }
        if (this.drawHoverOverlay && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this) {
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            DrawerHelper.drawSolidRect(graphics, this.getPosition().x + 1, this.getPosition().y + 1, this.getSize().width - 2, this.getSize().height - 2, -2130706433);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInForeground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.drawHoverTips && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this) {
            ArrayList<class_2561> tooltips = new ArrayList<class_2561>();
            if (this.lastFluidInTank != null && !this.lastFluidInTank.isEmpty()) {
                tooltips.add(FluidHelper.getDisplayName(this.lastFluidInTank));
                tooltips.add((class_2561)class_2561.method_43469((String)"ldlib.fluid.amount", (Object[])new Object[]{this.lastFluidInTank.getAmount(), this.lastTankCapacity}).method_27693(" " + FluidHelper.getUnit()));
                if (!Platform.isForge()) {
                    tooltips.add((class_2561)class_2561.method_43470((String)"\u00a76mB:\u00a7r %d/%d".formatted(this.lastFluidInTank.getAmount() * 1000L / FluidHelper.getBucket(), this.lastTankCapacity * 1000L / FluidHelper.getBucket())).method_27693(" mB"));
                }
                tooltips.add((class_2561)class_2561.method_43469((String)"ldlib.fluid.temperature", (Object[])new Object[]{FluidHelper.getTemperature(this.lastFluidInTank)}));
                tooltips.add((class_2561)class_2561.method_43471((String)(FluidHelper.isLighterThanAir(this.lastFluidInTank) ? "ldlib.fluid.state_gas" : "ldlib.fluid.state_liquid")));
            } else {
                tooltips.add((class_2561)class_2561.method_43471((String)"ldlib.fluid.empty"));
                tooltips.add((class_2561)class_2561.method_43469((String)"ldlib.fluid.amount", (Object[])new Object[]{0, this.lastTankCapacity}).method_27693(" " + FluidHelper.getUnit()));
                if (!Platform.isForge()) {
                    tooltips.add((class_2561)class_2561.method_43470((String)"\u00a76mB:\u00a7r %d/%d".formatted(0, this.lastTankCapacity * 1000L / FluidHelper.getBucket())).method_27693(" mB"));
                }
            }
            if (this.gui != null) {
                tooltips.addAll(this.tooltipTexts);
                this.gui.getModularUIGui().setHoverTooltip(this.getToolTips(tooltips), class_1799.field_8037, null, null);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void detectAndSendChanges() {
        if (this.fluidTank != null) {
            FluidStack fluidStack = this.fluidTank.getFluid();
            if (this.fluidTank.getCapacity() != this.lastTankCapacity) {
                this.lastTankCapacity = this.fluidTank.getCapacity();
                this.writeUpdateInfo(0, buffer -> buffer.method_10791(this.lastTankCapacity));
            }
            if (!fluidStack.isFluidEqual(this.lastFluidInTank)) {
                this.lastFluidInTank = fluidStack.copy();
                class_2487 fluidStackTag = fluidStack.saveToTag(new class_2487());
                this.writeUpdateInfo(2, buffer -> buffer.method_10794(fluidStackTag));
            } else if (fluidStack.getAmount() != this.lastFluidInTank.getAmount()) {
                this.lastFluidInTank.setAmount(fluidStack.getAmount());
                this.writeUpdateInfo(3, buffer -> buffer.method_10791(this.lastFluidInTank.getAmount()));
            } else {
                super.detectAndSendChanges();
                return;
            }
            if (this.changeListener != null) {
                this.changeListener.run();
            }
        }
    }

    @Override
    public void writeInitialData(class_2540 buffer) {
        buffer.writeBoolean(this.fluidTank != null);
        if (this.fluidTank != null) {
            this.lastTankCapacity = this.fluidTank.getCapacity();
            buffer.method_10791(this.lastTankCapacity);
            FluidStack fluidStack = this.fluidTank.getFluid();
            this.lastFluidInTank = fluidStack.copy();
            buffer.method_10794(fluidStack.saveToTag(new class_2487()));
        }
    }

    @Override
    public void readInitialData(class_2540 buffer) {
        if (buffer.readBoolean()) {
            this.lastTankCapacity = buffer.method_10792();
            this.readUpdateInfo(2, buffer);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void readUpdateInfo(int id, class_2540 buffer) {
        if (id == 0) {
            this.lastTankCapacity = buffer.method_10792();
        } else if (id == 1) {
            this.lastFluidInTank = null;
        } else if (id == 2) {
            this.lastFluidInTank = FluidStack.loadFromTag(buffer.method_10798());
        } else if (id == 3 && this.lastFluidInTank != null) {
            this.lastFluidInTank.setAmount(buffer.method_10792());
        } else if (id == 4) {
            class_1799 currentStack = this.gui.getModularUIContainer().method_34255();
            int newStackSize = buffer.method_10816();
            currentStack.method_7939(newStackSize);
            this.gui.getModularUIContainer().method_34254(currentStack);
        } else {
            super.readUpdateInfo(id, buffer);
            return;
        }
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }

    @Override
    public void handleClientAction(int id, class_2540 buffer) {
        boolean isShiftKeyDown;
        int clickResult;
        super.handleClientAction(id, buffer);
        if (id == 1 && (clickResult = this.tryClickContainer(isShiftKeyDown = buffer.readBoolean())) >= 0) {
            this.writeUpdateInfo(4, buf -> buf.method_10804(clickResult));
        }
    }

    private int tryClickContainer(boolean isShiftKeyDown) {
        int maxAttempts;
        if (this.fluidTank == null) {
            return -1;
        }
        class_1657 player = this.gui.entityPlayer;
        class_1799 currentStack = this.gui.getModularUIContainer().method_34255();
        IFluidTransfer handler = FluidTransferHelper.getFluidTransfer(this.gui.entityPlayer, this.gui.getModularUIContainer());
        if (handler == null) {
            return -1;
        }
        int n = maxAttempts = isShiftKeyDown ? currentStack.method_7947() : 1;
        if (this.allowClickFilled && this.fluidTank.getFluidAmount() > 0L) {
            FluidActionResult result;
            boolean performedFill = false;
            FluidStack initialFluid = this.fluidTank.getFluid();
            for (int i = 0; i < maxAttempts && (result = FluidTransferHelper.tryFillContainer(currentStack, this.fluidTank, Integer.MAX_VALUE, null, false)).isSuccess(); ++i) {
                class_1799 remainingStack = FluidTransferHelper.tryFillContainer(currentStack, this.fluidTank, Integer.MAX_VALUE, null, true).getResult();
                currentStack.method_7934(1);
                performedFill = true;
                if (remainingStack.method_7960() || player.method_7270(remainingStack)) continue;
                class_2248.method_9577((class_1937)player.method_37908(), (class_2338)player.method_23312(), (class_1799)remainingStack);
                break;
            }
            if (performedFill) {
                class_3414 soundevent = FluidHelper.getFillSound(initialFluid);
                if (soundevent != null) {
                    player.method_37908().method_43128(null, player.method_19538().field_1352, player.method_19538().field_1351 + 0.5, player.method_19538().field_1350, soundevent, class_3419.field_15245, 1.0f, 1.0f);
                }
                this.gui.getModularUIContainer().method_34254(currentStack);
                return currentStack.method_7947();
            }
        }
        if (this.allowClickDrained) {
            FluidActionResult result;
            boolean performedEmptying = false;
            for (int i = 0; i < maxAttempts && (result = FluidTransferHelper.tryEmptyContainer(currentStack, this.fluidTank, Integer.MAX_VALUE, null, false)).isSuccess(); ++i) {
                class_1799 remainingStack = FluidTransferHelper.tryEmptyContainer(currentStack, this.fluidTank, Integer.MAX_VALUE, null, true).getResult();
                currentStack.method_7934(1);
                performedEmptying = true;
                if (remainingStack.method_7960() || player.method_31548().method_7394(remainingStack)) continue;
                class_2248.method_9577((class_1937)player.method_37908(), (class_2338)player.method_23312(), (class_1799)remainingStack);
                break;
            }
            FluidStack filledFluid = this.fluidTank.getFluid();
            if (performedEmptying) {
                class_3414 soundevent = FluidHelper.getEmptySound(filledFluid);
                if (soundevent != null) {
                    player.method_37908().method_43128(null, player.method_19538().field_1352, player.method_19538().field_1351 + 0.5, player.method_19538().field_1350, soundevent, class_3419.field_15245, 1.0f, 1.0f);
                }
                this.gui.getModularUIContainer().method_34254(currentStack);
                return currentStack.method_7947();
            }
        }
        return -1;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if ((this.allowClickDrained || this.allowClickFilled) && this.isMouseOverElement(mouseX, mouseY) && button == 0 && FluidTransferHelper.getFluidTransfer(this.gui.entityPlayer, this.gui.getModularUIContainer()) != null) {
            boolean isShiftKeyDown = TankWidget.isShiftDown();
            this.writeClientAction(1, writer -> writer.writeBoolean(isShiftKeyDown));
            TankWidget.playButtonClickSound();
            return true;
        }
        return false;
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        FluidStorage handler = new FluidStorage(5000L);
        handler.fill(FluidStack.create((class_3611)class_3612.field_15910, 3000L), false);
        father.addConfigurators(new WrapperConfigurator("ldlib.gui.editor.group.preview", new TankWidget(){

            @Override
            public void updateScreen() {
                super.updateScreen();
                this.setHoverTooltips(TankWidget.this.tooltipTexts);
                this.backgroundTexture = TankWidget.this.backgroundTexture;
                this.hoverTexture = TankWidget.this.hoverTexture;
                this.showAmount = TankWidget.this.showAmount;
                this.drawHoverTips = TankWidget.this.drawHoverTips;
                this.fillDirection = TankWidget.this.fillDirection;
                this.overlay = TankWidget.this.overlay;
            }
        }.setAllowClickDrained(false).setAllowClickFilled(false).setFluidTank(handler)));
        IConfigurableWidget.super.buildConfigurator(father);
    }

    @Nullable
    public IFluidStorage getFluidTank() {
        return this.fluidTank;
    }

    public TankWidget setShowAmount(boolean showAmount) {
        this.showAmount = showAmount;
        return this;
    }

    public TankWidget setAllowClickFilled(boolean allowClickFilled) {
        this.allowClickFilled = allowClickFilled;
        return this;
    }

    public TankWidget setAllowClickDrained(boolean allowClickDrained) {
        this.allowClickDrained = allowClickDrained;
        return this;
    }

    public TankWidget setDrawHoverOverlay(boolean drawHoverOverlay) {
        this.drawHoverOverlay = drawHoverOverlay;
        return this;
    }

    public TankWidget setDrawHoverTips(boolean drawHoverTips) {
        this.drawHoverTips = drawHoverTips;
        return this;
    }

    public TankWidget setFillDirection(ProgressTexture.FillDirection fillDirection) {
        this.fillDirection = fillDirection;
        return this;
    }

    public TankWidget setOverlay(IGuiTexture overlay) {
        this.overlay = overlay;
        return this;
    }

    public TankWidget setOnAddedTooltips(BiConsumer<TankWidget, List<class_2561>> onAddedTooltips) {
        this.onAddedTooltips = onAddedTooltips;
        return this;
    }

    public TankWidget setIngredientIO(IngredientIO ingredientIO) {
        this.ingredientIO = ingredientIO;
        return this;
    }

    @Override
    public IngredientIO getIngredientIO() {
        return this.ingredientIO;
    }

    public TankWidget setXEIChance(float XEIChance) {
        this.XEIChance = XEIChance;
        return this;
    }

    @Override
    public float getXEIChance() {
        return this.XEIChance;
    }

    public TankWidget setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
        return this;
    }
}

