/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.core.mixins.accessor.SlotAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.JEIPlugin;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.CycleItemStackHandler;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import org.jetbrains.annotations.NotNull;

@LDLRegister(name="item_slot", group="widget.container")
public class SlotWidget
extends Widget
implements IRecipeIngredientSlot,
IConfigurableWidget {
    @Nullable
    protected static class_1735 HOVER_SLOT = null;
    @Nullable
    protected class_1735 slotReference;
    @Configurable
    protected boolean canTakeItems;
    @Configurable
    protected boolean canPutItems;
    public boolean isPlayerContainer;
    public boolean isPlayerHotBar;
    @Configurable
    public boolean drawHoverOverlay = true;
    @Configurable
    public boolean drawHoverTips = true;
    @Configurable
    protected IGuiTexture overlay;
    protected Runnable changeListener;
    protected BiConsumer<SlotWidget, List<class_2561>> onAddedTooltips;
    protected Function<class_1799, class_1799> itemHook;
    protected IngredientIO ingredientIO = IngredientIO.RENDER_ONLY;
    protected float XEIChance = 1.0f;
    @NotNull
    public List<Consumer<List<class_2561>>> tooltipCallbacks = new ArrayList<Consumer<List<class_2561>>>();

    public SlotWidget() {
        super(new Position(0, 0), new Size(18, 18));
    }

    @Override
    public void initTemplate() {
        this.setBackgroundTexture(new ResourceTexture("ldlib:textures/gui/slot.png"));
        this.canTakeItems = true;
        this.canPutItems = true;
    }

    public SlotWidget(class_1263 inventory, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        super(new Position(xPosition, yPosition), new Size(18, 18));
        this.setBackgroundTexture(new ResourceTexture("ldlib:textures/gui/slot.png"));
        this.canTakeItems = canTakeItems;
        this.canPutItems = canPutItems;
        this.setContainerSlot(inventory, slotIndex);
    }

    public SlotWidget(IItemTransfer itemHandler, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        super(new Position(xPosition, yPosition), new Size(18, 18));
        this.setBackgroundTexture(new ResourceTexture("ldlib:textures/gui/slot.png"));
        this.canTakeItems = canTakeItems;
        this.canPutItems = canPutItems;
        this.setHandlerSlot(itemHandler, slotIndex);
    }

    protected class_1735 createSlot(class_1263 inventory, int index) {
        return new WidgetSlot(inventory, index, 0, 0);
    }

    protected class_1735 createSlot(IItemTransfer itemHandler, int index) {
        return new WidgetSlotItemTransfer(itemHandler, index, 0, 0);
    }

    public SlotWidget setContainerSlot(class_1263 inventory, int slotIndex) {
        this.updateSlot(this.createSlot(inventory, slotIndex));
        return this;
    }

    public SlotWidget setHandlerSlot(IItemTransfer itemHandler, int slotIndex) {
        this.updateSlot(this.createSlot(itemHandler, slotIndex));
        return this;
    }

    protected void updateSlot(class_1735 slot) {
        if (this.slotReference != null && this.gui != null && !this.isClientSideWidget) {
            this.getGui().removeNativeSlot(this.slotReference);
        }
        this.slotReference = slot;
        if (this.gui != null && !this.isClientSideWidget) {
            this.getGui().addNativeSlot(this.slotReference, this);
        }
    }

    @Override
    public final void setSize(Size size) {
    }

    @Override
    public void setGui(ModularUI gui) {
        if (!this.isClientSideWidget && this.gui != gui) {
            if (this.gui != null && this.slotReference != null) {
                this.gui.removeNativeSlot(this.slotReference);
            }
            if (gui != null && this.slotReference != null) {
                gui.addNativeSlot(this.slotReference, this);
            }
        }
        super.setGui(gui);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInForeground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.slotReference != null && this.drawHoverTips && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this) {
            class_1799 stack = this.slotReference.method_7677();
            if (this.gui != null) {
                this.gui.getModularUIGui().setHoveredSlot(this.slotReference);
            }
            if (!stack.method_7960() && this.gui != null) {
                ArrayList<class_2561> tips = new ArrayList<class_2561>(this.getToolTips(DrawerHelper.getItemToolTip(stack)));
                tips.addAll(this.tooltipTexts);
                this.gui.getModularUIGui().setHoverTooltip(tips, stack, null, stack.method_32347().orElse(null));
            } else {
                super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
            }
        } else {
            super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position pos = this.getPosition();
        if (this.slotReference != null) {
            ModularUIGuiContainer modularUIGui;
            class_1799 itemStack = this.getRealStack(this.slotReference.method_7677());
            ModularUIGuiContainer modularUIGuiContainer = modularUIGui = this.gui == null ? null : this.gui.getModularUIGui();
            if (itemStack.method_7960() && modularUIGui != null && modularUIGui.getQuickCrafting() && modularUIGui.getQuickCraftSlots().contains(this.slotReference)) {
                int splitSize = modularUIGui.getQuickCraftSlots().size();
                itemStack = this.gui.getModularUIContainer().method_34255();
                if (!itemStack.method_7960() && splitSize > 1 && class_1703.method_7592((class_1735)this.slotReference, (class_1799)itemStack, (boolean)true)) {
                    itemStack = itemStack.method_7972();
                    itemStack.method_7933(class_1703.method_7617(modularUIGui.getQuickCraftSlots(), (int)modularUIGui.dragSplittingLimit, (class_1799)itemStack));
                    int k = Math.min(itemStack.method_7914(), this.slotReference.method_7676(itemStack));
                    if (itemStack.method_7947() > k) {
                        itemStack.method_7939(k);
                    }
                }
            }
            if (!itemStack.method_7960()) {
                DrawerHelper.drawItemStack(graphics, itemStack, pos.x + 1, pos.y + 1, -1, null);
            }
        }
        if (this.overlay != null) {
            this.overlay.draw(graphics, mouseX, mouseY, pos.x, pos.y, 18, 18);
        }
        if (this.drawHoverOverlay && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this) {
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            DrawerHelper.drawSolidRect(graphics, this.getPosition().x + 1, this.getPosition().y + 1, 16, 16, -2130706433);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.slotReference != null && this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            class_1799 stack = this.slotReference.method_7677();
            if (!(this.canPutItems && stack.method_7960() || this.canTakeItems && !stack.method_7960())) {
                return false;
            }
            ModularUIGuiContainer modularUIGui = this.gui.getModularUIGui();
            boolean last = modularUIGui.getQuickCrafting();
            class_3675.class_306 mouseKey = class_3675.class_307.field_1672.method_1447(button);
            HOVER_SLOT = this.slotReference;
            this.gui.getModularUIGui().superMouseClicked(mouseX, mouseY, button);
            HOVER_SLOT = null;
            if (last != modularUIGui.getQuickCrafting()) {
                modularUIGui.dragSplittingButton = button;
                if (button == 0) {
                    modularUIGui.dragSplittingLimit = 0;
                } else if (button == 1) {
                    modularUIGui.dragSplittingLimit = 1;
                } else if (class_310.method_1551().field_1690.field_1871.method_1433(mouseKey.method_1444())) {
                    modularUIGui.dragSplittingLimit = 2;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            HOVER_SLOT = this.slotReference;
            this.gui.getModularUIGui().superMouseReleased(mouseX, mouseY, button);
            HOVER_SLOT = null;
            return this.getIngredientIO() == IngredientIO.RENDER_ONLY && (this.canPutItems || this.canTakeItems);
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            this.gui.getModularUIGui().superMouseDragged(mouseX, mouseY, button, dragX, dragY);
            return true;
        }
        return false;
    }

    @Override
    protected void onPositionUpdate() {
        if (this.gui != null) {
            Position position = this.getPosition();
            if (this.slotReference != null) {
                ((SlotAccessor)this.slotReference).setX(position.x + 1 - this.gui.getGuiLeft());
                ((SlotAccessor)this.slotReference).setY(position.y + 1 - this.gui.getGuiTop());
            }
        }
    }

    public SlotWidget(IItemTransfer itemHandler, int slotIndex, int xPosition, int yPosition) {
        this(itemHandler, slotIndex, xPosition, yPosition, true, true);
    }

    public SlotWidget(class_1263 inventory, int slotIndex, int xPosition, int yPosition) {
        this(inventory, slotIndex, xPosition, yPosition, true, true);
    }

    public SlotWidget setBackgroundTexture(IGuiTexture backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public boolean canPutStack(class_1799 stack) {
        return this.isEnabled() && this.canPutItems;
    }

    public boolean canTakeStack(class_1657 player) {
        return this.isEnabled() && this.canTakeItems;
    }

    public boolean isEnabled() {
        return this.isActive() && this.isVisible();
    }

    public boolean canMergeSlot(class_1799 stack) {
        return this.isEnabled();
    }

    public void onSlotChanged() {
        if (this.gui == null) {
            return;
        }
        this.gui.holder.markAsDirty();
    }

    public class_1799 slotClick(int dragType, class_1713 clickTypeIn, class_1657 player) {
        return null;
    }

    @Nullable
    public final class_1735 getHandle() {
        return this.slotReference;
    }

    public SlotWidget setLocationInfo(boolean isPlayerContainer, boolean isPlayerHotBar) {
        this.isPlayerHotBar = isPlayerHotBar;
        this.isPlayerContainer = isPlayerContainer;
        return this;
    }

    private List<class_2561> getToolTips(List<class_2561> list) {
        if (this.onAddedTooltips != null) {
            this.onAddedTooltips.accept(this, list);
        }
        for (Consumer<List<class_2561>> tooltipCallback : this.tooltipCallbacks) {
            tooltipCallback.accept(list);
        }
        return list;
    }

    @Override
    public void addTooltipCallback(Consumer<List<class_2561>> callback) {
        this.tooltipCallbacks.add(callback);
    }

    @Override
    public void clearTooltipCallback() {
        this.tooltipCallbacks.clear();
    }

    @Override
    @Nullable
    public Object getXEIIngredientOverMouse(double mouseX, double mouseY) {
        if (this.self().isMouseOverElement(mouseX, mouseY)) {
            class_1735 handler = this.getHandle();
            if (handler == null) {
                return null;
            }
            if (LDLib.isJeiLoaded()) {
                return JEIPlugin.getItemIngredient(this.getRealStack(handler.method_7677()), this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height);
            }
            if (LDLib.isReiLoaded()) {
                return EntryStacks.of((class_1799)this.getRealStack(handler.method_7677()));
            }
            if (LDLib.isEmiLoaded()) {
                return new ItemEmiStack(this.getRealStack(handler.method_7677()));
            }
            return this.getRealStack(handler.method_7677());
        }
        return null;
    }

    @Override
    public List<Object> getXEIIngredients() {
        if (this.slotReference == null || this.slotReference.method_7677().method_7960()) {
            return Collections.emptyList();
        }
        class_1735 handler = this.getHandle();
        if (handler == null) {
            return Collections.emptyList();
        }
        if (handler instanceof WidgetSlotItemTransfer) {
            WidgetSlotItemTransfer widgetSlotItemTransfer = (WidgetSlotItemTransfer)handler;
            IItemTransfer iItemTransfer = widgetSlotItemTransfer.itemHandler;
            if (iItemTransfer instanceof CycleItemStackHandler) {
                CycleItemStackHandler cycleItemStackHandler = (CycleItemStackHandler)iItemTransfer;
                Stream<class_1799> stream = cycleItemStackHandler.getStackList(widgetSlotItemTransfer.index).stream().map(this::getRealStack);
                if (LDLib.isJeiLoaded()) {
                    return stream.map(item -> JEIPlugin.getItemIngredient(item, this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height)).toList();
                }
                if (LDLib.isReiLoaded()) {
                    return List.of(EntryIngredient.of(stream.map(EntryStacks::of).toList()));
                }
                if (LDLib.isEmiLoaded()) {
                    return List.of(new ListEmiIngredient(stream.map(ItemEmiStack::new).toList(), (long)this.getRealStack(handler.method_7677()).method_7947()).setChance(this.getXEIChance()));
                }
            }
        }
        if (LDLib.isJeiLoaded()) {
            return List.of(JEIPlugin.getItemIngredient(this.getRealStack(handler.method_7677()), this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height));
        }
        if (LDLib.isReiLoaded()) {
            return List.of(EntryStacks.of((class_1799)this.getRealStack(handler.method_7677())));
        }
        if (LDLib.isEmiLoaded()) {
            return List.of(new ItemEmiStack(this.getRealStack(handler.method_7677())));
        }
        return List.of(this.getRealStack(handler.method_7677()));
    }

    public class_1799 getRealStack(class_1799 itemStack) {
        if (this.itemHook != null) {
            return this.itemHook.apply(itemStack);
        }
        return itemStack;
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        ItemStackTransfer handler = new ItemStackTransfer();
        handler.setStackInSlot(0, class_2246.field_10340.method_8389().method_7854());
        father.addConfigurators(new WrapperConfigurator("ldlib.gui.editor.group.preview", new SlotWidget(){

            @Override
            public void updateScreen() {
                super.updateScreen();
                this.setHoverTooltips(SlotWidget.this.tooltipTexts);
                this.backgroundTexture = SlotWidget.this.backgroundTexture;
                this.hoverTexture = SlotWidget.this.hoverTexture;
                this.drawHoverOverlay = SlotWidget.this.drawHoverOverlay;
                this.drawHoverTips = SlotWidget.this.drawHoverTips;
                this.overlay = SlotWidget.this.overlay;
            }
        }.setCanPutItems(false).setCanTakeItems(false).setHandlerSlot(handler, 0)));
        IConfigurableWidget.super.buildConfigurator(father);
    }

    public SlotWidget setCanTakeItems(boolean canTakeItems) {
        this.canTakeItems = canTakeItems;
        return this;
    }

    public SlotWidget setCanPutItems(boolean canPutItems) {
        this.canPutItems = canPutItems;
        return this;
    }

    public SlotWidget setDrawHoverOverlay(boolean drawHoverOverlay) {
        this.drawHoverOverlay = drawHoverOverlay;
        return this;
    }

    public SlotWidget setDrawHoverTips(boolean drawHoverTips) {
        this.drawHoverTips = drawHoverTips;
        return this;
    }

    public SlotWidget setOverlay(IGuiTexture overlay) {
        this.overlay = overlay;
        return this;
    }

    public SlotWidget setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public SlotWidget setOnAddedTooltips(BiConsumer<SlotWidget, List<class_2561>> onAddedTooltips) {
        this.onAddedTooltips = onAddedTooltips;
        return this;
    }

    public SlotWidget setItemHook(Function<class_1799, class_1799> itemHook) {
        this.itemHook = itemHook;
        return this;
    }

    public SlotWidget setIngredientIO(IngredientIO ingredientIO) {
        this.ingredientIO = ingredientIO;
        return this;
    }

    @Override
    public IngredientIO getIngredientIO() {
        return this.ingredientIO;
    }

    public SlotWidget setXEIChance(float XEIChance) {
        this.XEIChance = XEIChance;
        return this;
    }

    @Override
    public float getXEIChance() {
        return this.XEIChance;
    }

    protected class WidgetSlot
    extends class_1735 {
        public WidgetSlot(class_1263 inventory, int index, int xPosition, int yPosition) {
            super(inventory, index, xPosition, yPosition);
        }

        public boolean method_7680(@Nonnull class_1799 stack) {
            return SlotWidget.this.canPutStack(stack) && super.method_7680(stack);
        }

        public boolean method_7674(@Nonnull class_1657 playerIn) {
            return SlotWidget.this.canTakeStack(playerIn) && super.method_7674(playerIn);
        }

        public void method_7673(@Nonnull class_1799 stack) {
            super.method_7673(stack);
            if (SlotWidget.this.changeListener != null) {
                SlotWidget.this.changeListener.run();
            }
        }

        public void method_7668() {
            SlotWidget.this.onSlotChanged();
        }

        public boolean method_7682() {
            return SlotWidget.this.isEnabled() && (HOVER_SLOT == null || HOVER_SLOT == this);
        }
    }

    protected class WidgetSlotItemTransfer
    extends class_1735 {
        private static final class_1263 emptyInventory = new class_1277(0);
        private final IItemTransfer itemHandler;
        private final int index;

        public WidgetSlotItemTransfer(IItemTransfer itemHandler, int index, int xPosition, int yPosition) {
            super(emptyInventory, index, xPosition, yPosition);
            this.itemHandler = itemHandler;
            this.index = index;
        }

        public boolean method_7680(@Nonnull class_1799 stack) {
            return SlotWidget.this.canPutStack(stack) && !stack.method_7960() && this.itemHandler.isItemValid(this.index, stack);
        }

        public boolean method_7674(@Nullable class_1657 playerIn) {
            return SlotWidget.this.canTakeStack(playerIn) && !this.itemHandler.extractItem(this.index, 1, true).method_7960();
        }

        @Nonnull
        public class_1799 method_7677() {
            return this.itemHandler.getStackInSlot(this.index);
        }

        public void method_7673(@Nonnull class_1799 stack) {
            this.itemHandler.setStackInSlot(this.index, stack);
            this.itemHandler.onContentsChanged();
            this.method_7668();
            if (SlotWidget.this.changeListener != null) {
                SlotWidget.this.changeListener.run();
            }
        }

        public void method_7670(@Nonnull class_1799 oldStackIn, @Nonnull class_1799 newStackIn) {
        }

        public int method_7675() {
            return this.itemHandler.getSlotLimit(this.index);
        }

        public int method_7676(@Nonnull class_1799 stack) {
            class_1799 maxAdd = stack.method_7972();
            int maxInput = stack.method_7914();
            maxAdd.method_7939(maxInput);
            class_1799 currentStack = this.itemHandler.getStackInSlot(this.index);
            this.itemHandler.setStackInSlot(this.index, class_1799.field_8037);
            class_1799 remainder = this.itemHandler.insertItem(this.index, maxAdd, true);
            this.itemHandler.setStackInSlot(this.index, currentStack);
            return maxInput - remainder.method_7947();
        }

        @NotNull
        public class_1799 method_7671(int amount) {
            class_1799 result = this.itemHandler.extractItem(this.index, amount, false);
            if (SlotWidget.this.changeListener != null && !this.method_7677().method_7960()) {
                SlotWidget.this.changeListener.run();
            }
            return result;
        }

        public void method_7668() {
            SlotWidget.this.onSlotChanged();
        }

        public boolean method_7682() {
            return SlotWidget.this.isEnabled() && (HOVER_SLOT == null || HOVER_SLOT == this);
        }
    }
}

