/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.scene.FBOWorldSceneRenderer;
import com.lowdragmc.lowdraglib.client.scene.ISceneBlockRenderHook;
import com.lowdragmc.lowdraglib.client.scene.ImmediateWorldSceneRenderer;
import com.lowdragmc.lowdraglib.client.scene.ParticleManager;
import com.lowdragmc.lowdraglib.client.scene.WorldSceneRenderer;
import com.lowdragmc.lowdraglib.client.utils.RenderUtils;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.JEIPlugin;
import com.lowdragmc.lowdraglib.utils.BlockPosFace;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.lowdraglib.utils.interpolate.Eases;
import com.lowdragmc.lowdraglib.utils.interpolate.Interpolator;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.stack.ItemEmiStack;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class SceneWidget
extends WidgetGroup {
    @Environment(value=EnvType.CLIENT)
    protected WorldSceneRenderer renderer;
    @Environment(value=EnvType.CLIENT)
    protected TrackedDummyWorld dummyWorld;
    protected boolean dragging;
    protected boolean renderFacing = true;
    protected boolean renderSelect = true;
    protected boolean draggable = true;
    protected boolean scalable = true;
    protected boolean hoverTips;
    protected int currentMouseX;
    protected int currentMouseY;
    protected Vector3f center;
    protected float rotationYaw = 25.0f;
    protected float rotationPitch = -135.0f;
    protected float zoom = 5.0f;
    protected float range;
    protected BlockPosFace clickPosFace;
    protected BlockPosFace hoverPosFace;
    protected BlockPosFace selectedPosFace;
    protected class_1799 hoverItem;
    protected BiConsumer<class_2338, class_2350> onSelected;
    protected Set<class_2338> core;
    protected boolean useCache;
    protected boolean useOrtho = false;
    protected boolean autoReleased;
    protected BiConsumer<SceneWidget, List<class_2561>> onAddedTooltips;
    private Consumer<SceneWidget> beforeWorldRender;
    private Consumer<SceneWidget> afterWorldRender;
    Interpolator interpolator;
    long startTick;

    public SceneWidget(int x, int y, int width, int height, class_1937 world, boolean useFBO) {
        super(x, y, width, height);
        if (this.isRemote()) {
            this.createScene(world, useFBO);
        }
    }

    public SceneWidget(int x, int y, int width, int height, class_1937 world) {
        super(x, y, width, height);
        if (this.isRemote()) {
            this.createScene(world);
        }
    }

    public SceneWidget setOnAddedTooltips(BiConsumer<SceneWidget, List<class_2561>> onAddedTooltips) {
        this.onAddedTooltips = onAddedTooltips;
        return this;
    }

    public SceneWidget useCacheBuffer() {
        return this.useCacheBuffer(true);
    }

    public SceneWidget useCacheBuffer(boolean autoReleased) {
        this.useCache = true;
        this.autoReleased = autoReleased;
        if (this.isRemote() && this.renderer != null) {
            this.renderer.useCacheBuffer(true);
        }
        return this;
    }

    public SceneWidget useOrtho() {
        return this.useOrtho(true);
    }

    public SceneWidget useOrtho(boolean useOrtho) {
        this.useOrtho = useOrtho;
        if (this.isRemote() && this.renderer != null) {
            this.renderer.useOrtho(useOrtho);
        }
        return this;
    }

    public SceneWidget setBeforeWorldRender(Consumer<SceneWidget> beforeWorldRender) {
        this.beforeWorldRender = beforeWorldRender;
        if (this.beforeWorldRender != null && this.isRemote() && this.renderer != null) {
            this.renderer.setBeforeWorldRender((WorldSceneRenderer s) -> beforeWorldRender.accept(this));
        }
        return this;
    }

    public SceneWidget setAfterWorldRender(Consumer<SceneWidget> afterWorldRender) {
        this.afterWorldRender = afterWorldRender;
        return this;
    }

    private float camZoom() {
        if (this.useOrtho) {
            return 0.1f;
        }
        return this.zoom;
    }

    @Environment(value=EnvType.CLIENT)
    public ParticleManager getParticleManager() {
        if (this.renderer == null) {
            return null;
        }
        return this.renderer.getParticleManager();
    }

    @Override
    public void setGui(ModularUI gui) {
        super.setGui(gui);
        if (gui == null) {
            if (this.isInitialized()) {
                this.releaseCacheBuffer();
            }
        } else {
            gui.registerCloseListener(this::releaseCacheBuffer);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        ParticleManager particleManager = this.getParticleManager();
        if (particleManager != null) {
            particleManager.tick();
        }
    }

    public void releaseCacheBuffer() {
        if (this.isRemote() && this.renderer != null && this.autoReleased) {
            this.renderer.deleteCacheBuffer();
        }
    }

    public void needCompileCache() {
        if (this.isRemote() && this.renderer != null) {
            this.renderer.needCompileCache();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public final void createScene(class_1937 world) {
        this.createScene(world, false);
    }

    @Environment(value=EnvType.CLIENT)
    protected ParticleManager createParticleManager() {
        return new ParticleManager();
    }

    @Environment(value=EnvType.CLIENT)
    public final void createScene(class_1937 world, boolean useFBOSceneRenderer) {
        if (world == null) {
            return;
        }
        this.core = new HashSet<class_2338>();
        this.dummyWorld = new TrackedDummyWorld(world);
        this.dummyWorld.setRenderFilter(pos -> this.renderer.renderedBlocksMap.keySet().stream().anyMatch(c -> c.contains(pos)));
        if (this.renderer != null) {
            this.renderer.deleteCacheBuffer();
        }
        this.renderer = useFBOSceneRenderer ? new FBOWorldSceneRenderer(this.dummyWorld, 1080, 1080) : new ImmediateWorldSceneRenderer(this.dummyWorld);
        this.center = new Vector3f(0.0f, 0.0f, 0.0f);
        this.renderer.useOrtho(this.useOrtho);
        this.renderer.setOnLookingAt(ray -> {});
        this.renderer.setAfterWorldRender(this::renderBlockOverLay);
        if (this.beforeWorldRender != null) {
            this.renderer.setBeforeWorldRender((WorldSceneRenderer s) -> this.beforeWorldRender.accept(this));
        }
        this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        this.renderer.useCacheBuffer(this.useCache);
        this.renderer.setParticleManager(this.createParticleManager());
        this.clickPosFace = null;
        this.hoverPosFace = null;
        this.hoverItem = null;
        this.selectedPosFace = null;
    }

    @Environment(value=EnvType.CLIENT)
    public WorldSceneRenderer getRenderer() {
        return this.renderer;
    }

    @Environment(value=EnvType.CLIENT)
    public TrackedDummyWorld getDummyWorld() {
        return this.dummyWorld;
    }

    public SceneWidget setOnSelected(BiConsumer<class_2338, class_2350> onSelected) {
        this.onSelected = onSelected;
        return this;
    }

    public SceneWidget setClearColor(int color) {
        if (this.isRemote()) {
            this.renderer.setClearColor(color);
        }
        return this;
    }

    public SceneWidget setRenderSelect(boolean renderSelect) {
        this.renderSelect = renderSelect;
        return this;
    }

    public SceneWidget setRenderFacing(boolean renderFacing) {
        this.renderFacing = renderFacing;
        return this;
    }

    public SceneWidget setDraggable(boolean draggable) {
        this.draggable = draggable;
        return this;
    }

    public SceneWidget setScalable(boolean scalable) {
        this.scalable = scalable;
        return this;
    }

    public SceneWidget setHoverTips(boolean hoverTips) {
        this.hoverTips = hoverTips;
        return this;
    }

    public SceneWidget setRenderedCore(Collection<class_2338> blocks, ISceneBlockRenderHook renderHook) {
        if (this.isRemote()) {
            this.core.clear();
            this.core.addAll(blocks);
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            for (class_2338 vPos : blocks) {
                minX = Math.min(minX, vPos.method_10263());
                minY = Math.min(minY, vPos.method_10264());
                minZ = Math.min(minZ, vPos.method_10260());
                maxX = Math.max(maxX, vPos.method_10263());
                maxY = Math.max(maxY, vPos.method_10264());
                maxZ = Math.max(maxZ, vPos.method_10260());
            }
            this.center = new Vector3f((float)(minX + maxX) / 2.0f + 0.5f, (float)(minY + maxY) / 2.0f + 0.5f, (float)(minZ + maxZ) / 2.0f + 0.5f);
            this.renderer.addRenderedBlocks(this.core, renderHook);
            this.zoom = (float)(3.5 * Math.sqrt(Math.max(Math.max(Math.max(maxX - minX + 1, maxY - minY + 1), maxZ - minZ + 1), 1)));
            this.renderer.setCameraOrtho(this.range * this.zoom, this.range * this.zoom, this.range * this.zoom);
            this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
            this.needCompileCache();
        }
        return this;
    }

    private List<class_2561> getToolTips(List<class_2561> list) {
        if (this.onAddedTooltips != null) {
            this.onAddedTooltips.accept(this, list);
        }
        return list;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderBlockOverLay(WorldSceneRenderer renderer) {
        BlockPosFace tmp;
        class_3965 hit;
        class_4587 poseStack = new class_4587();
        this.hoverPosFace = null;
        this.hoverItem = null;
        if (this.isMouseOverElement(this.currentMouseX, this.currentMouseY) && (hit = renderer.getLastTraceResult()) != null) {
            if (this.core.contains(hit.method_17777())) {
                this.hoverPosFace = new BlockPosFace(hit.method_17777(), hit.method_17780());
            } else if (!this.useOrtho) {
                Vector3f hitPos = hit.method_17784().method_46409();
                class_1937 world = renderer.world;
                class_243 eyePos = new class_243(renderer.getEyePos());
                hitPos.mul(2.0f);
                class_243 endPos = new class_243((double)hitPos.x - eyePos.field_1352, (double)hitPos.y - eyePos.field_1351, (double)hitPos.z - eyePos.field_1350);
                double min = 3.4028234663852886E38;
                for (class_2338 pos : this.core) {
                    double dist;
                    class_2680 blockState = world.method_8320(pos);
                    if (blockState.method_26204() == class_2246.field_10124 || (hit = world.method_17745(eyePos, endPos, pos, blockState.method_26218((class_1922)world, pos), blockState)) == null || hit.method_17783() == class_239.class_240.field_1333 || !((dist = eyePos.method_1025(hit.method_17784())) < min)) continue;
                    min = dist;
                    this.hoverPosFace = new BlockPosFace(hit.method_17777(), hit.method_17780());
                }
            }
        }
        if (this.hoverPosFace != null) {
            class_2680 state = this.getDummyWorld().method_8320(this.hoverPosFace.pos);
            this.hoverItem = state.method_26204().method_9574((class_1922)this.getDummyWorld(), this.hoverPosFace.pos, state);
        }
        BlockPosFace blockPosFace = tmp = this.dragging ? this.clickPosFace : this.hoverPosFace;
        if (this.selectedPosFace != null || tmp != null) {
            if (this.selectedPosFace != null && this.renderFacing) {
                this.drawFacingBorder(poseStack, this.selectedPosFace, -16711936);
            }
            if (tmp != null && !tmp.equals(this.selectedPosFace) && this.renderFacing) {
                this.drawFacingBorder(poseStack, tmp, -1);
            }
        }
        if (this.selectedPosFace != null && this.renderSelect) {
            RenderUtils.renderBlockOverLay(poseStack, this.selectedPosFace.pos, 0.6f, 0.0f, 0.0f, 1.01f);
        }
        if (this.afterWorldRender != null) {
            this.afterWorldRender.accept(this);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void drawFacingBorder(class_4587 poseStack, BlockPosFace posFace, int color) {
        this.drawFacingBorder(poseStack, posFace, color, 0);
    }

    @Environment(value=EnvType.CLIENT)
    public void drawFacingBorder(class_4587 poseStack, BlockPosFace posFace, int color, int inner) {
        poseStack.method_22903();
        RenderSystem.disableDepthTest();
        RenderUtils.moveToFace(poseStack, posFace.pos.method_10263(), posFace.pos.method_10264(), posFace.pos.method_10260(), posFace.facing);
        RenderUtils.rotateToFace(poseStack, posFace.facing, null);
        poseStack.method_22905(0.0625f, 0.0625f, 0.0f);
        poseStack.method_46416(-8.0f, -8.0f, 0.0f);
        SceneWidget.drawBorder(poseStack, 1 + inner * 2, 1 + inner * 2, 14 - 4 * inner, 14 - 4 * inner, color, 1);
        RenderSystem.enableDepthTest();
        poseStack.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    private static void drawBorder(class_4587 poseStack, int x, int y, int width, int height, int color, int border) {
        SceneWidget.drawSolidRect(poseStack, x - border, y - border, width + 2 * border, border, color);
        SceneWidget.drawSolidRect(poseStack, x - border, y + height, width + 2 * border, border, color);
        SceneWidget.drawSolidRect(poseStack, x - border, y, border, height, color);
        SceneWidget.drawSolidRect(poseStack, x + width, y, border, height, color);
    }

    @Environment(value=EnvType.CLIENT)
    private static void drawSolidRect(class_4587 poseStack, int x, int y, int width, int height, int color) {
        SceneWidget.fill(poseStack, x, y, x + width, y + height, 0, color);
        RenderSystem.enableBlend();
    }

    @Environment(value=EnvType.CLIENT)
    private static void fill(class_4587 matrices, int x1, int y1, int x2, int y2, int z, int color) {
        int i;
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float f = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
        float g = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float h = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float j = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)z).method_22915(g, h, j, f).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)z).method_22915(g, h, j, f).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)z).method_22915(g, h, j, f).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)z).method_22915(g, h, j, f).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.disableBlend();
    }

    @Override
    public Object getXEIIngredientOverMouse(double mouseX, double mouseY) {
        Object result = super.getXEIIngredientOverMouse(mouseX, mouseY);
        if (result == null && this.hoverItem != null && !this.hoverItem.method_7960()) {
            if (LDLib.isJeiLoaded()) {
                return JEIPlugin.getItemIngredient(this.hoverItem, (int)mouseX, (int)mouseY, 1, 1);
            }
            if (LDLib.isReiLoaded()) {
                return EntryStacks.of((class_1799)this.hoverItem);
            }
            if (LDLib.isEmiLoaded()) {
                return new ItemEmiStack(this.hoverItem);
            }
            return this.hoverItem;
        }
        return result;
    }

    @Override
    public void handleClientAction(int id, class_2540 buffer) {
        if (id == -1) {
            this.selectedPosFace = new BlockPosFace(buffer.method_10811(), (class_2350)buffer.method_10818(class_2350.class));
            if (this.onSelected != null) {
                this.onSelected.accept(this.selectedPosFace.pos, this.selectedPosFace.facing);
            }
        } else {
            super.handleClientAction(id, buffer);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (this.draggable) {
                this.dragging = true;
            }
            this.clickPosFace = this.hoverPosFace;
            return true;
        }
        this.dragging = false;
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        boolean result = super.mouseWheelMove(mouseX, mouseY, wheelDelta);
        if (!result && this.isMouseOverElement(mouseX, mouseY) && this.scalable) {
            this.zoom = (float)class_3532.method_15350((double)((double)this.zoom + (wheelDelta < 0.0 ? 0.5 : -0.5)), (double)0.1, (double)999.0);
            if (this.renderer != null) {
                this.renderer.setCameraOrtho(this.range * this.zoom, this.range * this.zoom, this.range * this.zoom);
                this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
            }
            return true;
        }
        return result;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging) {
            this.rotationPitch = (float)((double)this.rotationPitch + (dragX + 360.0));
            this.rotationPitch %= 360.0f;
            this.rotationYaw = (float)class_3532.method_15350((double)((double)this.rotationYaw + dragY), (double)-89.9, (double)89.9);
            if (this.renderer != null) {
                this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
            }
            return false;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.dragging = false;
        if (this.hoverPosFace != null && this.hoverPosFace.equals(this.clickPosFace)) {
            this.selectedPosFace = this.hoverPosFace;
            this.writeClientAction(-1, buffer -> {
                buffer.method_10807(this.selectedPosFace.pos);
                buffer.method_10817((Enum)this.selectedPosFace.facing);
            });
            if (this.onSelected != null) {
                this.onSelected.accept(this.selectedPosFace.pos, this.selectedPosFace.facing);
            }
            this.clickPosFace = null;
            return true;
        }
        this.clickPosFace = null;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInForeground(@Nonnull @NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.hoverTips && this.isMouseOverElement(mouseX, mouseY) && this.hoverItem != null && !this.hoverItem.method_7960()) {
            this.gui.getModularUIGui().setHoverTooltip(this.getToolTips(DrawerHelper.getItemToolTip(this.hoverItem)), this.hoverItem, null, this.hoverItem.method_32347().orElse(null));
        }
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawBackgroundTexture(graphics, mouseX, mouseY);
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.interpolator != null) {
            this.interpolator.update((float)this.gui.getTickCount() + partialTicks);
        }
        if (this.renderer != null) {
            double progress;
            this.renderer.render(graphics.method_51448(), x, y, width, height, mouseX, mouseY);
            if (this.renderer.isCompiling() && (progress = this.renderer.getCompileProgress()) > 0.0) {
                new TextTexture("Renderer is compiling! " + String.format("%.1f", progress * 100.0) + "%%").setWidth(width).draw(graphics, mouseX, mouseY, x, y, width, height);
            }
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        this.drawWidgetsBackground(graphics, mouseX, mouseY, partialTicks);
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
    }

    public SceneWidget setCenter(Vector3f center) {
        this.center = center;
        if (this.renderer != null) {
            this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        }
        return this;
    }

    public SceneWidget setZoom(float zoom) {
        this.zoom = zoom;
        if (this.renderer != null) {
            this.renderer.setCameraOrtho(this.range * zoom, this.range * zoom, this.range * zoom);
            this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        }
        return this;
    }

    public SceneWidget setOrthoRange(float range) {
        this.range = range;
        if (this.renderer != null) {
            this.renderer.setCameraOrtho(range * this.zoom, range * this.zoom, range * this.zoom);
        }
        return this;
    }

    public SceneWidget setCameraYawAndPitch(float rotationYaw, float rotationPitch) {
        this.rotationYaw = rotationYaw;
        this.rotationPitch = rotationPitch;
        if (this.renderer != null) {
            this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(rotationPitch), Math.toRadians(rotationYaw));
        }
        return this;
    }

    public void setCameraYawAndPitchAnima(float rotationYaw, float rotationPitch, int dur) {
        if (this.interpolator != null) {
            return;
        }
        float oRotationYaw = this.rotationYaw;
        float oRotationPitch = this.rotationPitch;
        this.startTick = this.gui.getTickCount();
        this.interpolator = new Interpolator(0.0f, 1.0f, dur, Eases.EaseQuadOut, value -> {
            this.rotationYaw = (rotationYaw - oRotationYaw) * value.floatValue() + oRotationYaw;
            this.rotationPitch = (rotationPitch - oRotationPitch) * value.floatValue() + oRotationPitch;
            if (this.renderer != null) {
                this.renderer.setCameraLookAt(this.center, this.camZoom(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
            }
        }, x -> {
            this.interpolator = null;
        });
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public float getRotationYaw() {
        return this.rotationYaw;
    }

    public float getRotationPitch() {
        return this.rotationPitch;
    }

    public float getZoom() {
        return this.zoom;
    }

    public BlockPosFace getClickPosFace() {
        return this.clickPosFace;
    }

    public BlockPosFace getHoverPosFace() {
        return this.hoverPosFace;
    }

    public BlockPosFace getSelectedPosFace() {
        return this.selectedPosFace;
    }

    public class_1799 getHoverItem() {
        return this.hoverItem;
    }

    public Set<class_2338> getCore() {
        return this.core;
    }
}

