/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.GuiTextureConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.UIResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

@LDLRegister(name="progress", group="widget.basic")
public class ProgressWidget
extends Widget
implements IConfigurableWidget {
    public static final DoubleSupplier JEIProgress = () -> (double)Math.abs(System.currentTimeMillis() % 2000L) / 2000.0;
    public DoubleSupplier progressSupplier;
    private Function<Double, String> dynamicHoverTips;
    @Configurable
    private IGuiTexture progressTexture;
    @Configurable
    private IGuiTexture overlayTexture;
    private double lastProgressValue;

    public ProgressWidget() {
        this(JEIProgress, 0, 0, 40, 40, new ProgressTexture());
    }

    public ProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height, ResourceTexture fullImage) {
        super(new Position(x, y), new Size(width, height));
        this.progressSupplier = progressSupplier;
        this.progressTexture = new ProgressTexture(fullImage.getSubTexture(0.0, 0.0, 1.0, 0.5), fullImage.getSubTexture(0.0, 0.5, 1.0, 0.5));
        this.lastProgressValue = -1.0;
    }

    public ProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height, ProgressTexture progressBar) {
        super(new Position(x, y), new Size(width, height));
        this.progressSupplier = progressSupplier;
        this.progressTexture = progressBar;
        this.lastProgressValue = -1.0;
    }

    public ProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height) {
        super(new Position(x, y), new Size(width, height));
        this.progressSupplier = progressSupplier;
    }

    public ProgressWidget setProgressTexture(IGuiTexture emptyBarArea, IGuiTexture filledBarArea) {
        this.progressTexture = new ProgressTexture(emptyBarArea, filledBarArea);
        return this;
    }

    public ProgressWidget setFillDirection(ProgressTexture.FillDirection fillDirection) {
        IGuiTexture iGuiTexture = this.progressTexture;
        if (iGuiTexture instanceof ProgressTexture) {
            ProgressTexture progressTexture = (ProgressTexture)iGuiTexture;
            progressTexture.setFillDirection(fillDirection);
        }
        return this;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.progressTexture != null) {
            this.progressTexture.updateTick();
        }
        if (this.overlayTexture != null) {
            this.overlayTexture.updateTick();
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInForeground(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if ((!this.tooltipTexts.isEmpty() || this.dynamicHoverTips != null) && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this && this.gui != null && this.gui.getModularUIGui() != null) {
            ArrayList<class_2561> tips = new ArrayList<class_2561>(this.tooltipTexts);
            if (this.dynamicHoverTips != null) {
                tips.add((class_2561)class_2561.method_43471((String)this.dynamicHoverTips.apply(this.lastProgressValue)));
            }
            this.gui.getModularUIGui().setHoverTooltip(tips, class_1799.field_8037, null, null);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        IGuiTexture iGuiTexture;
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        if (this.progressSupplier == JEIProgress || this.isClientSideWidget) {
            this.lastProgressValue = this.progressSupplier.getAsDouble();
        }
        if ((iGuiTexture = this.progressTexture) instanceof ProgressTexture) {
            ProgressTexture texture = (ProgressTexture)iGuiTexture;
            texture.setProgress(this.lastProgressValue);
        }
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.progressTexture != null) {
            this.progressTexture.draw(graphics, mouseX, mouseY, pos.x, pos.y, size.width, size.height);
        }
        if (this.overlayTexture != null) {
            this.overlayTexture.draw(graphics, mouseX, mouseY, pos.x, pos.y, size.width, size.height);
        }
    }

    @Override
    public void initWidget() {
        super.initWidget();
        this.lastProgressValue = this.progressSupplier.getAsDouble();
    }

    @Override
    public void writeInitialData(class_2540 buffer) {
        super.writeInitialData(buffer);
        buffer.writeDouble(this.lastProgressValue);
    }

    @Override
    public void readInitialData(class_2540 buffer) {
        super.readInitialData(buffer);
        this.lastProgressValue = buffer.readDouble();
    }

    @Override
    public void detectAndSendChanges() {
        double actualValue = this.progressSupplier.getAsDouble();
        if (actualValue - this.lastProgressValue != 0.0) {
            this.lastProgressValue = actualValue;
            this.writeUpdateInfo(0, buffer -> buffer.writeDouble(actualValue));
        }
    }

    @Override
    public void readUpdateInfo(int id, class_2540 buffer) {
        if (id == 0) {
            this.lastProgressValue = buffer.readDouble();
        }
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        IConfigurableWidget.super.buildConfigurator(father);
        for (Configurator configurator : father.getConfigurators()) {
            if (!(configurator instanceof GuiTextureConfigurator)) continue;
            GuiTextureConfigurator guiConfigurator = (GuiTextureConfigurator)configurator;
            if (!configurator.getName().equals("progressTexture")) continue;
            guiConfigurator.setOnUpdate(t -> {
                UIResourceTexture uiResourceTexture;
                if (t instanceof ProgressTexture || t instanceof UIResourceTexture && (uiResourceTexture = (UIResourceTexture)t).getTexture() instanceof ProgressTexture) {
                    this.progressTexture = t;
                }
            });
            guiConfigurator.setAvailable(t -> {
                UIResourceTexture uiResourceTexture;
                return t instanceof ProgressTexture || t instanceof UIResourceTexture && (uiResourceTexture = (UIResourceTexture)t).getTexture() instanceof ProgressTexture;
            });
            guiConfigurator.setTips("ldlib.gui.editor.tips.progress_texture");
        }
    }

    @Override
    public boolean canDragIn(Object dragging) {
        if (dragging instanceof IGuiTexture) {
            UIResourceTexture uiResourceTexture;
            return dragging instanceof ProgressTexture || dragging instanceof UIResourceTexture && (uiResourceTexture = (UIResourceTexture)dragging).getTexture() instanceof ProgressTexture;
        }
        return IConfigurableWidget.super.canDragIn(dragging);
    }

    @Override
    public boolean handleDragging(Object dragging) {
        if (dragging instanceof IGuiTexture) {
            UIResourceTexture uiResourceTexture;
            if (dragging instanceof ProgressTexture || dragging instanceof UIResourceTexture && (uiResourceTexture = (UIResourceTexture)dragging).getTexture() instanceof ProgressTexture) {
                this.progressTexture = (IGuiTexture)dragging;
                return true;
            }
            return false;
        }
        return IConfigurableWidget.super.handleDragging(dragging);
    }

    public ProgressWidget setProgressSupplier(DoubleSupplier progressSupplier) {
        this.progressSupplier = progressSupplier;
        return this;
    }

    public ProgressWidget setDynamicHoverTips(Function<Double, String> dynamicHoverTips) {
        this.dynamicHoverTips = dynamicHoverTips;
        return this;
    }

    public ProgressWidget setProgressTexture(IGuiTexture progressTexture) {
        this.progressTexture = progressTexture;
        return this;
    }

    public ProgressWidget setOverlayTexture(IGuiTexture overlayTexture) {
        this.overlayTexture = overlayTexture;
        return this;
    }
}

