/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.google.common.collect.Lists;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.ingredient.IGhostIngredientTarget;
import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import dev.emi.emi.api.stack.ItemEmiStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_768;

@LDLRegister(name="phantom_item_slot", group="widget.container")
public class PhantomSlotWidget
extends SlotWidget
implements IGhostIngredientTarget,
IConfigurableWidget {
    private boolean clearSlotOnRightClick;
    @Configurable
    @NumberRange(range={0.0, 64.0})
    private int maxStackSize = 64;

    public PhantomSlotWidget() {
    }

    public PhantomSlotWidget(IItemTransfer itemHandler, int slotIndex, int xPosition, int yPosition) {
        super(itemHandler, slotIndex, xPosition, yPosition, true, true);
    }

    public PhantomSlotWidget setClearSlotOnRightClick(boolean clearSlotOnRightClick) {
        this.clearSlotOnRightClick = clearSlotOnRightClick;
        return this;
    }

    @Override
    @ConfigSetter(field="canTakeItems")
    public PhantomSlotWidget setCanTakeItems(boolean v) {
        return this;
    }

    @Override
    @ConfigSetter(field="canPutItems")
    public PhantomSlotWidget setCanPutItems(boolean v) {
        return this;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.slotReference != null && this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            if (this.isClientSideWidget && !this.gui.getModularUIContainer().method_34255().method_7960()) {
                this.slotReference.method_7673(this.gui.getModularUIContainer().method_34255());
            } else if (button == 1 && this.clearSlotOnRightClick && !this.slotReference.method_7677().method_7960()) {
                this.slotReference.method_7673(class_1799.field_8037);
                this.writeClientAction(2, buf -> {});
            } else {
                HOVER_SLOT = this.slotReference;
                this.gui.getModularUIGui().superMouseClicked(mouseX, mouseY, button);
                HOVER_SLOT = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public class_1799 slotClick(int dragType, class_1713 clickTypeIn, class_1657 player) {
        if (this.slotReference != null && this.gui != null) {
            class_1799 stackHeld = this.gui.getModularUIContainer().method_34255();
            return this.slotClickPhantom(this.slotReference, dragType, clickTypeIn, stackHeld);
        }
        return class_1799.field_8037;
    }

    @Override
    public boolean canMergeSlot(class_1799 stack) {
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<Target> getPhantomTargets(Object ingredient) {
        if (LDLib.isEmiLoaded() && ingredient instanceof ItemEmiStack) {
            ItemEmiStack itemEmiStack = (ItemEmiStack)ingredient;
            class_1792 item = (class_1792)itemEmiStack.getKeyOfType(class_1792.class);
            Object object = ingredient = item == null ? null : new class_1799((class_1935)item, (int)itemEmiStack.getAmount());
            if (ingredient instanceof class_1799) {
                class_1799 itemStack = (class_1799)ingredient;
                itemStack.method_7980(itemEmiStack.getNbt());
            }
        }
        if (!(ingredient instanceof class_1799)) {
            return Collections.emptyList();
        }
        final class_768 rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new Target[]{new Target(){

            @Override
            @Nonnull
            public class_768 getArea() {
                return rectangle;
            }

            @Override
            public void accept(@Nonnull Object ingredient) {
                if (LDLib.isEmiLoaded() && ingredient instanceof ItemEmiStack) {
                    ItemEmiStack itemEmiStack = (ItemEmiStack)ingredient;
                    class_1792 item = (class_1792)itemEmiStack.getKeyOfType(class_1792.class);
                    Object object = ingredient = item == null ? null : new class_1799((class_1935)item, (int)itemEmiStack.getAmount());
                    if (ingredient instanceof class_1799) {
                        class_1799 itemStack = (class_1799)ingredient;
                        itemStack.method_7980(itemEmiStack.getNbt());
                    }
                }
                if (PhantomSlotWidget.this.slotReference != null && ingredient instanceof class_1799) {
                    class_1799 stack = (class_1799)ingredient;
                    long id = class_310.method_1551().method_22683().method_4490();
                    boolean shiftDown = class_3675.method_15987((long)id, (int)340) || class_3675.method_15987((long)id, (int)340);
                    class_1713 clickType = shiftDown ? class_1713.field_7794 : class_1713.field_7790;
                    PhantomSlotWidget.this.slotClickPhantom(PhantomSlotWidget.this.slotReference, 0, clickType, stack);
                    PhantomSlotWidget.this.writeClientAction(1, buffer -> {
                        buffer.method_10793(stack);
                        buffer.method_10804(0);
                        buffer.writeBoolean(shiftDown);
                    });
                }
            }
        }});
    }

    @Override
    public void handleClientAction(int id, class_2540 buffer) {
        if (this.slotReference != null && id == 1) {
            class_1799 stackHeld = buffer.method_10819();
            int mouseButton = buffer.method_10816();
            boolean shiftKeyDown = buffer.readBoolean();
            class_1713 clickType = shiftKeyDown ? class_1713.field_7794 : class_1713.field_7790;
            this.slotClickPhantom(this.slotReference, mouseButton, clickType, stackHeld);
        } else if (this.slotReference != null && id == 2) {
            this.slotReference.method_7673(class_1799.field_8037);
        }
    }

    public class_1799 slotClickPhantom(class_1735 slot, int mouseButton, class_1713 clickTypeIn, class_1799 stackHeld) {
        class_1799 stack = class_1799.field_8037;
        class_1799 stackSlot = slot.method_7677();
        if (!stackSlot.method_7960()) {
            stack = stackSlot.method_7972();
        }
        if (mouseButton == 2) {
            this.fillPhantomSlot(slot, class_1799.field_8037, mouseButton);
        } else if (mouseButton == 0 || mouseButton == 1) {
            if (stackSlot.method_7960()) {
                if (!stackHeld.method_7960()) {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton);
                }
            } else if (stackHeld.method_7960()) {
                this.adjustPhantomSlot(slot, mouseButton, clickTypeIn);
            } else {
                if (!this.areItemsEqual(stackSlot, stackHeld)) {
                    this.adjustPhantomSlot(slot, mouseButton, clickTypeIn);
                }
                this.fillPhantomSlot(slot, stackHeld, mouseButton);
            }
        } else if (mouseButton == 5 && !slot.method_7681()) {
            this.fillPhantomSlot(slot, stackHeld, mouseButton);
        }
        return stack;
    }

    private void adjustPhantomSlot(class_1735 slot, int mouseButton, class_1713 clickTypeIn) {
        int stackSize;
        class_1799 stackSlot = slot.method_7677();
        if (clickTypeIn == class_1713.field_7794) {
            stackSize = mouseButton == 0 ? (stackSlot.method_7947() + 1) / 2 : stackSlot.method_7947() * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.method_7947() - 1 : stackSlot.method_7947() + 1;
        }
        if (stackSize > slot.method_7675()) {
            stackSize = slot.method_7675();
        }
        stackSlot.method_7939(Math.min(this.maxStackSize, stackSize));
        slot.method_7673(stackSlot);
    }

    private void fillPhantomSlot(class_1735 slot, class_1799 stackHeld, int mouseButton) {
        int stackSize;
        if (stackHeld.method_7960()) {
            slot.method_7673(class_1799.field_8037);
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.method_7947() : 1;
        if (stackSize > slot.method_7675()) {
            stackSize = slot.method_7675();
        }
        class_1799 phantomStack = stackHeld.method_7972();
        phantomStack.method_7939(Math.min(this.maxStackSize, stackSize));
        slot.method_7673(phantomStack);
    }

    public boolean areItemsEqual(class_1799 itemStack1, class_1799 itemStack2) {
        return class_1799.method_7973((class_1799)itemStack1, (class_1799)itemStack2);
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }
}

