/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.google.common.collect.Lists;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.ingredient.IGhostIngredientTarget;
import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import dev.architectury.fluid.FluidStack;
import dev.emi.emi.api.stack.FluidEmiStack;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3611;
import net.minecraft.class_768;

@LDLRegister(name="phantom_fluid_slot", group="widget.container")
public class PhantomFluidWidget
extends TankWidget
implements IGhostIngredientTarget,
IConfigurableWidget {
    private Consumer<com.lowdragmc.lowdraglib.side.fluid.FluidStack> fluidStackUpdater;

    public PhantomFluidWidget() {
        this.allowClickFilled = false;
        this.allowClickDrained = false;
    }

    public PhantomFluidWidget(IFluidStorage fluidTank, int x, int y) {
        super(fluidTank, x, y, false, false);
    }

    public PhantomFluidWidget(@Nullable IFluidStorage fluidTank, int x, int y, int width, int height) {
        super(fluidTank, x, y, width, height, false, false);
    }

    public PhantomFluidWidget setIFluidStackUpdater(Consumer<com.lowdragmc.lowdraglib.side.fluid.FluidStack> fluidStackUpdater) {
        this.fluidStackUpdater = fluidStackUpdater;
        return this;
    }

    @Override
    @ConfigSetter(field="allowClickFilled")
    public PhantomFluidWidget setAllowClickFilled(boolean v) {
        return this;
    }

    @Override
    @ConfigSetter(field="allowClickDrained")
    public PhantomFluidWidget setAllowClickDrained(boolean v) {
        return this;
    }

    public static com.lowdragmc.lowdraglib.side.fluid.FluidStack drainFrom(Object ingredient) {
        class_1799 itemStack;
        IFluidTransfer handler;
        class_1856 ingred;
        class_1799[] items;
        if (ingredient instanceof class_1856 && (items = (ingred = (class_1856)ingredient).method_8105()).length > 0) {
            ingredient = items[0];
        }
        if (ingredient instanceof class_1799 && (handler = FluidTransferHelper.getFluidTransfer(new ItemStackTransfer(itemStack = (class_1799)ingredient), 0)) != null) {
            return handler.drain(Long.MAX_VALUE, true);
        }
        return null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<Target> getPhantomTargets(Object ingredient) {
        if (LDLib.isReiLoaded() && ingredient instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)ingredient;
            ingredient = com.lowdragmc.lowdraglib.side.fluid.FluidStack.create(fluidStack.getFluid(), this.fluidTank.getCapacity(), fluidStack.getTag());
        }
        if (LDLib.isEmiLoaded() && ingredient instanceof FluidEmiStack) {
            FluidEmiStack fluidEmiStack = (FluidEmiStack)ingredient;
            class_3611 fluid = (class_3611)fluidEmiStack.getKeyOfType(class_3611.class);
            Object object = ingredient = fluid == null ? com.lowdragmc.lowdraglib.side.fluid.FluidStack.empty() : com.lowdragmc.lowdraglib.side.fluid.FluidStack.create(fluid, this.fluidTank.getCapacity(), fluidEmiStack.getNbt());
        }
        if (!(ingredient instanceof com.lowdragmc.lowdraglib.side.fluid.FluidStack) && PhantomFluidWidget.drainFrom(ingredient) == null) {
            return Collections.emptyList();
        }
        final class_768 rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new Target[]{new Target(){

            @Override
            @Nonnull
            public class_768 getArea() {
                return rectangle;
            }

            @Override
            public void accept(@Nonnull Object ingredient) {
                com.lowdragmc.lowdraglib.side.fluid.FluidStack ingredientStack;
                if (PhantomFluidWidget.this.fluidTank == null) {
                    return;
                }
                if (LDLib.isReiLoaded() && ingredient instanceof FluidStack) {
                    FluidStack fluidStack = (FluidStack)ingredient;
                    ingredient = com.lowdragmc.lowdraglib.side.fluid.FluidStack.create(fluidStack.getFluid(), PhantomFluidWidget.this.fluidTank.getCapacity(), fluidStack.getTag());
                }
                if (LDLib.isEmiLoaded() && ingredient instanceof FluidEmiStack) {
                    FluidEmiStack fluidEmiStack = (FluidEmiStack)ingredient;
                    class_3611 fluid = (class_3611)fluidEmiStack.getKeyOfType(class_3611.class);
                    ingredient = fluid == null ? com.lowdragmc.lowdraglib.side.fluid.FluidStack.empty() : com.lowdragmc.lowdraglib.side.fluid.FluidStack.create(fluid, PhantomFluidWidget.this.fluidTank.getCapacity(), fluidEmiStack.getNbt());
                }
                if ((ingredientStack = ingredient instanceof com.lowdragmc.lowdraglib.side.fluid.FluidStack ? (com.lowdragmc.lowdraglib.side.fluid.FluidStack)ingredient : PhantomFluidWidget.drainFrom(ingredient)) != null) {
                    class_2487 tagCompound = ingredientStack.saveToTag(new class_2487());
                    PhantomFluidWidget.this.writeClientAction(2, buffer -> buffer.method_10794(tagCompound));
                }
                if (PhantomFluidWidget.this.isClientSideWidget) {
                    PhantomFluidWidget.this.fluidTank.drain(PhantomFluidWidget.this.fluidTank.getCapacity(), false);
                    if (ingredientStack != null) {
                        PhantomFluidWidget.this.fluidTank.fill(ingredientStack.copy(), false);
                    }
                    if (PhantomFluidWidget.this.fluidStackUpdater != null) {
                        PhantomFluidWidget.this.fluidStackUpdater.accept(ingredientStack);
                    }
                }
            }
        }});
    }

    @Override
    public void handleClientAction(int id, class_2540 buffer) {
        if (id == 1) {
            this.handlePhantomClick();
        } else if (id == 2) {
            com.lowdragmc.lowdraglib.side.fluid.FluidStack fluidStack = com.lowdragmc.lowdraglib.side.fluid.FluidStack.loadFromTag(buffer.method_10798());
            if (this.fluidTank == null) {
                return;
            }
            this.fluidTank.drain(this.fluidTank.getCapacity(), false);
            if (fluidStack != null) {
                this.fluidTank.fill(fluidStack.copy(), false);
            }
            if (this.fluidStackUpdater != null) {
                this.fluidStackUpdater.accept(fluidStack);
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (this.isClientSideWidget) {
                this.handlePhantomClick();
            } else {
                this.writeClientAction(1, buffer -> {});
            }
            return true;
        }
        return false;
    }

    private void handlePhantomClick() {
        if (this.fluidTank == null) {
            return;
        }
        class_1799 itemStack = this.gui.getModularUIContainer().method_34255().method_7972();
        if (!itemStack.method_7960()) {
            itemStack.method_7939(1);
            IFluidTransfer handler = FluidTransferHelper.getFluidTransfer(this.gui.entityPlayer, this.gui.getModularUIContainer());
            if (handler != null) {
                com.lowdragmc.lowdraglib.side.fluid.FluidStack resultFluid = handler.drain(Integer.MAX_VALUE, true);
                this.fluidTank.drain(this.fluidTank.getCapacity(), false);
                this.fluidTank.fill(resultFluid.copy(), false);
                if (this.fluidStackUpdater != null) {
                    this.fluidStackUpdater.accept(resultFluid);
                }
            }
        } else {
            this.fluidTank.drain(this.fluidTank.getCapacity(), false);
            if (this.fluidStackUpdater != null) {
                this.fluidStackUpdater.accept(null);
            }
        }
    }
}

