/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;

@Configurable(name="ldlib.gui.editor.register.widget.label", collapse=false)
@LDLRegister(name="label", group="widget.basic")
public class LabelWidget
extends Widget
implements IConfigurableWidget {
    @Nonnull
    protected Supplier<String> textSupplier;
    @Nullable
    protected class_2561 component;
    @Configurable(name="ldlib.gui.editor.name.text")
    private String lastTextValue = "";
    @Configurable
    @NumberColor
    private int color;
    @Configurable
    private boolean dropShadow;

    public LabelWidget() {
        this(0, 0, "label");
    }

    public LabelWidget(int xPosition, int yPosition, String text) {
        this(xPosition, yPosition, () -> text);
    }

    public LabelWidget(int xPosition, int yPosition, class_2561 component) {
        super(new Position(xPosition, yPosition), new Size(10, 10));
        this.setDropShadow(true);
        this.setTextColor(-1);
        this.component = component;
        if (this.isRemote()) {
            this.lastTextValue = component.getString();
            this.updateSize();
        }
    }

    public LabelWidget(int xPosition, int yPosition, Supplier<String> text) {
        super(new Position(xPosition, yPosition), new Size(10, 10));
        this.setDropShadow(true);
        this.setTextColor(-1);
        this.textSupplier = text;
        if (this.isRemote()) {
            this.lastTextValue = text.get();
            this.updateSize();
        }
    }

    @ConfigSetter(field="lastTextValue")
    public void setText(String text) {
        this.textSupplier = () -> text;
    }

    public LabelWidget setTextColor(int color) {
        this.color = color;
        if (this.component != null) {
            this.component = this.component.method_27661().method_27696(this.component.method_10866().method_36139(color));
        }
        return this;
    }

    public LabelWidget setDropShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        return this;
    }

    @Override
    public void writeInitialData(class_2540 buffer) {
        super.writeInitialData(buffer);
        if (!this.isClientSideWidget) {
            if (this.component != null) {
                buffer.writeBoolean(true);
                buffer.method_10805(this.component);
            } else {
                buffer.writeBoolean(false);
                this.lastTextValue = this.textSupplier.get();
                buffer.method_10814(this.lastTextValue);
            }
        } else {
            buffer.writeBoolean(false);
            buffer.method_10814(this.lastTextValue);
        }
    }

    @Override
    public void readInitialData(class_2540 buffer) {
        super.readInitialData(buffer);
        if (buffer.readBoolean()) {
            this.component = buffer.method_10808();
            this.lastTextValue = this.component.getString();
        } else {
            this.lastTextValue = buffer.method_19772();
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (!this.isClientSideWidget) {
            String latest;
            if (this.component != null && !(latest = this.component.getString()).equals(this.lastTextValue)) {
                this.lastTextValue = latest;
                this.writeUpdateInfo(-2, buffer -> buffer.method_10805(this.component));
            }
            if (!(latest = this.textSupplier.get()).equals(this.lastTextValue)) {
                this.lastTextValue = latest;
                this.writeUpdateInfo(-1, buffer -> buffer.method_10814(this.lastTextValue));
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void readUpdateInfo(int id, class_2540 buffer) {
        if (id == -1) {
            this.lastTextValue = buffer.method_19772();
            this.updateSize();
        } else if (id == -2) {
            this.component = buffer.method_10808();
            this.lastTextValue = this.component.getString();
            this.updateSize();
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.isClientSideWidget) {
            String latest;
            String string = latest = this.component == null ? this.textSupplier.get() : this.component.getString();
            if (!latest.equals(this.lastTextValue)) {
                this.lastTextValue = latest;
                this.updateSize();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void updateSize() {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int n = this.component == null ? fontRenderer.method_1727(LocalizationUtils.format(this.lastTextValue, new Object[0])) : fontRenderer.method_27525((class_5348)this.component);
        Objects.requireNonNull(fontRenderer);
        this.setSize(new Size(n, 9));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        class_327 fontRenderer = class_310.method_1551().field_1772;
        Position position = this.getPosition();
        if (this.component == null) {
            String suppliedText = LocalizationUtils.format(this.lastTextValue, new Object[0]);
            String[] split = suppliedText.split("\n");
            for (int i = 0; i < split.length; ++i) {
                int n = position.y;
                Objects.requireNonNull(fontRenderer);
                int y = n + i * (9 + 2);
                graphics.method_51433(fontRenderer, split[i], position.x, y, this.color, this.dropShadow);
            }
        } else {
            graphics.method_51439(fontRenderer, this.component, position.x, position.y, this.color, this.dropShadow);
        }
    }

    @Override
    public boolean handleDragging(Object dragging) {
        if (dragging instanceof String) {
            String string = (String)dragging;
            this.setText(string);
            return true;
        }
        return IConfigurableWidget.super.handleDragging(dragging);
    }

    public void setTextSupplier(@Nonnull Supplier<String> textSupplier) {
        if (textSupplier == null) {
            throw new NullPointerException("textSupplier is marked non-null but is null");
        }
        this.textSupplier = textSupplier;
    }

    public void setComponent(@Nullable class_2561 component) {
        this.component = component;
    }
}

