/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.HsbColorWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.MenuWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.GradientColor;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class GradientColorWidget
extends WidgetGroup {
    protected final GradientColor gradientColor;
    protected final HsbColorWidget hsbColorWidget;
    protected int selectedAlphaPoint = -1;
    protected int selectedRGBPoint = 0;
    protected Consumer<GradientColor> onUpdate;
    private boolean isDraggingAlphaPoint;
    private boolean isDraggingRGBPoint;
    private long lastClickTick;

    public GradientColorWidget(int x, int y, int width, GradientColor gradientColor) {
        super(x, y, width, width + 15 + 20 + 3);
        this.gradientColor = gradientColor;
        this.addWidget(new ImageWidget(3, 13, width - 6, 15, ColorPattern.WHITE.borderTexture(1)));
        this.hsbColorWidget = new HsbColorWidget(3, 38, width - 6, width - 6).setColorSupplier(() -> {
            float t = this.selectedAlphaPoint >= 0 ? gradientColor.getAP().get((int)this.selectedAlphaPoint).field_1343 : (this.selectedRGBPoint >= 0 ? gradientColor.getRP().get((int)this.selectedRGBPoint).field_1343 : 0.0f);
            return gradientColor.getColor(t);
        }).setOnChanged(color -> {
            if (this.selectedAlphaPoint >= 0) {
                gradientColor.getAP().set(this.selectedAlphaPoint, new class_241(gradientColor.getAP().get((int)this.selectedAlphaPoint).field_1343, ColorUtils.alpha(color)));
                this.notifyChanged();
            }
            if (this.selectedRGBPoint >= 0) {
                gradientColor.getRP().set(this.selectedRGBPoint, new class_241(gradientColor.getRP().get((int)this.selectedRGBPoint).field_1343, ColorUtils.red(color)));
                gradientColor.getGP().set(this.selectedRGBPoint, new class_241(gradientColor.getGP().get((int)this.selectedRGBPoint).field_1343, ColorUtils.green(color)));
                gradientColor.getBP().set(this.selectedRGBPoint, new class_241(gradientColor.getBP().get((int)this.selectedRGBPoint).field_1343, ColorUtils.blue(color)));
                this.notifyChanged();
            }
        });
        this.addWidget(this.hsbColorWidget);
        this.hsbColorWidget.setShowAlpha(false);
        this.hsbColorWidget.setShowRGB(true);
    }

    protected void notifyChanged() {
        if (this.onUpdate != null) {
            this.onUpdate.accept(this.gradientColor);
        }
    }

    private float getXPosition(float t) {
        Size size = this.getSize();
        Position pos = this.getPosition();
        return (float)(pos.x + 3) + (float)(size.width - 6) * t;
    }

    private float getXCoord(float x) {
        Size size = this.getSize();
        Position position = this.getPosition();
        return (x - (float)position.x - 3.0f) / (float)(size.width - 6);
    }

    protected void openMenu(int mouseX, int mouseY) {
        if (this.selectedAlphaPoint >= 0 && this.gradientColor.getAP().size() > 1 || this.selectedRGBPoint >= 0 && this.gradientColor.getRP().size() > 1) {
            TreeBuilder.Menu menu = TreeBuilder.Menu.start().leaf("Remove", () -> {
                if (this.selectedAlphaPoint >= 0) {
                    this.gradientColor.getAP().remove(this.selectedAlphaPoint);
                    this.selectedAlphaPoint = -1;
                    this.notifyChanged();
                } else if (this.selectedRGBPoint >= 0) {
                    this.gradientColor.getRP().remove(this.selectedRGBPoint);
                    this.gradientColor.getGP().remove(this.selectedRGBPoint);
                    this.gradientColor.getBP().remove(this.selectedRGBPoint);
                    this.selectedRGBPoint = -1;
                    this.notifyChanged();
                }
            });
            MenuWidget widget = new MenuWidget(mouseX - this.getPosition().x, mouseY - this.getPosition().y, 14, menu.build()).setNodeTexture(MenuWidget.NODE_TEXTURE).setLeafTexture(MenuWidget.LEAF_TEXTURE).setNodeHoverTexture(MenuWidget.NODE_HOVER_TEXTURE).setCrossLinePredicate(TreeBuilder.Menu::isCrossLine).setKeyIconSupplier(TreeBuilder.Menu::getIcon).setKeyNameSupplier(TreeBuilder.Menu::getName).setOnNodeClicked(TreeBuilder.Menu::handle);
            this.waitToAdded(widget.setBackground(MenuWidget.BACKGROUND));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (button == 1) {
                this.openMenu((int)mouseX, (int)mouseY);
            } else {
                int i;
                long clickTick = this.gui.getTickCount();
                Size size = this.getSize();
                Position pos = this.getPosition();
                for (i = 0; i < this.gradientColor.getAP().size(); ++i) {
                    if (!GradientColorWidget.isMouseOver((int)(this.getXPosition(this.gradientColor.getAP().get((int)i).field_1343) - 5.0f), pos.y + 3, 10, 10, mouseX, mouseY)) continue;
                    this.selectedAlphaPoint = i;
                    this.selectedRGBPoint = -1;
                    this.isDraggingAlphaPoint = true;
                    this.hsbColorWidget.setShowAlpha(true);
                    this.hsbColorWidget.setShowRGB(false);
                    return true;
                }
                for (i = 0; i < this.gradientColor.getRP().size(); ++i) {
                    if (!GradientColorWidget.isMouseOver((int)(this.getXPosition(this.gradientColor.getRP().get((int)i).field_1343) - 5.0f), pos.y + 3 + 10 + 15, 10, 10, mouseX, mouseY)) continue;
                    this.selectedRGBPoint = i;
                    this.selectedAlphaPoint = -1;
                    this.isDraggingRGBPoint = true;
                    this.hsbColorWidget.setShowAlpha(false);
                    this.hsbColorWidget.setShowRGB(true);
                    return true;
                }
                if (clickTick - this.lastClickTick < 12L) {
                    int color;
                    if (GradientColorWidget.isMouseOver(pos.x + 3, pos.y + 3, size.width - 6, 10, mouseX, mouseY)) {
                        color = this.gradientColor.getColor(this.getXCoord((float)mouseX));
                        this.gradientColor.addAlpha(this.getXCoord((float)mouseX), ColorUtils.alpha(color));
                        this.notifyChanged();
                        return true;
                    }
                    if (GradientColorWidget.isMouseOver(pos.x + 3, pos.y + 3 + 10 + 15, size.width - 6, 10, mouseX, mouseY)) {
                        color = this.gradientColor.getColor(this.getXCoord((float)mouseX));
                        this.gradientColor.addRGB(this.getXCoord((float)mouseX), ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color));
                        this.notifyChanged();
                        return true;
                    }
                } else {
                    this.lastClickTick = clickTick;
                }
            }
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isDraggingRGBPoint = false;
        this.isDraggingAlphaPoint = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Size size = this.getSize();
        Position pos = this.getPosition();
        if (mouseX >= (double)(pos.x + 3) && mouseX <= (double)(pos.x + size.width - 6)) {
            if (this.selectedAlphaPoint >= 0 && this.isDraggingAlphaPoint) {
                float t = this.getXCoord((float)class_3532.method_15350((double)mouseX, (double)(pos.x + 3), (double)(pos.x + size.width - 6)));
                this.selectedAlphaPoint = this.gradientColor.addAlpha(t, this.gradientColor.getAP().remove((int)this.selectedAlphaPoint).field_1342);
                this.notifyChanged();
                return true;
            }
            if (this.selectedRGBPoint >= 0 && this.isDraggingRGBPoint) {
                float t = this.getXCoord((float)class_3532.method_15350((double)mouseX, (double)(pos.x + 3), (double)(pos.x + size.width - 6)));
                this.selectedRGBPoint = this.gradientColor.addRGB(t, this.gradientColor.getRP().remove((int)this.selectedRGBPoint).field_1342, this.gradientColor.getGP().remove((int)this.selectedRGBPoint).field_1342, this.gradientColor.getBP().remove((int)this.selectedRGBPoint).field_1342);
                this.notifyChanged();
                return true;
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@Nonnull @NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.drawBackgroundTexture(graphics, mouseX, mouseY);
        Size size = this.getSize();
        Position pos = this.getPosition();
        for (i = 0; i < this.gradientColor.getAP().size(); ++i) {
            Icons.DOWN.copy().setColor(i == this.selectedAlphaPoint ? ColorPattern.GREEN.color : -1).draw(graphics, mouseX, mouseY, this.getXPosition(this.gradientColor.getAP().get((int)i).field_1343) - 5.0f, pos.y + 3, 10, 10);
        }
        for (i = 0; i < this.gradientColor.getRP().size(); ++i) {
            Icons.UP.copy().setColor(i == this.selectedRGBPoint ? ColorPattern.GREEN.color : -1).draw(graphics, mouseX, mouseY, this.getXPosition(this.gradientColor.getRP().get((int)i).field_1343) - 5.0f, pos.y + 3 + 10 + 15, 10, 10);
        }
        int width = size.width - 6;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        int p = 0;
        for (int x = 0; x < width; x += 3) {
            for (int y = 0; y < 15; y += 3) {
                boolean isWhite = p++ % 2 == 0;
                float minX = pos.x + 3 + x;
                float maxX = pos.x + 3 + x + 3;
                float minY = pos.y + 13 + y;
                float maxY = pos.y + 13 + y + 3;
                bufferBuilder.method_22918(matrix, minX, maxY, 0.0f).method_39415(isWhite ? -1 : ColorPattern.GRAY.color).method_1344();
                bufferBuilder.method_22918(matrix, maxX, maxY, 0.0f).method_39415(isWhite ? -1 : ColorPattern.GRAY.color).method_1344();
                bufferBuilder.method_22918(matrix, maxX, minY, 0.0f).method_39415(isWhite ? -1 : ColorPattern.GRAY.color).method_1344();
                bufferBuilder.method_22918(matrix, minX, minY, 0.0f).method_39415(isWhite ? -1 : ColorPattern.GRAY.color).method_1344();
            }
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Matrix4f mat = graphics.method_51448().method_23760().method_23761();
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        int y = pos.y + 13;
        int yh = 15 + y;
        for (int i2 = 0; i2 < width; ++i2) {
            float x = this.getXPosition((float)i2 * 1.0f / (float)width);
            float xw = this.getXPosition(((float)i2 + 1.0f) / (float)width);
            int startColor = this.gradientColor.getColor((float)i2 * 1.0f / (float)width);
            int endColor = this.gradientColor.getColor(((float)i2 + 1.0f) / (float)width);
            float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
            float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
            float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
            float startBlue = (float)(startColor & 0xFF) / 255.0f;
            float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
            float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
            float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
            float endBlue = (float)(endColor & 0xFF) / 255.0f;
            buffer.method_22918(mat, xw, (float)y, 0.0f).method_22915(endRed, endGreen, endBlue, endAlpha).method_1344();
            buffer.method_22918(mat, x, (float)y, 0.0f).method_22915(startRed, startGreen, startBlue, startAlpha).method_1344();
            buffer.method_22918(mat, x, (float)yh, 0.0f).method_22915(startRed, startGreen, startBlue, startAlpha).method_1344();
            buffer.method_22918(mat, xw, (float)yh, 0.0f).method_22915(endRed, endGreen, endBlue, endAlpha).method_1344();
        }
        tesselator.method_1350();
        this.drawWidgetsBackground(graphics, mouseX, mouseY, partialTicks);
    }

    public void setOnUpdate(Consumer<GradientColor> onUpdate) {
        this.onUpdate = onUpdate;
    }
}

