/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.PhantomFluidWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;

public class FluidStackSelectorWidget
extends WidgetGroup {
    private Consumer<FluidStack> onIFluidStackUpdate;
    private final IFluidStorage handler;
    private final TextFieldWidget fluidField;
    private FluidStack fluid = FluidStack.empty();

    public FluidStackSelectorWidget(int x, int y, int width) {
        super(x, y, width, 20);
        this.setClientSideWidget();
        this.fluidField = (TextFieldWidget)new TextFieldWidget(22, 0, width - 46, 20, null, s -> {
            if (s != null && !s.isEmpty()) {
                class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(s));
                if (fluid == null) {
                    fluid = FluidStack.empty().getFluid();
                }
                if (!this.fluid.isFluidEqual(FluidStack.create(fluid, 1000L))) {
                    this.fluid = FluidStack.create(fluid, 1000L);
                    this.onUpdate();
                }
            }
        }).setResourceLocationOnly().setHoverTooltips("ldlib.gui.tips.fluid_selector");
        this.handler = new FluidStorage(1000L);
        this.addWidget(new PhantomFluidWidget(this.handler, 1, 1).setIFluidStackUpdater(fluidStack -> {
            this.setIFluidStack((FluidStack)fluidStack);
            this.onUpdate();
        }).setBackground((IGuiTexture)new ColorBorderTexture(1, -1)));
        this.addWidget(this.fluidField);
        this.addWidget(new ButtonWidget(width - 21, 0, 20, 20, null, cd -> {
            if (this.fluid.isEmpty()) {
                return;
            }
            TextFieldWidget nbtField = new TextFieldWidget(10, 10, this.getGui().mainGroup.getSize().width - 50, 20, null, s -> {
                try {
                    this.fluid.setTag(class_2522.method_10718((String)s));
                    this.onUpdate();
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            });
            new DialogWidget(this.getGui().mainGroup, this.isClientSideWidget).setOnClosed(this::onUpdate).addWidget(nbtField);
            if (this.fluid.hasTag()) {
                nbtField.setCurrentString(this.fluid.getTag().toString());
            }
        }).setButtonTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("NBT", -1).setDropShadow(true)).setHoverBorderTexture(1, -1).setHoverTooltips("ldlib.gui.tips.fluid_tag"));
    }

    public FluidStack getIFluidStack() {
        return this.fluid;
    }

    public FluidStackSelectorWidget setIFluidStack(FluidStack fluidStack) {
        this.fluid = Objects.requireNonNullElse(fluidStack, FluidStack.empty()).copy();
        if (this.fluid != FluidStack.empty()) {
            this.fluid.setAmount(1000L);
        }
        this.handler.setFluid(this.fluid);
        this.fluidField.setCurrentString(class_7923.field_41173.method_10221((Object)this.fluid.getFluid()));
        return this;
    }

    public FluidStackSelectorWidget setOnIFluidStackUpdate(Consumer<FluidStack> onIFluidStackUpdate) {
        this.onIFluidStackUpdate = onIFluidStackUpdate;
        return this;
    }

    private void onUpdate() {
        this.handler.setFluid(this.fluid);
        if (this.onIFluidStackUpdate != null) {
            this.onIFluidStackUpdate.accept(this.fluid);
        }
    }
}

