/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_768;

@LDLRegister(name="draggable_scrollable_group", group="widget.group")
public class DraggableScrollableWidgetGroup
extends WidgetGroup {
    protected int scrollXOffset;
    protected int scrollYOffset;
    @Configurable
    @NumberRange(range={0.0, 2.147483647E9})
    protected int xBarHeight;
    @Configurable
    @NumberRange(range={0.0, 2.147483647E9})
    protected int yBarWidth;
    @Configurable
    protected boolean draggable;
    @Configurable
    protected boolean scrollable = true;
    @Configurable
    protected boolean useScissor;
    protected int maxHeight;
    protected int maxWidth;
    @Configurable(name="X Bar Background")
    protected IGuiTexture xBarB;
    @Configurable(name="X Bar Texture")
    protected IGuiTexture xBarF;
    @Configurable(name="Y Bar Background")
    protected IGuiTexture yBarB;
    @Configurable(name="Y Bar Texture")
    protected IGuiTexture yBarF;
    protected Widget draggedWidget;
    protected Widget selectedWidget;
    protected boolean isComputingMax;
    private boolean draggedPanel;
    private boolean draggedOnXScrollBar;
    private boolean draggedOnYScrollBar;
    private double lastDeltaX;
    private double lastDeltaY;

    public DraggableScrollableWidgetGroup() {
        this(0, 0, 50, 50);
    }

    @Override
    public void initTemplate() {
        this.setBackground((IGuiTexture)ColorPattern.RED.rectTexture());
        this.setYScrollBarWidth(4).setYBarStyle(ColorPattern.RED.rectTexture(), ColorPattern.WHITE.rectTexture().setRadius(2.0f));
    }

    public DraggableScrollableWidgetGroup(int x, int y, int width, int height) {
        super(new Position(x, y), new Size(width, height));
        this.maxHeight = height;
        this.maxWidth = width;
        this.useScissor = true;
    }

    @ConfigSetter(field="xBarHeight")
    public DraggableScrollableWidgetGroup setXScrollBarHeight(int xBar) {
        this.xBarHeight = xBar;
        this.computeMax();
        return this;
    }

    @ConfigSetter(field="yBarWidth")
    public DraggableScrollableWidgetGroup setYScrollBarWidth(int yBar) {
        this.yBarWidth = yBar;
        this.computeMax();
        return this;
    }

    public DraggableScrollableWidgetGroup setDraggable(boolean draggable) {
        this.draggable = draggable;
        return this;
    }

    public DraggableScrollableWidgetGroup setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
        return this;
    }

    public DraggableScrollableWidgetGroup setBackground(IGuiTexture background) {
        super.setBackground(background);
        return this;
    }

    public DraggableScrollableWidgetGroup setXBarStyle(IGuiTexture background, IGuiTexture bar) {
        this.xBarB = background;
        this.xBarF = bar;
        return this;
    }

    public DraggableScrollableWidgetGroup setYBarStyle(IGuiTexture background, IGuiTexture bar) {
        this.yBarB = background;
        this.yBarF = bar;
        return this;
    }

    public void setUseScissor(boolean useScissor) {
        this.useScissor = useScissor;
    }

    public int getScrollYOffset() {
        return this.scrollYOffset;
    }

    public int getScrollXOffset() {
        return this.scrollXOffset;
    }

    @Override
    public WidgetGroup addWidget(int index, Widget widget) {
        this.maxHeight = Math.max(this.maxHeight, widget.getSize().height + widget.getSelfPosition().y);
        this.maxWidth = Math.max(this.maxWidth, widget.getSize().width + widget.getSelfPosition().x);
        Position newPos = widget.addSelfPosition(-this.scrollXOffset, -this.scrollYOffset);
        widget.setVisible(newPos.x < this.getSize().width - this.yBarWidth && newPos.x + widget.getSize().width > 0);
        widget.setVisible(newPos.y < this.getSize().height - this.xBarHeight && newPos.y + widget.getSize().height > 0);
        return super.addWidget(index, widget);
    }

    @Override
    public void removeWidget(Widget widget) {
        super.removeWidget(widget);
        this.computeMax();
        if (widget == this.draggedWidget) {
            this.draggedWidget = null;
        }
        if (widget == this.selectedWidget) {
            this.selectedWidget = null;
        }
    }

    @Override
    public void clearAllWidgets() {
        super.clearAllWidgets();
        this.maxHeight = this.getSize().height;
        this.maxWidth = this.getSize().width;
        this.scrollXOffset = 0;
        this.scrollYOffset = 0;
        this.draggedWidget = null;
        this.selectedWidget = null;
    }

    @Override
    @ConfigSetter(field="size")
    public void setSize(Size size) {
        super.setSize(size);
        this.maxHeight = Math.max(size.height, this.maxHeight);
        this.maxWidth = Math.max(size.width, this.maxWidth);
        for (Widget widget : this.widgets) {
            Position newPos = widget.getSelfPosition();
            widget.setVisible(newPos.x < this.getSize().width - this.yBarWidth && newPos.x + widget.getSize().width > 0);
            widget.setVisible(newPos.y < this.getSize().height - this.xBarHeight && newPos.y + widget.getSize().height > 0);
        }
    }

    @Override
    protected void onChildSelfPositionUpdate(Widget child) {
        if (!this.isComputingMax && this.isInitialized()) {
            this.computeMax();
        }
    }

    @Override
    protected void onChildSizeUpdate(Widget child) {
        if (!this.isComputingMax && this.isInitialized()) {
            this.computeMax();
        }
    }

    public void computeMax() {
        if (this.isComputingMax) {
            return;
        }
        this.isComputingMax = true;
        int lastScrollXOffset = this.scrollXOffset;
        int lastScrollYOffset = this.scrollYOffset;
        int mh = 0;
        int mw = 0;
        for (Widget widget : this.widgets) {
            mh = Math.max(mh, widget.getSize().height + widget.getSelfPosition().y + this.scrollYOffset);
            mw = Math.max(mw, widget.getSize().width + widget.getSelfPosition().x + this.scrollXOffset);
        }
        int offsetY = 0;
        int offsetX = 0;
        if (mh > this.getSize().height) {
            offsetY = this.maxHeight - mh;
            this.maxHeight = mh;
            if (this.scrollYOffset - offsetY < 0) {
                offsetY = this.scrollYOffset;
            }
            this.scrollYOffset -= offsetY;
        } else if (mh < this.getSize().height) {
            offsetY = this.maxHeight - this.getSize().height;
            this.maxHeight = this.getSize().height;
            if (this.scrollYOffset - offsetY < 0) {
                offsetY = this.scrollYOffset;
            }
            this.scrollYOffset -= offsetY;
        }
        if (mw > this.getSize().width) {
            offsetX = this.maxWidth - mw;
            this.maxWidth = mw;
            if (this.scrollXOffset - offsetX < 0) {
                offsetX = this.scrollXOffset;
            }
            this.scrollXOffset -= offsetX;
        } else if (mw < this.getSize().width) {
            offsetX = this.maxWidth - this.getSize().width;
            this.maxWidth = this.getSize().width;
            if (this.scrollXOffset - offsetX < 0) {
                offsetX = this.scrollXOffset;
            }
            this.scrollXOffset -= offsetX;
        }
        offsetX += this.scrollXOffset - Math.min(this.scrollXOffset, lastScrollXOffset);
        offsetY += this.scrollYOffset - Math.min(this.scrollYOffset, lastScrollYOffset);
        this.scrollXOffset = Math.min(this.scrollXOffset, lastScrollXOffset);
        this.scrollYOffset = Math.min(this.scrollYOffset, lastScrollYOffset);
        for (Widget widget : this.widgets) {
            Position newPos = widget.addSelfPosition(offsetX, offsetY);
            widget.setVisible(newPos.x < this.getSize().width - this.yBarWidth && newPos.x + widget.getSize().width > 0);
            widget.setVisible(newPos.y < this.getSize().height - this.xBarHeight && newPos.y + widget.getSize().height > 0);
        }
        this.isComputingMax = false;
    }

    protected int getMaxHeight() {
        return this.maxHeight + this.xBarHeight;
    }

    protected int getMaxWidth() {
        return this.maxWidth + this.yBarWidth;
    }

    public int getWidgetBottomHeight() {
        int y = 0;
        for (Widget widget : this.widgets) {
            y = Math.max(y, widget.getSize().height + widget.getSelfPosition().y);
        }
        return y;
    }

    public void setScrollXOffset(int scrollXOffset) {
        if (scrollXOffset == this.scrollXOffset) {
            return;
        }
        if (scrollXOffset < 0) {
            scrollXOffset = 0;
        }
        int offset = scrollXOffset - this.scrollXOffset;
        this.scrollXOffset = scrollXOffset;
        this.isComputingMax = true;
        for (Widget widget : this.widgets) {
            Position newPos = widget.addSelfPosition(-offset, 0);
            widget.setVisible(newPos.x < this.getSize().width - this.yBarWidth && newPos.x + widget.getSize().width > 0);
        }
        this.isComputingMax = false;
    }

    public void setScrollYOffset(int scrollYOffset) {
        if (scrollYOffset == this.scrollYOffset) {
            return;
        }
        if (scrollYOffset < 0) {
            scrollYOffset = 0;
        }
        int offset = scrollYOffset - this.scrollYOffset;
        this.scrollYOffset = scrollYOffset;
        this.isComputingMax = true;
        for (Widget widget : this.widgets) {
            Position newPos = widget.addSelfPosition(0, -offset);
            widget.setVisible(newPos.y < this.getSize().height - this.xBarHeight && newPos.y + widget.getSize().height > 0);
        }
        this.isComputingMax = false;
    }

    private boolean isOnXScrollPane(double mouseX, double mouseY) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        return DraggableScrollableWidgetGroup.isMouseOver(pos.x, pos.y + size.height - this.xBarHeight, size.width, this.xBarHeight, mouseX, mouseY);
    }

    private boolean isOnYScrollPane(double mouseX, double mouseY) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        return DraggableScrollableWidgetGroup.isMouseOver(pos.x + size.width - this.yBarWidth, pos.y, this.yBarWidth, size.height, mouseX, mouseY);
    }

    @Environment(value=EnvType.CLIENT)
    protected boolean hookDrawInBackground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInForeground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawBackgroundTexture(graphics, mouseX, mouseY);
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.useScissor) {
            graphics.method_44379(x, y, x + width, y + height);
            if (!this.hookDrawInBackground(graphics, mouseX, mouseY, partialTicks)) {
                this.drawWidgetsBackground(graphics, mouseX, mouseY, partialTicks);
            }
            graphics.method_44380();
        } else if (!this.hookDrawInBackground(graphics, mouseX, mouseY, partialTicks)) {
            this.drawWidgetsBackground(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.xBarHeight > 0) {
            if (this.xBarB != null) {
                this.xBarB.draw(graphics, mouseX, mouseY, x, y + height - this.xBarHeight, width, this.xBarHeight);
            }
            if (this.xBarF != null) {
                int barWidth = (int)((float)width * 1.0f / (float)this.getMaxWidth() * (float)width);
                this.xBarF.draw(graphics, mouseX, mouseY, (float)x + (float)(this.scrollXOffset * width) * 1.0f / (float)this.getMaxWidth(), y + height - this.xBarHeight, barWidth, this.xBarHeight);
            }
        }
        if (this.yBarWidth > 0) {
            if (this.yBarB != null) {
                this.yBarB.draw(graphics, mouseX, mouseY, x + width - this.yBarWidth, y, this.yBarWidth, height);
            }
            if (this.yBarF != null) {
                int barHeight = (int)((float)height * 1.0f / (float)this.getMaxHeight() * (float)height);
                this.yBarF.draw(graphics, mouseX, mouseY, x + width - this.yBarWidth, (float)y + (float)(this.scrollYOffset * height) * 1.0f / (float)this.getMaxHeight(), this.yBarWidth, barHeight);
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.lastDeltaX = 0.0;
        this.lastDeltaY = 0.0;
        if (this.xBarHeight > 0 && this.isOnXScrollPane(mouseX, mouseY)) {
            this.draggedOnXScrollBar = true;
            this.setFocus(true);
            return true;
        }
        if (this.yBarWidth > 0 && this.isOnYScrollPane(mouseX, mouseY)) {
            this.draggedOnYScrollBar = true;
            this.setFocus(true);
            return true;
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (this.checkClickedDragged(mouseX, mouseY, button)) {
                this.setFocus(true);
                return true;
            }
            this.setFocus(true);
            if (this.draggable) {
                this.draggedPanel = true;
                return true;
            }
            return false;
        }
        this.setFocus(false);
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    protected boolean checkClickedDragged(double mouseX, double mouseY, int button) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = (Widget)this.widgets.get(i);
            if (!widget.isVisible()) continue;
            boolean result = widget.mouseClicked(mouseX, mouseY, button);
            if (this.waitToRemoved == null || !this.waitToRemoved.contains(widget)) {
                if (widget instanceof IDraggable && ((IDraggable)((Object)widget)).allowDrag(mouseX, mouseY, button)) {
                    this.draggedWidget = widget;
                    ((IDraggable)((Object)widget)).startDrag(mouseX, mouseY);
                    if (this.selectedWidget != null && this.selectedWidget != widget) {
                        ((ISelected)((Object)this.selectedWidget)).onUnSelected();
                    }
                    this.selectedWidget = widget;
                    ((ISelected)((Object)this.selectedWidget)).onSelected();
                    return true;
                }
                if (widget instanceof ISelected && ((ISelected)((Object)widget)).allowSelected(mouseX, mouseY, button)) {
                    if (this.selectedWidget != null && this.selectedWidget != widget) {
                        ((ISelected)((Object)this.selectedWidget)).onUnSelected();
                    }
                    this.selectedWidget = widget;
                    ((ISelected)((Object)this.selectedWidget)).onSelected();
                    return true;
                }
            }
            if (!result) continue;
            return true;
        }
        this.draggedWidget = null;
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (super.mouseWheelMove(mouseX, mouseY, wheelDelta)) {
                this.setFocus(true);
                return true;
            }
            if (this.scrollable) {
                this.setFocus(true);
                if (this.isFocus()) {
                    int moveDelta = (int)(-class_3532.method_15350((double)wheelDelta, (double)-1.0, (double)1.0) * 13.0);
                    if (this.getMaxHeight() - this.getSize().height > 0 || this.scrollYOffset > this.getMaxHeight() - this.getSize().height) {
                        this.setScrollYOffset(class_3532.method_15340((int)(this.scrollYOffset + moveDelta), (int)0, (int)(this.getMaxHeight() - this.getSize().height)));
                    }
                }
            }
            return true;
        }
        this.setFocus(false);
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        double dx = deltaX + this.lastDeltaX;
        double dy = deltaY + this.lastDeltaY;
        deltaX = (int)dx;
        deltaY = (int)dy;
        this.lastDeltaX = dx - deltaX;
        this.lastDeltaY = dy - deltaY;
        if (this.draggedOnXScrollBar && (this.getMaxWidth() - this.getSize().width > 0 || this.scrollYOffset > this.getMaxWidth() - this.getSize().width)) {
            this.setScrollXOffset((int)class_3532.method_15350((double)((double)this.scrollXOffset + deltaX * (double)this.getMaxWidth() / (double)this.getSize().width), (double)0.0, (double)(this.getMaxWidth() - this.getSize().width)));
            return true;
        }
        if (this.draggedOnYScrollBar && (this.getMaxHeight() - this.getSize().height > 0 || this.scrollYOffset > this.getMaxHeight() - this.getSize().height)) {
            this.setScrollYOffset((int)class_3532.method_15350((double)((double)this.scrollYOffset + deltaY * (double)this.getMaxHeight() / (double)this.getSize().height), (double)0.0, (double)(this.getMaxHeight() - this.getSize().height)));
            return true;
        }
        if (this.draggedWidget != null) {
            if (((IDraggable)((Object)this.draggedWidget)).dragging(mouseX, mouseY, deltaX, deltaY)) {
                if (this.draggedWidget.getPosition().x < this.getPosition().x) {
                    deltaX = this.getPosition().x - this.draggedWidget.getPosition().x;
                } else if (this.draggedWidget.getPosition().x + this.draggedWidget.getSize().width + this.scrollXOffset > this.getPosition().x + this.getSize().width) {
                    deltaX = this.getPosition().x + this.getSize().width - (this.draggedWidget.getPosition().x + this.draggedWidget.getSize().width + this.scrollXOffset);
                }
                if (this.draggedWidget.getPosition().y < this.getPosition().y) {
                    deltaY = this.getPosition().y - this.draggedWidget.getPosition().y;
                } else if (this.draggedWidget.getPosition().y + this.draggedWidget.getSize().height + this.scrollYOffset > this.getPosition().y + this.getSize().height) {
                    deltaY = this.getPosition().y + this.getSize().height - (this.draggedWidget.getPosition().y + this.draggedWidget.getSize().height + this.scrollYOffset);
                }
                this.isComputingMax = true;
                this.draggedWidget.addSelfPosition((int)deltaX, (int)deltaY);
                this.isComputingMax = false;
            }
            this.computeMax();
            return true;
        }
        if (this.draggedPanel) {
            this.setScrollXOffset((int)class_3532.method_15350((double)((double)this.scrollXOffset - deltaX), (double)0.0, (double)Math.max(this.getMaxWidth() - this.yBarWidth - this.getSize().width, 0)));
            this.setScrollYOffset((int)class_3532.method_15350((double)((double)this.scrollYOffset - deltaY), (double)0.0, (double)Math.max(this.getMaxHeight() - this.xBarHeight - this.getSize().height, 0)));
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.draggedOnXScrollBar) {
            this.draggedOnXScrollBar = false;
        } else if (this.draggedOnYScrollBar) {
            this.draggedOnYScrollBar = false;
        } else if (this.draggedWidget != null) {
            ((IDraggable)((Object)this.draggedWidget)).endDrag(mouseX, mouseY);
            this.draggedWidget = null;
        } else if (this.draggedPanel) {
            this.draggedPanel = false;
        } else {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<class_768> getGuiExtraAreas(class_768 guiRect, List<class_768> list) {
        class_768 rect2i = this.toRectangleBox();
        if (rect2i.method_3321() < guiRect.method_3321() || rect2i.method_3321() + rect2i.method_3319() > guiRect.method_3321() + guiRect.method_3319() || rect2i.method_3322() < guiRect.method_3322() || rect2i.method_3322() + rect2i.method_3320() > guiRect.method_3322() + guiRect.method_3320()) {
            list.add(this.toRectangleBox());
        }
        return list;
    }

    public void setSelected(Widget widget) {
        if (widget instanceof ISelected) {
            if (this.selectedWidget != null && this.selectedWidget != widget) {
                ((ISelected)((Object)this.selectedWidget)).onUnSelected();
            }
            this.selectedWidget = widget;
            ((ISelected)((Object)this.selectedWidget)).onSelected();
        }
    }

    @Override
    public class_2487 serializeInnerNBT() {
        class_2487 tag = super.serializeInnerNBT();
        tag.method_10569("scrollXOffset", this.scrollXOffset);
        tag.method_10569("scrollYOffset", this.scrollYOffset);
        tag.method_10569("maxHeight", this.maxHeight);
        tag.method_10569("maxWidth", this.maxWidth);
        return tag;
    }

    @Override
    public void deserializeInnerNBT(class_2487 nbt) {
        super.deserializeInnerNBT(nbt);
        this.scrollXOffset = nbt.method_10550("scrollXOffset");
        this.scrollYOffset = nbt.method_10550("scrollYOffset");
        this.maxHeight = nbt.method_10550("maxHeight");
        this.maxWidth = nbt.method_10550("maxWidth");
        this.isComputingMax = true;
        for (Widget widget : this.widgets) {
            widget.addSelfPosition(-this.scrollXOffset, -this.scrollYOffset);
        }
        this.isComputingMax = false;
    }

    public static interface IDraggable
    extends ISelected {
        default public boolean allowDrag(double mouseX, double mouseY, int button) {
            return this.allowSelected(mouseX, mouseY, button);
        }

        default public void startDrag(double mouseX, double mouseY) {
        }

        default public boolean dragging(double mouseX, double mouseY, double deltaX, double deltaY) {
            return true;
        }

        default public void endDrag(double mouseX, double mouseY) {
        }
    }

    public static interface ISelected {
        public boolean allowSelected(double var1, double var3, int var5);

        default public void onSelected() {
        }

        default public void onUnSelected() {
        }
    }
}

