/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;

public class CycleButtonWidget
extends Widget {
    protected Int2ObjectFunction<IGuiTexture> texture;
    protected IntConsumer onChanged;
    protected IntSupplier indexSupplier;
    protected int range;
    protected int index;

    public CycleButtonWidget(int xPosition, int yPosition, int width, int height, int range, Int2ObjectFunction<IGuiTexture> texture, IntConsumer onChanged) {
        super(xPosition, yPosition, width, height);
        this.texture = texture;
        this.onChanged = onChanged;
        this.range = range;
        this.setBackground((IGuiTexture)texture.get(0));
    }

    public void setIndex(int index) {
        this.index = index;
        this.setBackground((IGuiTexture)this.texture.get(index));
    }

    @Override
    public void writeInitialData(class_2540 buffer) {
        super.writeInitialData(buffer);
        if (this.indexSupplier != null) {
            this.index = this.indexSupplier.getAsInt();
        }
        buffer.method_10804(this.index);
    }

    @Override
    public void readInitialData(class_2540 buffer) {
        super.readInitialData(buffer);
        this.index = buffer.method_10816();
        this.setBackground((IGuiTexture)this.texture.get(this.index));
    }

    @Override
    public void detectAndSendChanges() {
        int newIndex;
        super.detectAndSendChanges();
        if (!this.isClientSideWidget && this.indexSupplier != null && (newIndex = this.indexSupplier.getAsInt()) != this.index) {
            this.index = newIndex;
            this.writeUpdateInfo(1, buf -> buf.method_10804(this.index));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void updateScreen() {
        int newIndex;
        super.updateScreen();
        if (this.isClientSideWidget && this.indexSupplier != null && (newIndex = this.indexSupplier.getAsInt()) != this.index) {
            this.index = newIndex;
            this.setBackground((IGuiTexture)this.texture.get(this.index));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            ++this.index;
            if (this.index >= this.range) {
                this.index = 0;
            }
            this.setBackground((IGuiTexture)this.texture.get(this.index));
            if (this.onChanged != null) {
                this.onChanged.accept(this.index);
            }
            this.writeClientAction(1, buf -> buf.method_10804(this.index));
            CycleButtonWidget.playButtonClickSound();
            return true;
        }
        return false;
    }

    @Override
    public void handleClientAction(int id, class_2540 buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            this.index = buffer.method_10816();
            if (this.onChanged != null) {
                this.onChanged.accept(this.index);
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void readUpdateInfo(int id, class_2540 buffer) {
        if (id == 1) {
            this.index = buffer.method_10816();
            this.setBackground((IGuiTexture)this.texture.get(this.index));
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    public CycleButtonWidget setTexture(Int2ObjectFunction<IGuiTexture> texture) {
        this.texture = texture;
        return this;
    }

    public CycleButtonWidget setOnChanged(IntConsumer onChanged) {
        this.onChanged = onChanged;
        return this;
    }

    public CycleButtonWidget setIndexSupplier(IntSupplier indexSupplier) {
        this.indexSupplier = indexSupplier;
        return this;
    }
}

