/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_341;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentPanelWidget
extends Widget {
    protected int maxWidthLimit;
    @Nullable
    protected Consumer<List<class_2561>> textSupplier;
    protected BiConsumer<String, ClickData> clickHandler;
    protected List<class_2561> lastText = new ArrayList<class_2561>();
    protected List<class_5481> cacheLines = Collections.emptyList();
    protected boolean isCenter = false;
    protected int space = 2;

    public ComponentPanelWidget(int x, int y, @Nonnull Consumer<List<class_2561>> textSupplier) {
        super(x, y, 0, 0);
        this.textSupplier = textSupplier;
        this.textSupplier.accept(this.lastText);
    }

    public ComponentPanelWidget(int x, int y, List<class_2561> text) {
        super(x, y, 0, 0);
        this.lastText.addAll(text);
    }

    public static class_2561 withButton(class_2561 textComponent, String componentData) {
        class_2583 style = textComponent.method_10866();
        style = style.method_10958(new class_2558(class_2558.class_2559.field_11749, "@!" + componentData));
        style = style.method_10977(class_124.field_1054);
        return textComponent.method_27661().method_27696(style);
    }

    public static class_2561 withButton(class_2561 textComponent, String componentData, int color) {
        class_2583 style = textComponent.method_10866();
        style = style.method_10958(new class_2558(class_2558.class_2559.field_11749, "@!" + componentData));
        style = style.method_36139(color);
        return textComponent.method_27661().method_27696(style);
    }

    public static class_2561 withHoverTextTranslate(class_2561 textComponent, class_2561 hover) {
        class_2583 style = textComponent.method_10866();
        style = style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hover));
        return textComponent.method_27661().method_27696(style);
    }

    public ComponentPanelWidget setMaxWidthLimit(int maxWidthLimit) {
        this.maxWidthLimit = maxWidthLimit;
        if (this.isRemote()) {
            this.formatDisplayText();
            this.updateComponentTextSize();
        }
        return this;
    }

    public ComponentPanelWidget setCenter(boolean center) {
        this.isCenter = center;
        if (this.isRemote()) {
            this.formatDisplayText();
            this.updateComponentTextSize();
        }
        return this;
    }

    public ComponentPanelWidget setSpace(int space) {
        this.space = space;
        if (this.isRemote()) {
            this.formatDisplayText();
            this.updateComponentTextSize();
        }
        return this;
    }

    @Override
    public void writeInitialData(class_2540 buffer) {
        super.writeInitialData(buffer);
        buffer.method_10804(this.lastText.size());
        for (class_2561 textComponent : this.lastText) {
            buffer.method_10805(textComponent);
        }
    }

    @Override
    public void readInitialData(class_2540 buffer) {
        super.readInitialData(buffer);
        this.readUpdateInfo(1, buffer);
    }

    @Override
    public void initWidget() {
        super.initWidget();
        if (this.textSupplier != null) {
            this.lastText.clear();
            this.textSupplier.accept(this.lastText);
        }
        if (this.isClientSideWidget && this.isRemote()) {
            this.formatDisplayText();
            this.updateComponentTextSize();
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.isClientSideWidget && this.textSupplier != null) {
            ArrayList<class_2561> textBuffer = new ArrayList<class_2561>();
            this.textSupplier.accept(textBuffer);
            if (!this.lastText.equals(textBuffer)) {
                this.lastText = textBuffer;
                this.formatDisplayText();
                this.updateComponentTextSize();
            }
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.textSupplier != null) {
            ArrayList<class_2561> textBuffer = new ArrayList<class_2561>();
            this.textSupplier.accept(textBuffer);
            if (!this.lastText.equals(textBuffer)) {
                this.lastText = textBuffer;
                this.writeUpdateInfo(1, buffer -> {
                    buffer.method_10804(this.lastText.size());
                    for (class_2561 textComponent : this.lastText) {
                        buffer.method_10805(textComponent);
                    }
                });
            }
        }
    }

    @Override
    public void readUpdateInfo(int id, class_2540 buffer) {
        if (id == 1) {
            this.lastText.clear();
            int count = buffer.method_10816();
            for (int i = 0; i < count; ++i) {
                this.lastText.add(buffer.method_10808());
            }
            this.formatDisplayText();
            this.updateComponentTextSize();
        }
    }

    @Override
    public void handleClientAction(int id, class_2540 buffer) {
        if (id == 1) {
            ClickData clickData = ClickData.readFromBuf(buffer);
            String componentData = buffer.method_19772();
            if (this.clickHandler != null) {
                this.clickHandler.accept(componentData, clickData);
            }
        } else {
            super.handleClientAction(id, buffer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void updateComponentTextSize() {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int n = this.cacheLines.size();
        Objects.requireNonNull(fontRenderer);
        int totalHeight = n * (9 + this.space);
        if (totalHeight > 0) {
            totalHeight -= this.space;
        }
        if (this.isCenter) {
            this.setSize(new Size(this.maxWidthLimit, totalHeight));
        } else {
            int maxStringWidth = 0;
            for (class_5481 line : this.cacheLines) {
                maxStringWidth = Math.max(fontRenderer.method_30880(line), maxStringWidth);
            }
            this.setSize(new Size(this.maxWidthLimit == 0 ? maxStringWidth : Math.min(this.maxWidthLimit, maxStringWidth), totalHeight));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void formatDisplayText() {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int maxTextWidthResult = this.maxWidthLimit == 0 ? Integer.MAX_VALUE : this.maxWidthLimit;
        this.cacheLines = this.lastText.stream().flatMap(component -> class_341.method_1850((class_5348)component, (int)maxTextWidthResult, (class_327)fontRenderer).stream()).toList();
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    protected class_2583 getStyleUnderMouse(double mouseX, double mouseY) {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        Position position = this.getPosition();
        Size size = this.getSize();
        double d = mouseY - (double)position.y;
        Objects.requireNonNull(fontRenderer);
        double selectedLine = d / (double)(9 + this.space);
        if (this.isCenter) {
            class_5481 cacheLine;
            int lineWidth;
            float offsetX;
            if (selectedLine >= 0.0 && selectedLine < (double)this.cacheLines.size() && mouseX >= (double)(offsetX = (float)position.x + (float)(size.width - (lineWidth = fontRenderer.method_30880(cacheLine = this.cacheLines.get((int)selectedLine)))) / 2.0f)) {
                int mouseOffset = (int)(mouseX - (double)position.x);
                return fontRenderer.method_27527().method_30876(cacheLine, mouseOffset);
            }
        } else if (mouseX >= (double)position.x && selectedLine >= 0.0 && selectedLine < (double)this.cacheLines.size()) {
            class_5481 cacheLine = this.cacheLines.get((int)selectedLine);
            int mouseOffset = (int)(mouseX - (double)position.x);
            return fontRenderer.method_27527().method_30876(cacheLine, mouseOffset);
        }
        return null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        class_2583 style = this.getStyleUnderMouse(mouseX, mouseY);
        if (style != null && style.method_10970() != null) {
            class_2558 clickEvent = style.method_10970();
            String componentText = clickEvent.method_10844();
            if (clickEvent.method_10845() == class_2558.class_2559.field_11749) {
                if (componentText.startsWith("@!")) {
                    String rawText = componentText.substring(2);
                    ClickData clickData = new ClickData();
                    if (this.clickHandler != null) {
                        this.clickHandler.accept(rawText, clickData);
                    }
                    this.writeClientAction(1, buf -> {
                        clickData.writeToBuf((class_2540)buf);
                        buf.method_10814(rawText);
                    });
                } else if (componentText.startsWith("@#")) {
                    String rawText = componentText.substring(2);
                    class_156.method_668().method_670(rawText);
                }
                ComponentPanelWidget.playButtonClickSound();
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInForeground(@Nonnull @NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_2568 hoverEvent;
        class_2561 hoverTips;
        class_2583 style = this.getStyleUnderMouse(mouseX, mouseY);
        if (style != null && style.method_10969() != null && (hoverTips = (class_2561)(hoverEvent = style.method_10969()).method_10891(class_2568.class_5247.field_24342)) != null) {
            this.gui.getModularUIGui().setHoverTooltip(List.of(hoverTips), class_1799.field_8037, null, null);
            return;
        }
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        class_327 fontRenderer = class_310.method_1551().field_1772;
        Position position = this.getPosition();
        Size size = this.getSize();
        for (int i = 0; i < this.cacheLines.size(); ++i) {
            class_5481 cacheLine = this.cacheLines.get(i);
            if (this.isCenter) {
                int lineWidth = fontRenderer.method_30880(cacheLine);
                int n = position.x + (size.width - lineWidth) / 2;
                int n2 = position.y;
                Objects.requireNonNull(fontRenderer);
                graphics.method_35720(fontRenderer, cacheLine, n, n2 + i * (9 + this.space), -1);
                continue;
            }
            int n = position.x;
            int n3 = position.y;
            Objects.requireNonNull(fontRenderer);
            graphics.method_35720(fontRenderer, this.cacheLines.get(i), n, n3 + i * (9 + 2), -1);
        }
    }

    public ComponentPanelWidget textSupplier(@Nullable Consumer<List<class_2561>> textSupplier) {
        this.textSupplier = textSupplier;
        return this;
    }

    public ComponentPanelWidget clickHandler(BiConsumer<String, ClickData> clickHandler) {
        this.clickHandler = clickHandler;
        return this;
    }

    public List<class_5481> cacheLines() {
        return this.cacheLines;
    }
}

