/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.util;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeNode;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.class_3545;

public class TreeBuilder<K, V> {
    protected final Stack<TreeNode<K, V>> stack = new Stack();

    public TreeBuilder(K key) {
        this.stack.push(new TreeNode(0, key));
    }

    public static <K, V> TreeBuilder<K, V> start(K key) {
        return new TreeBuilder<K, V>(key);
    }

    public TreeBuilder<K, V> branch(K key, Consumer<TreeBuilder<K, V>> builderConsumer) {
        List<TreeNode<K, V>> children = this.stack.peek().getChildren();
        if (children != null && !children.isEmpty()) {
            for (TreeNode<K, V> child : children) {
                if (child.isLeaf() || !child.key.equals(key)) continue;
                this.stack.push(child);
                builderConsumer.accept(this);
                this.endBranch();
                return this;
            }
        }
        this.stack.push(this.stack.peek().getOrCreateChild(key));
        builderConsumer.accept(this);
        this.endBranch();
        return this;
    }

    public TreeBuilder<K, V> startBranch(K key) {
        this.stack.push(this.stack.peek().getOrCreateChild(key));
        return this;
    }

    public TreeBuilder<K, V> endBranch() {
        this.stack.pop();
        return this;
    }

    public TreeBuilder<K, V> leaf(K key, V content) {
        this.stack.peek().addContent(key, content);
        return this;
    }

    public TreeBuilder<K, V> remove(K key) {
        this.stack.peek().removeChild(key);
        return this;
    }

    public TreeNode<K, V> build() {
        while (this.stack.size() > 1) {
            this.stack.pop();
        }
        return this.stack.peek();
    }

    public static class Menu
    extends TreeBuilder<class_3545<IGuiTexture, String>, Runnable> {
        public static class_3545<IGuiTexture, String> CROSS_LINE = new class_3545((Object)IGuiTexture.EMPTY, (Object)"");

        private Menu(class_3545<IGuiTexture, String> key) {
            super(key);
        }

        public static Menu start() {
            return new Menu((class_3545<IGuiTexture, String>)new class_3545((Object)IGuiTexture.EMPTY, (Object)""));
        }

        public Menu crossLine() {
            ((TreeNode)this.stack.peek()).createChild(CROSS_LINE);
            return this;
        }

        public Menu branch(IGuiTexture icon, String name, Consumer<Menu> menuConsumer) {
            this.branch(new class_3545((Object)icon, (Object)name), (TreeBuilder<K, V> builder) -> menuConsumer.accept(this));
            return this;
        }

        public Menu branch(String name, Consumer<Menu> menuConsumer) {
            List children = ((TreeNode)this.stack.peek()).getChildren();
            if (children != null && !children.isEmpty()) {
                for (TreeNode child : children) {
                    if (child.isLeaf() || !((String)((class_3545)child.getKey()).method_15441()).equals(name)) continue;
                    this.stack.push(child);
                    menuConsumer.accept(this);
                    this.endBranch();
                    return this;
                }
            }
            return this.branch(IGuiTexture.EMPTY, name, menuConsumer);
        }

        public Menu endBranch() {
            super.endBranch();
            return this;
        }

        public Menu leaf(IGuiTexture icon, String name, Runnable runnable) {
            super.leaf(new class_3545((Object)icon, (Object)name), runnable);
            return this;
        }

        public Menu leaf(String name, Runnable runnable) {
            super.leaf(new class_3545((Object)IGuiTexture.EMPTY, (Object)name), runnable);
            return this;
        }

        public Menu remove(String name) {
            List children = ((TreeNode)this.stack.peek()).getChildren();
            if (children != null && !children.isEmpty()) {
                for (TreeNode child : children) {
                    if (!((String)((class_3545)child.getKey()).method_15441()).equals(name)) continue;
                    ((TreeNode)this.stack.peek()).removeChild((class_3545)child.getKey());
                    return this;
                }
            }
            return this;
        }

        public static IGuiTexture getIcon(class_3545<IGuiTexture, String> key) {
            return (IGuiTexture)key.method_15442();
        }

        public static String getName(class_3545<IGuiTexture, String> key) {
            return (String)key.method_15441();
        }

        public static void handle(TreeNode<class_3545<IGuiTexture, String>, Runnable> node) {
            if (node.isLeaf() && node.getContent() != null) {
                node.getContent().run();
            }
        }

        public static boolean isCrossLine(class_3545<IGuiTexture, String> key) {
            return key == CROSS_LINE;
        }
    }
}

