/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.util;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.client.shader.Shaders;
import com.lowdragmc.lowdraglib.client.shader.management.ShaderProgram;
import com.lowdragmc.lowdraglib.client.shader.uniform.UniformCache;
import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.util.fabric.DrawerHelperImpl;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.LdUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Rect;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class DrawerHelper {
    public static ShaderProgram ROUND;
    public static ShaderProgram PANEL_BG;
    public static ShaderProgram ROUND_BOX;
    public static ShaderProgram PROGRESS_ROUND_BOX;
    public static ShaderProgram FRAME_ROUND_BOX;
    public static ShaderProgram ROUND_LINE;

    public static void init() {
        ROUND = LdUtils.make(new ShaderProgram(), program -> program.attach(Shaders.ROUND_F).attach(Shaders.SCREEN_V));
        PANEL_BG = LdUtils.make(new ShaderProgram(), program -> program.attach(Shaders.PANEL_BG_F).attach(Shaders.SCREEN_V));
        ROUND_BOX = LdUtils.make(new ShaderProgram(), program -> program.attach(Shaders.ROUND_BOX_F).attach(Shaders.SCREEN_V));
        PROGRESS_ROUND_BOX = LdUtils.make(new ShaderProgram(), program -> program.attach(Shaders.PROGRESS_ROUND_BOX_F).attach(Shaders.SCREEN_V));
        FRAME_ROUND_BOX = LdUtils.make(new ShaderProgram(), program -> program.attach(Shaders.FRAME_ROUND_BOX_F).attach(Shaders.SCREEN_V));
        ROUND_LINE = LdUtils.make(new ShaderProgram(), program -> program.attach(Shaders.ROUND_LINE_F).attach(Shaders.SCREEN_V));
    }

    public static void drawFluidTexture(@Nonnull class_332 graphics, float xCoord, float yCoord, class_1058 textureSprite, int maskTop, int maskRight, float zLevel, int fluidColor) {
        float uMin = textureSprite.method_4594();
        float uMax = textureSprite.method_4577();
        float vMin = textureSprite.method_4593();
        float vMax = textureSprite.method_4575();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        class_287 buffer = class_289.method_1348().method_1349();
        RenderSystem.setShader(class_757::method_34543);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        Matrix4f mat = graphics.method_51448().method_23760().method_23761();
        buffer.method_22918(mat, xCoord, yCoord + 16.0f, zLevel).method_22913(uMin, vMax).method_39415(fluidColor).method_1344();
        buffer.method_22918(mat, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).method_22913(uMax, vMax).method_39415(fluidColor).method_1344();
        buffer.method_22918(mat, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).method_22913(uMax, vMin).method_39415(fluidColor).method_1344();
        buffer.method_22918(mat, xCoord, yCoord + (float)maskTop, zLevel).method_22913(uMin, vMin).method_39415(fluidColor).method_1344();
        class_286.method_43433((class_287.class_7433)buffer.method_1326());
    }

    public static void drawFluidForGui(@Nonnull class_332 graphics, FluidStack contents, long tankCapacity, int startX, int startY, int widthT, int heightT) {
        class_2960 LOCATION_BLOCKS_TEXTURE = class_1723.field_21668;
        class_1058 fluidStillSprite = FluidHelper.getStillTexture(contents);
        if (fluidStillSprite == null) {
            fluidStillSprite = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(class_1047.method_4539());
            if (Platform.isDevEnv()) {
                LDLib.LOGGER.error("Missing fluid texture for fluid: " + contents.getDisplayName().getString());
            }
        }
        int fluidColor = FluidHelper.getColor(contents) | 0xFF000000;
        int scaledAmount = (int)(contents.getAmount() * (long)heightT / tankCapacity);
        if (contents.getAmount() > 0L && scaledAmount < 1) {
            scaledAmount = 1;
        }
        if (scaledAmount > heightT || contents.getAmount() == tankCapacity) {
            scaledAmount = heightT;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (class_2960)LOCATION_BLOCKS_TEXTURE);
        int xTileCount = widthT / 16;
        int xRemainder = widthT - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = startY + heightT;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = startX + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                DrawerHelper.drawFluidTexture(graphics, x, y, fluidStillSprite, maskTop, maskRight, 0.0f, fluidColor);
            }
        }
        RenderSystem.enableBlend();
    }

    public static void drawBorder(@Nonnull class_332 graphics, int x, int y, int width, int height, int color, int border) {
        graphics.method_51741(() -> {
            DrawerHelper.drawSolidRect(graphics, x - border, y - border, width + 2 * border, border, color);
            DrawerHelper.drawSolidRect(graphics, x - border, y + height, width + 2 * border, border, color);
            DrawerHelper.drawSolidRect(graphics, x - border, y, border, height, color);
            DrawerHelper.drawSolidRect(graphics, x + width, y, border, height, color);
        });
    }

    public static void drawStringSized(@Nonnull class_332 graphics, String text, float x, float y, int color, boolean dropShadow, float scale, boolean center) {
        graphics.method_51448().method_22903();
        class_327 fontRenderer = class_310.method_1551().field_1772;
        double scaledTextWidth = center ? (double)((float)fontRenderer.method_1727(text) * scale) : 0.0;
        graphics.method_51448().method_22904((double)x - scaledTextWidth / 2.0, (double)y, 0.0);
        graphics.method_51448().method_22905(scale, scale, scale);
        graphics.method_51433(fontRenderer, text, 0, 0, color, dropShadow);
        graphics.method_51448().method_22909();
    }

    public static void drawStringFixedCorner(@Nonnull class_332 graphics, String text, float x, float y, int color, boolean dropShadow, float scale) {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        float scaledWidth = (float)fontRenderer.method_1727(text) * scale;
        Objects.requireNonNull(fontRenderer);
        float scaledHeight = 9.0f * scale;
        DrawerHelper.drawStringSized(graphics, text, x - scaledWidth, y - scaledHeight, color, dropShadow, scale, false);
    }

    public static void drawText(@Nonnull class_332 graphics, String text, float x, float y, float scale, int color) {
        DrawerHelper.drawText(graphics, text, x, y, scale, color, false);
    }

    public static void drawText(@Nonnull class_332 graphics, String text, float x, float y, float scale, int color, boolean shadow) {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        RenderSystem.disableBlend();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(scale, scale, 0.0f);
        float sf = 1.0f / scale;
        graphics.method_51433(fontRenderer, text, (int)(x * sf), (int)(y * sf), color, shadow);
        graphics.method_51448().method_22909();
        RenderSystem.enableBlend();
    }

    public static void drawItemStack(@Nonnull class_332 graphics, class_1799 itemStack, int x, int y, int color, @Nullable String altTxt) {
        float a = ColorUtils.alpha(color);
        float r = ColorUtils.red(color);
        float g = ColorUtils.green(color);
        float b = ColorUtils.blue(color);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        class_310 mc = class_310.method_1551();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 232.0f);
        graphics.method_51427(itemStack, x, y);
        graphics.method_51432(mc.field_1772, itemStack, x, y, altTxt);
        graphics.method_51448().method_22909();
        RenderSystem.clear((int)256, (boolean)class_310.field_1703);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
    }

    public static List<class_2561> getItemToolTip(class_1799 itemStack) {
        class_310 mc = class_310.method_1551();
        return class_437.method_25408((class_310)mc, (class_1799)itemStack);
    }

    public static void drawSolidRect(@Nonnull class_332 graphics, int x, int y, int width, int height, int color) {
        graphics.method_25294(x, y, x + width, y + height, color);
        RenderSystem.enableBlend();
    }

    public static void drawSolidRect(@Nonnull class_332 graphics, Rect rect, int color) {
        DrawerHelper.drawSolidRect(graphics, rect.left, rect.up, rect.right, rect.down, color);
    }

    public static void drawRectShadow(@Nonnull class_332 graphics, int x, int y, int width, int height, int distance) {
        DrawerHelper.drawGradientRect(graphics, x + distance, y + height, width - distance, distance, 0x4F000000, 0, false);
        DrawerHelper.drawGradientRect(graphics, x + width, y + distance, distance, height - distance, 0x4F000000, 0, true);
        float startAlpha = 0.30980393f;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
        Matrix4f mat = graphics.method_51448().method_23760().method_23761();
        buffer.method_22918(mat, (float)(x += width), (float)(y += height), 0.0f).method_22915(0.0f, 0.0f, 0.0f, startAlpha).method_1344();
        buffer.method_22918(mat, (float)x, (float)(y + distance), 0.0f).method_1336(0, 0, 0, 0).method_1344();
        buffer.method_22918(mat, (float)(x + distance), (float)(y + distance), 0.0f).method_1336(0, 0, 0, 0).method_1344();
        buffer.method_22918(mat, (float)x, (float)y, 0.0f).method_22915(0.0f, 0.0f, 0.0f, startAlpha).method_1344();
        buffer.method_22918(mat, (float)(x + distance), (float)(y + distance), 0.0f).method_1336(0, 0, 0, 0).method_1344();
        buffer.method_22918(mat, (float)(x + distance), (float)y, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        tesselator.method_1350();
    }

    public static void drawGradientRect(@Nonnull class_332 graphics, int x, int y, int width, int height, int startColor, int endColor) {
        DrawerHelper.drawGradientRect(graphics, x, y, width, height, startColor, endColor, false);
    }

    public static void drawGradientRect(@Nonnull class_332 graphics, float x, float y, float width, float height, int startColor, int endColor, boolean horizontal) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        Matrix4f mat = graphics.method_51448().method_23760().method_23761();
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        if (horizontal) {
            buffer.method_22918(mat, x + width, y, 0.0f).method_22915(endRed, endGreen, endBlue, endAlpha).method_1344();
            buffer.method_22918(mat, x, y, 0.0f).method_22915(startRed, startGreen, startBlue, startAlpha).method_1344();
            buffer.method_22918(mat, x, y + height, 0.0f).method_22915(startRed, startGreen, startBlue, startAlpha).method_1344();
            buffer.method_22918(mat, x + width, y + height, 0.0f).method_22915(endRed, endGreen, endBlue, endAlpha).method_1344();
            tesselator.method_1350();
        } else {
            buffer.method_22918(mat, x + width, y, 0.0f).method_22915(startRed, startGreen, startBlue, startAlpha).method_1344();
            buffer.method_22918(mat, x, y, 0.0f).method_22915(startRed, startGreen, startBlue, startAlpha).method_1344();
            buffer.method_22918(mat, x, y + height, 0.0f).method_22915(endRed, endGreen, endBlue, endAlpha).method_1344();
            buffer.method_22918(mat, x + width, y + height, 0.0f).method_22915(endRed, endGreen, endBlue, endAlpha).method_1344();
            tesselator.method_1350();
        }
    }

    public static void drawLines(@Nonnull class_332 graphics, List<class_241> points, int startColor, int endColor, float width) {
        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_1349();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        bufferbuilder.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        RenderBufferUtils.drawColorLines(graphics.method_51448(), (class_4588)bufferbuilder, points, startColor, endColor, width);
        tesselator.method_1350();
        RenderSystem.defaultBlendFunc();
    }

    public static void drawTextureRect(@Nonnull class_332 graphics, float x, float y, float width, float height) {
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        Matrix4f mat = graphics.method_51448().method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(mat, x, y + height, 0.0f).method_22913(0.0f, 0.0f).method_1344();
        buffer.method_22918(mat, x + width, y + height, 0.0f).method_22913(1.0f, 0.0f).method_1344();
        buffer.method_22918(mat, x + width, y, 0.0f).method_22913(1.0f, 1.0f).method_1344();
        buffer.method_22918(mat, x, y, 0.0f).method_22913(0.0f, 1.0f).method_1344();
        tesselator.method_1350();
    }

    public static void updateScreenVshUniform(@Nonnull class_332 graphics, UniformCache uniform) {
        class_1041 window = class_310.method_1551().method_22683();
        uniform.glUniform1F("GuiScale", (float)window.method_4495());
        uniform.glUniform2F("ScreenSize", window.method_4489(), window.method_4506());
        uniform.glUniformMatrix4F("PoseStack", graphics.method_51448().method_23760().method_23761());
        uniform.glUniformMatrix4F("ProjMat", RenderSystem.getProjectionMatrix());
    }

    public static void drawRound(@Nonnull class_332 graphics, int color, float radius, Position centerPos) {
        ROUND.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.fillRGBAColor("Color", color);
            uniform.glUniform1F("StepLength", 1.0f);
            uniform.glUniform1F("Radius", radius);
            uniform.glUniform2F("CenterPos", centerPos.x, centerPos.y);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    public static void drawPanelBg(@Nonnull class_332 graphics) {
        PANEL_BG.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.glUniform1F("Density", 5.0f);
            uniform.glUniform1F("SquareSize", 0.1f);
            float bg = 0.078431375f;
            uniform.glUniform4F("BgColor", bg, bg, bg, 0.95f);
            float square = 0.15686275f;
            uniform.glUniform4F("SquareColor", square, square, square, 0.95f);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    public static void drawRoundBox(@Nonnull class_332 graphics, Rect square, Vector4f radius, int color) {
        ROUND_BOX.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.glUniform4F("SquareVertex", (float)square.left - 1.0f, (float)square.up - 1.0f, (float)square.right - 1.0f, (float)square.down - 1.0f);
            uniform.glUniform4F("RoundRadius", radius.x(), radius.y(), radius.z(), radius.w());
            uniform.fillRGBAColor("Color", color);
            uniform.glUniform1F("Blur", 2.0f);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    public static void drawProgressRoundBox(@Nonnull class_332 graphics, Rect square, Vector4f radius, int color1, int color2, float progress) {
        PROGRESS_ROUND_BOX.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.glUniform4F("SquareVertex", square.left, square.up, square.right, square.down);
            uniform.glUniform4F("RoundRadius", radius.x(), radius.y(), radius.z(), radius.w());
            uniform.fillRGBAColor("Color1", color1);
            uniform.fillRGBAColor("Color2", color2);
            uniform.glUniform1F("Blur", 2.0f);
            uniform.glUniform1F("Progress", progress);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    public static void drawFrameRoundBox(@Nonnull class_332 graphics, Rect square, float thickness, Vector4f radius1, Vector4f radius2, int color) {
        FRAME_ROUND_BOX.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.glUniform4F("SquareVertex", square.left - 1, square.up - 1, square.right - 1, square.down - 1);
            uniform.glUniform4F("RoundRadius1", radius1.x(), radius1.y(), radius1.z(), radius1.w());
            uniform.glUniform4F("RoundRadius2", radius2.x(), radius2.y(), radius2.z(), radius2.w());
            uniform.glUniform1F("Thickness", thickness);
            uniform.fillRGBAColor("Color", color);
            uniform.glUniform1F("Blur", 2.0f);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    public static void drawRoundLine(@Nonnull class_332 graphics, Position begin, Position end, int width, int color1, int color2) {
        ROUND_LINE.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.glUniform1F("Width", width);
            uniform.glUniform2F("Point1", begin.x, begin.y);
            uniform.glUniform2F("Point2", end.x, end.y);
            uniform.fillRGBAColor("Color1", color1);
            uniform.fillRGBAColor("Color2", color2);
            uniform.glUniform1F("Blur", 2.0f);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    private static void uploadScreenPosVertex() {
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        builder.method_22912(-1.0, 1.0, 0.0).method_1344();
        builder.method_22912(-1.0, -1.0, 0.0).method_1344();
        builder.method_22912(1.0, -1.0, 0.0).method_1344();
        builder.method_22912(1.0, 1.0, 0.0).method_1344();
        class_286.method_43437((class_287.class_7433)builder.method_1326());
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void drawTooltip(class_332 graphics, int mouseX, int mouseY, List<class_2561> tooltipTexts, class_1799 tooltipStack, @Nullable class_5632 tooltipComponent, class_327 tooltipFont) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        DrawerHelperImpl.drawTooltip(graphics, (int)var1_1, (int)var2_2, (List<class_2561>)var3_3, (class_1799)var4_4, (class_5632)var5_5, (class_327)var6_6);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_5684 getClientTooltipComponent(class_5632 component) {
        return DrawerHelperImpl.getClientTooltipComponent(component);
    }
}

