/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class WidgetTexture
extends TransformTexture {
    private final Widget widget;
    private int centerX;
    private int centerY;
    private boolean isDragging;
    private boolean fixedCenter;

    public WidgetTexture(Widget widget) {
        this.widget = widget;
        this.centerX = widget.getPosition().x + widget.getSize().width / 2;
        this.centerY = widget.getPosition().y + widget.getSize().height / 2;
    }

    public WidgetTexture(int mouseX, int mouseY, Widget widget) {
        this.widget = widget;
        this.centerX = mouseX;
        this.centerY = mouseY;
        this.isDragging = true;
        this.fixedCenter = true;
    }

    public WidgetTexture setDragging(boolean dragging) {
        this.isDragging = dragging;
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void drawInternal(class_332 graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        int yOffset;
        int xOffset;
        float scale = 1.0f;
        if (!this.fixedCenter) {
            this.centerX = this.widget.getPosition().x + this.widget.getSize().width / 2;
            this.centerY = this.widget.getPosition().y + this.widget.getSize().height / 2;
        }
        if (this.isDragging) {
            xOffset = mouseX - this.centerX;
            yOffset = mouseY - this.centerY;
        } else {
            xOffset = (int)(x + (float)(width / 2) - (float)this.centerX);
            yOffset = (int)(y + (float)(height / 2) - (float)this.centerY);
            float scaleW = (float)width * 1.0f / (float)this.widget.getSize().width;
            float scaleH = (float)height * 1.0f / (float)this.widget.getSize().height;
            scale = Math.min(scaleW, scaleH);
        }
        float particleTick = class_310.method_1551().method_1488();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(x + (float)width / 2.0f, y + (float)height / 2.0f, 0.0f);
        graphics.method_51448().method_22905(scale, scale, 1.0f);
        graphics.method_51448().method_46416(-x + (float)(-width) / 2.0f, -y + (float)(-height) / 2.0f, 0.0f);
        graphics.method_51448().method_46416((float)xOffset, (float)yOffset, 0.0f);
        this.widget.drawInBackground(graphics, this.centerX, this.centerY, particleTick);
        this.widget.drawInForeground(graphics, this.centerX, this.centerY, particleTick);
        graphics.method_51448().method_22909();
    }
}

