/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

public class UIResourceTexture
implements IGuiTexture {
    private static Resource<IGuiTexture> projectResource;
    private static boolean isProject;
    private Resource<IGuiTexture> resource;
    public final String key;

    public static void setCurrentResource(Resource<IGuiTexture> resource, boolean isProject) {
        projectResource = resource;
        UIResourceTexture.isProject = isProject;
    }

    public static void clearCurrentResource() {
        projectResource = null;
        isProject = false;
    }

    public UIResourceTexture(String key) {
        this.key = key;
    }

    public UIResourceTexture(Resource<IGuiTexture> resource, String key) {
        this.resource = resource;
        this.key = key;
    }

    public IGuiTexture getTexture() {
        return this.resource == null ? IGuiTexture.MISSING_TEXTURE : this.resource.getResourceOrDefault(this.key, IGuiTexture.MISSING_TEXTURE);
    }

    @Override
    public IGuiTexture setColor(int color) {
        return this.getTexture().setColor(color);
    }

    @Override
    public IGuiTexture rotate(float degree) {
        return this.getTexture().rotate(degree);
    }

    @Override
    public IGuiTexture scale(float scale) {
        return this.getTexture().scale(scale);
    }

    @Override
    public IGuiTexture transform(int xOffset, int yOffset) {
        return this.getTexture().transform(xOffset, yOffset);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void draw(class_332 graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        this.getTexture().draw(graphics, mouseX, mouseY, x, y, width, height);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void updateTick() {
        this.getTexture().updateTick();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawSubArea(class_332 graphics, float x, float y, float width, float height, float drawnU, float drawnV, float drawnWidth, float drawnHeight) {
        this.getTexture().drawSubArea(graphics, x, y, width, height, drawnU, drawnV, drawnWidth, drawnHeight);
    }

    @Override
    public void createPreview(ConfiguratorGroup father) {
        this.getTexture().createPreview(father);
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        this.getTexture().buildConfigurator(father);
    }

    @Override
    public void setUIResource(Resource<IGuiTexture> texturesResource) {
        this.setResource(texturesResource);
    }

    public static Resource<IGuiTexture> getProjectResource() {
        return projectResource;
    }

    public static boolean isProject() {
        return isProject;
    }

    public void setResource(Resource<IGuiTexture> resource) {
        this.resource = resource;
    }
}

