/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;

@LDLRegister(name="text_texture", group="texture")
public class TextTexture
extends TransformTexture {
    @Configurable
    public String text;
    @Configurable
    @NumberColor
    public int color;
    @Configurable
    @NumberColor
    public int backgroundColor;
    @Configurable(tips={"ldlib.gui.editor.tips.image_text_width"})
    @NumberRange(range={1.0, 2.147483647E9})
    public int width;
    @Configurable
    @NumberRange(range={0.0, 2.147483647E9})
    public float rollSpeed = 1.0f;
    @Configurable
    public boolean dropShadow;
    @Configurable(tips={"ldlib.gui.editor.tips.image_text_type"})
    public TextType type;
    public Supplier<String> supplier;
    @Environment(value=EnvType.CLIENT)
    private List<String> texts;
    private long lastTick;

    public TextTexture() {
        this("A", -1);
        this.setWidth(50);
    }

    public TextTexture(String text, int color) {
        this.color = color;
        this.type = TextType.NORMAL;
        if (LDLib.isClient()) {
            this.text = LocalizationUtils.format(text, new Object[0]);
            this.texts = Collections.singletonList(this.text);
        }
    }

    public TextTexture(String text) {
        this(text, -1);
        this.setDropShadow(true);
    }

    public TextTexture setSupplier(Supplier<String> supplier) {
        this.supplier = supplier;
        return this;
    }

    @Override
    public void updateTick() {
        if (class_310.method_1551().field_1687 != null) {
            long tick = class_310.method_1551().field_1687.method_8510();
            if (tick == this.lastTick) {
                return;
            }
            this.lastTick = tick;
        }
        if (this.supplier != null) {
            this.updateText(this.supplier.get());
        }
    }

    @ConfigSetter(field="text")
    public void updateText(String text) {
        if (LDLib.isClient()) {
            this.text = LocalizationUtils.format(text, new Object[0]);
            this.texts = Collections.singletonList(this.text);
            this.setWidth(this.width);
        }
    }

    public TextTexture setBackgroundColor(int color) {
        this.backgroundColor = color;
        return this;
    }

    @Override
    public TextTexture setColor(int color) {
        this.color = color;
        return this;
    }

    public TextTexture setDropShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        return this;
    }

    public TextTexture setWidth(int width) {
        this.width = width;
        if (LDLib.isClient()) {
            if (this.width > 0) {
                this.texts = class_310.method_1551().field_1772.method_27527().method_27498(this.text, width, class_2583.field_24360).stream().map(class_5348::getString).collect(Collectors.toList());
                if (this.texts.isEmpty()) {
                    this.texts = Collections.singletonList(this.text);
                }
            } else {
                this.texts = Collections.singletonList(this.text);
            }
        }
        return this;
    }

    public TextTexture setType(TextType type) {
        this.type = type;
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void drawInternal(class_332 graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        if (this.backgroundColor != 0) {
            DrawerHelper.drawSolidRect(graphics, (int)x, (int)y, width, height, this.backgroundColor);
        }
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        class_327 fontRenderer = class_310.method_1551().field_1772;
        Objects.requireNonNull(fontRenderer);
        int textH = 9;
        if (this.type == TextType.NORMAL) {
            textH *= this.texts.size();
            for (int i = 0; i < this.texts.size(); ++i) {
                String line = this.texts.get(i);
                int lineWidth = fontRenderer.method_1727(line);
                float _x = x + (float)(width - lineWidth) / 2.0f;
                float f = y + (float)(height - textH) / 2.0f;
                Objects.requireNonNull(fontRenderer);
                float _y = f + (float)(i * 9);
                graphics.method_51433(fontRenderer, line, (int)_x, (int)_y, this.color, this.dropShadow);
            }
        } else if (this.type == TextType.LEFT) {
            textH *= this.texts.size();
            for (int i = 0; i < this.texts.size(); ++i) {
                String line = this.texts.get(i);
                float f = y + (float)(height - textH) / 2.0f;
                Objects.requireNonNull(fontRenderer);
                float _y = f + (float)(i * 9);
                graphics.method_51433(fontRenderer, line, (int)x, (int)_y, this.color, this.dropShadow);
            }
        } else if (this.type == TextType.RIGHT) {
            textH *= this.texts.size();
            for (int i = 0; i < this.texts.size(); ++i) {
                String line = this.texts.get(i);
                int lineWidth = fontRenderer.method_1727(line);
                float f = y + (float)(height - textH) / 2.0f;
                Objects.requireNonNull(fontRenderer);
                float _y = f + (float)(i * 9);
                graphics.method_51433(fontRenderer, line, (int)(x + (float)width - (float)lineWidth), (int)_y, this.color, this.dropShadow);
            }
        } else if (this.type == TextType.HIDE) {
            if (Widget.isMouseOver((int)x, (int)y, width, height, mouseX, mouseY) && this.texts.size() > 1) {
                this.drawRollTextLine(graphics, x, y, width, height, fontRenderer, textH, this.text);
            } else {
                String line = this.texts.get(0) + (this.texts.size() > 1 ? ".." : "");
                this.drawTextLine(graphics, x, y, width, height, fontRenderer, textH, line);
            }
        } else if (this.type == TextType.ROLL || this.type == TextType.ROLL_ALWAYS) {
            if (this.texts.size() > 1 && (this.type == TextType.ROLL_ALWAYS || Widget.isMouseOver((int)x, (int)y, width, height, mouseX, mouseY))) {
                this.drawRollTextLine(graphics, x, y, width, height, fontRenderer, textH, this.text);
            } else {
                this.drawTextLine(graphics, x, y, width, height, fontRenderer, textH, this.texts.get(0));
            }
        } else if (this.type == TextType.LEFT_HIDE) {
            if (Widget.isMouseOver((int)x, (int)y, width, height, mouseX, mouseY) && this.texts.size() > 1) {
                this.drawRollTextLine(graphics, x, y, width, height, fontRenderer, textH, this.text);
            } else {
                String line = this.texts.get(0) + (this.texts.size() > 1 ? ".." : "");
                float _y = y + (float)(height - textH) / 2.0f;
                graphics.method_51433(fontRenderer, line, (int)x, (int)_y, this.color, this.dropShadow);
            }
        } else if (this.type == TextType.LEFT_ROLL || this.type == TextType.LEFT_ROLL_ALWAYS) {
            if (this.texts.size() > 1 && (this.type == TextType.LEFT_ROLL_ALWAYS || Widget.isMouseOver((int)x, (int)y, width, height, mouseX, mouseY))) {
                this.drawRollTextLine(graphics, x, y, width, height, fontRenderer, textH, this.text);
            } else {
                float _y = y + (float)(height - textH) / 2.0f;
                graphics.method_51433(fontRenderer, this.texts.get(0), (int)x, (int)_y, this.color, this.dropShadow);
            }
        }
        graphics.method_51448().method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Environment(value=EnvType.CLIENT)
    private void drawRollTextLine(class_332 graphics, float x, float y, int width, int height, class_327 fontRenderer, int textH, String line) {
        float _y = y + (float)(height - textH) / 2.0f;
        int textW = fontRenderer.method_1727(line);
        int totalW = width + textW + 10;
        float from = x + (float)width;
        graphics.method_44379((int)x, (int)y, (int)(x + (float)width), (int)(y + (float)height));
        double t = this.rollSpeed > 0.0f ? (double)(this.rollSpeed * (float)(Math.abs(System.currentTimeMillis()) / 10L % (long)totalW) / ((float)totalW * this.rollSpeed)) : 0.5;
        graphics.method_51433(fontRenderer, line, (int)((double)from - t * (double)totalW), (int)_y, this.color, this.dropShadow);
        graphics.method_44380();
    }

    @Environment(value=EnvType.CLIENT)
    private void drawTextLine(class_332 graphics, float x, float y, int width, int height, class_327 fontRenderer, int textH, String line) {
        int textW = fontRenderer.method_1727(line);
        float _x = x + (float)(width - textW) / 2.0f;
        float _y = y + (float)(height - textH) / 2.0f;
        graphics.method_51433(fontRenderer, line, (int)_x, (int)_y, this.color, this.dropShadow);
    }

    public void setRollSpeed(float rollSpeed) {
        this.rollSpeed = rollSpeed;
    }

    public static enum TextType {
        NORMAL,
        HIDE,
        ROLL,
        ROLL_ALWAYS,
        LEFT,
        RIGHT,
        LEFT_HIDE,
        LEFT_ROLL,
        LEFT_ROLL_ALWAYS;

    }
}

