/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.shader.Shaders;
import com.lowdragmc.lowdraglib.client.shader.management.Shader;
import com.lowdragmc.lowdraglib.client.shader.management.ShaderManager;
import com.lowdragmc.lowdraglib.client.shader.management.ShaderProgram;
import com.lowdragmc.lowdraglib.client.shader.uniform.UniformCache;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.joml.Matrix4f;

@LDLRegister(name="shader_texture", group="texture")
public class ShaderTexture
extends TransformTexture {
    private static final Map<class_2960, ShaderTexture> CACHE = new HashMap<class_2960, ShaderTexture>();
    @Configurable(name="ldlib.gui.editor.name.resource", tips={"ldlib.gui.editor.tips.shader_location"})
    public class_2960 location;
    @Environment(value=EnvType.CLIENT)
    private ShaderProgram program;
    @Environment(value=EnvType.CLIENT)
    private Shader shader;
    @Configurable(tips={"ldlib.gui.editor.tips.shader_resolution"})
    @NumberRange(range={1.0, 3.0})
    private float resolution = 2.0f;
    @Configurable
    @NumberColor
    private int color = -1;
    private Consumer<UniformCache> uniformCache;
    private final boolean isRaw;

    private ShaderTexture(boolean isRaw) {
        this.isRaw = isRaw;
    }

    public ShaderTexture() {
        this(false);
        this.location = new class_2960("ldlib:fbm");
        if (LDLib.isRemote() && ShaderManager.allowedShader()) {
            Shader shader = Shaders.load(Shader.ShaderType.FRAGMENT, this.location);
            if (shader == null) {
                return;
            }
            this.program = new ShaderProgram();
            this.shader = shader;
            this.program.attach(Shaders.GUI_IMAGE_V);
            this.program.attach(shader);
        }
    }

    public static void clearCache() {
        CACHE.values().forEach(ShaderTexture::dispose);
        CACHE.clear();
    }

    public void dispose() {
        if (this.isRaw && this.shader != null) {
            this.shader.deleteShader();
        }
        if (this.program != null) {
            this.program.delete();
        }
        this.shader = null;
        this.program = null;
    }

    @Override
    public ShaderTexture setColor(int color) {
        this.color = color;
        return this;
    }

    @ConfigSetter(field="location")
    public void updateShader(class_2960 location) {
        if (LDLib.isRemote() && ShaderManager.allowedShader()) {
            this.location = location;
            this.dispose();
            Shader shader = Shaders.load(Shader.ShaderType.FRAGMENT, location);
            if (shader == null) {
                return;
            }
            this.program = new ShaderProgram();
            this.shader = shader;
            this.program.attach(Shaders.GUI_IMAGE_V);
            this.program.attach(shader);
        }
    }

    public void updateRawShader(String rawShader) {
        if (LDLib.isRemote() && ShaderManager.allowedShader()) {
            this.dispose();
            this.shader = new Shader(Shader.ShaderType.FRAGMENT, rawShader).compileShader();
            this.program = new ShaderProgram();
            this.program.attach(Shaders.GUI_IMAGE_V);
            this.program.attach(this.shader);
        }
    }

    public String getRawShader() {
        if (LDLib.isRemote() && ShaderManager.allowedShader() && this.shader != null) {
            return this.shader.source;
        }
        return "";
    }

    @Environment(value=EnvType.CLIENT)
    private ShaderTexture(Shader shader, boolean isRaw) {
        this.isRaw = isRaw;
        if (shader == null) {
            return;
        }
        this.program = new ShaderProgram();
        this.shader = shader;
        this.program.attach(Shaders.GUI_IMAGE_V);
        this.program.attach(shader);
    }

    public static ShaderTexture createShader(class_2960 location) {
        ShaderTexture texture;
        if (CACHE.containsKey(location) && ShaderTexture.CACHE.get((Object)location).shader != null) {
            return CACHE.get(location);
        }
        if (LDLib.isRemote() && ShaderManager.allowedShader()) {
            Shader shader = Shaders.load(Shader.ShaderType.FRAGMENT, location);
            texture = new ShaderTexture(shader, false);
            CACHE.put(location, texture);
        } else {
            texture = new ShaderTexture(false);
        }
        texture.location = location;
        return texture;
    }

    public static ShaderTexture createRawShader(String rawShader) {
        if (LDLib.isRemote() && ShaderManager.allowedShader()) {
            Shader shader = new Shader(Shader.ShaderType.FRAGMENT, rawShader).compileShader();
            return new ShaderTexture(shader, true);
        }
        return new ShaderTexture(true);
    }

    public ShaderTexture setUniformCache(Consumer<UniformCache> uniformCache) {
        this.uniformCache = uniformCache;
        return this;
    }

    public ShaderTexture setResolution(float resolution) {
        this.resolution = resolution;
        return this;
    }

    public float getResolution() {
        return this.resolution;
    }

    public void bindTexture(String samplerName, int id) {
        if (LDLib.isRemote() && ShaderManager.allowedShader() && this.program != null) {
            this.program.bindTexture(samplerName, id);
        }
    }

    public void bindTexture(String samplerName, class_2960 location) {
        if (LDLib.isRemote() && ShaderManager.allowedShader() && this.program != null) {
            this.program.bindTexture(samplerName, location);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void drawInternal(class_332 graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        if (this.program != null) {
            try {
                this.program.use(cache -> {
                    class_310 mc = class_310.method_1551();
                    float time = mc.field_1724 != null ? ((float)mc.field_1724.field_6012 + mc.method_1488()) / 20.0f : (float)System.currentTimeMillis() / 1000.0f;
                    float mX = class_3532.method_15363((float)((float)mouseX - x), (float)0.0f, (float)width);
                    float mY = class_3532.method_15363((float)((float)mouseY - y), (float)0.0f, (float)height);
                    cache.glUniformMatrix4F("ModelViewMat", RenderSystem.getModelViewMatrix());
                    cache.glUniformMatrix4F("ProjMat", RenderSystem.getProjectionMatrix());
                    cache.glUniform2F("iResolution", (float)width * this.resolution, (float)height * this.resolution);
                    cache.glUniform2F("iMouse", mX * this.resolution, mY * this.resolution);
                    cache.glUniform1F("iTime", time);
                    if (this.uniformCache != null) {
                        this.uniformCache.accept(cache);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                this.dispose();
                return;
            }
            RenderSystem.enableBlend();
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            Matrix4f mat = graphics.method_51448().method_23760().method_23761();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            buffer.method_22918(mat, x, y + (float)height, 0.0f).method_22913(0.0f, 0.0f).method_39415(this.color).method_1344();
            buffer.method_22918(mat, x + (float)width, y + (float)height, 0.0f).method_22913(1.0f, 0.0f).method_39415(this.color).method_1344();
            buffer.method_22918(mat, x + (float)width, y, 0.0f).method_22913(1.0f, 1.0f).method_39415(this.color).method_1344();
            buffer.method_22918(mat, x, y, 0.0f).method_22913(0.0f, 1.0f).method_39415(this.color).method_1344();
            class_286.method_43437((class_287.class_7433)buffer.method_1326());
            this.program.release();
        } else {
            DrawerHelper.drawText(graphics, "Error compiling shader", x + 2.0f, y + 2.0f, 1.0f, -65536);
        }
    }
}

