/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_757;
import org.joml.Matrix4f;

@LDLRegister(name="resource_texture", group="texture")
public class ResourceTexture
extends TransformTexture {
    @Configurable(name="ldlib.gui.editor.name.resource")
    public class_2960 imageLocation = new class_2960("ldlib:textures/gui/icon.png");
    @Configurable
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38}, wheel=0.02)
    public float offsetX = 0.0f;
    @Configurable
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38}, wheel=0.02)
    public float offsetY = 0.0f;
    @Configurable
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38}, wheel=0.02)
    public float imageWidth = 1.0f;
    @Configurable
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38}, wheel=0.02)
    public float imageHeight = 1.0f;
    @Configurable
    @NumberColor
    protected int color = -1;

    public ResourceTexture(class_2960 imageLocation, float offsetX, float offsetY, float width, float height) {
        this.imageLocation = imageLocation;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.imageWidth = width;
        this.imageHeight = height;
    }

    public ResourceTexture(String imageLocation) {
        this(new class_2960(imageLocation), 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public ResourceTexture getSubTexture(float offsetX, float offsetY, float width, float height) {
        return new ResourceTexture(this.imageLocation, this.offsetX + this.imageWidth * offsetX, this.offsetY + this.imageHeight * offsetY, this.imageWidth * width, this.imageHeight * height);
    }

    public ResourceTexture getSubTexture(double offsetX, double offsetY, double width, double height) {
        return new ResourceTexture(this.imageLocation, this.offsetX + (float)((double)this.imageWidth * offsetX), this.offsetY + (float)((double)this.imageHeight * offsetY), this.imageWidth * (float)width, this.imageHeight * (float)height);
    }

    public ResourceTexture copy() {
        return this.getSubTexture(0.0f, 0.0f, 1.0f, 1.0f);
    }

    @Override
    public ResourceTexture setColor(int color) {
        this.color = color;
        return this;
    }

    public static ResourceTexture fromSpirit(class_2960 texture) {
        if (LDLib.isClient()) {
            class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(texture);
            return new ResourceTexture(class_1059.field_5275, sprite.method_4594(), sprite.method_4593(), sprite.method_4577() - sprite.method_4594(), sprite.method_4575() - sprite.method_4593());
        }
        return new ResourceTexture("");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void drawInternal(class_332 graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        this.drawSubArea(graphics, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void drawSubAreaInternal(class_332 graphics, float x, float y, float width, float height, float drawnU, float drawnV, float drawnWidth, float drawnHeight) {
        float imageU = this.offsetX + this.imageWidth * drawnU;
        float imageV = this.offsetY + this.imageHeight * drawnV;
        float imageWidth = this.imageWidth * drawnWidth;
        float imageHeight = this.imageHeight * drawnHeight;
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.imageLocation);
        Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferbuilder.method_22918(matrix4f, x, y + height, 0.0f).method_22913(imageU, imageV + imageHeight).method_39415(this.color).method_1344();
        bufferbuilder.method_22918(matrix4f, x + width, y + height, 0.0f).method_22913(imageU + imageWidth, imageV + imageHeight).method_39415(this.color).method_1344();
        bufferbuilder.method_22918(matrix4f, x + width, y, 0.0f).method_22913(imageU + imageWidth, imageV).method_39415(this.color).method_1344();
        bufferbuilder.method_22918(matrix4f, x, y, 0.0f).method_22913(imageU, imageV).method_39415(this.color).method_1344();
        tessellator.method_1350();
    }

    @Override
    public void createPreview(ConfiguratorGroup father) {
        super.createPreview(father);
        WidgetGroup widgetGroup = new WidgetGroup(0, 0, 100, 100);
        widgetGroup.addWidget(new ImageWidget(0, 0, 100, 100, () -> new GuiTextureGroup(new ResourceTexture(this.imageLocation.toString()), this::drawGuides)).setBorder(2, ColorPattern.T_WHITE.color));
        widgetGroup.addWidget(new ButtonWidget(0, 0, 100, 100, IGuiTexture.EMPTY, cd -> {
            if (Editor.INSTANCE == null) {
                return;
            }
            File path = new File(Editor.INSTANCE.getWorkSpace(), "assets/ldlib/textures");
            DialogWidget.showFileDialog(Editor.INSTANCE, "ldlib.gui.editor.tips.select_image", path, true, DialogWidget.suffixFilter(".png"), r -> {
                if (r != null && r.isFile()) {
                    this.imageLocation = this.getTextureFromFile(path, (File)r);
                    this.offsetX = 0.0f;
                    this.offsetY = 0.0f;
                    this.imageWidth = 1.0f;
                    this.imageHeight = 1.0f;
                }
            });
        }));
        WrapperConfigurator base = new WrapperConfigurator("ldlib.gui.editor.group.base_image", widgetGroup);
        base.setTips("ldlib.gui.editor.tips.click_select_image");
        father.addConfigurators(base);
    }

    private class_2960 getTextureFromFile(File path, File r) {
        return new class_2960("ldlib:" + r.getPath().replace(path.getPath(), "textures").replace('\\', '/'));
    }

    @Environment(value=EnvType.CLIENT)
    protected void drawGuides(class_332 graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        new ColorBorderTexture(-1, -65536).draw(graphics, 0, 0, x + (float)width * this.offsetX, y + (float)height * this.offsetY, (int)((float)width * this.imageWidth), (int)((float)height * this.imageHeight));
    }

    public ResourceTexture() {
    }
}

