/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.runtime.PersistedParser;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public interface IGuiTexture
extends IConfigurable {
    public static final IGuiTexture EMPTY = new IGuiTexture(){

        @Override
        @Environment(value=EnvType.CLIENT)
        public void draw(class_332 graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        }
    };
    public static final IGuiTexture MISSING_TEXTURE = new IGuiTexture(){

        @Override
        @Environment(value=EnvType.CLIENT)
        public void draw(class_332 graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
            class_289 tessellator = class_289.method_1348();
            class_287 bufferbuilder = tessellator.method_1349();
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_1060.field_5285);
            Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
            bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferbuilder.method_22918(matrix4f, x, y + (float)height, 0.0f).method_22913(0.0f, 1.0f).method_1344();
            bufferbuilder.method_22918(matrix4f, x + (float)width, y + (float)height, 0.0f).method_22913(1.0f, 1.0f).method_1344();
            bufferbuilder.method_22918(matrix4f, x + (float)width, y, 0.0f).method_22913(1.0f, 0.0f).method_1344();
            bufferbuilder.method_22918(matrix4f, x, y, 0.0f).method_22913(0.0f, 0.0f).method_1344();
            tessellator.method_1350();
        }
    };
    public static final Function<String, AnnotationDetector.Wrapper<LDLRegister, IGuiTexture>> CACHE = class_156.method_34866(type -> {
        for (AnnotationDetector.Wrapper<LDLRegister, IGuiTexture> wrapper : AnnotationDetector.REGISTER_TEXTURES) {
            if (!wrapper.annotation().name().equals(type)) continue;
            return wrapper;
        }
        return null;
    });

    default public IGuiTexture setColor(int color) {
        return this;
    }

    default public IGuiTexture rotate(float degree) {
        return this;
    }

    default public IGuiTexture scale(float scale) {
        return this;
    }

    default public IGuiTexture transform(int xOffset, int yOffset) {
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    public void draw(class_332 var1, int var2, int var3, float var4, float var5, int var6, int var7);

    @Environment(value=EnvType.CLIENT)
    default public void updateTick() {
    }

    @Environment(value=EnvType.CLIENT)
    default public void drawSubArea(class_332 graphics, float x, float y, float width, float height, float drawnU, float drawnV, float drawnWidth, float drawnHeight) {
        this.draw(graphics, 0, 0, x, y, (int)width, (int)height);
    }

    default public void createPreview(ConfiguratorGroup father) {
        father.addConfigurators(new WrapperConfigurator("ldlib.gui.editor.group.preview", new ImageWidget(0, 0, 100, 100, this).setBorder(2, ColorPattern.T_WHITE.color)));
    }

    @Override
    default public void buildConfigurator(ConfiguratorGroup father) {
        this.createPreview(father);
        IConfigurable.super.buildConfigurator(father);
    }

    @Nullable
    public static class_2487 serializeWrapper(IGuiTexture texture) {
        if (texture.isLDLRegister()) {
            class_2487 tag = new class_2487();
            tag.method_10582("type", texture.name());
            class_2487 data = new class_2487();
            PersistedParser.serializeNBT(data, texture.getClass(), texture);
            tag.method_10566("data", (class_2520)data);
            return tag;
        }
        return null;
    }

    @NotNull
    public static IGuiTexture deserializeWrapper(class_2487 tag) {
        String type = tag.method_10558("type");
        class_2487 data = tag.method_10562("data");
        AnnotationDetector.Wrapper<LDLRegister, IGuiTexture> wrapper = CACHE.apply(type);
        IGuiTexture value = wrapper == null ? EMPTY : wrapper.creator().get();
        PersistedParser.deserializeNBT(data, new HashMap<String, Method>(), value.getClass(), value);
        return value;
    }

    default public void setUIResource(Resource<IGuiTexture> texturesResource) {
    }
}

