/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

@LDLRegister(name="group_texture", group="texture")
public class GuiTextureGroup
extends TransformTexture {
    @Configurable(collapse=false)
    public IGuiTexture[] textures;

    public GuiTextureGroup() {
        this(ResourceBorderTexture.BORDERED_BACKGROUND, new ResourceTexture());
    }

    public GuiTextureGroup(IGuiTexture ... textures) {
        this.textures = textures;
    }

    public GuiTextureGroup setTextures(IGuiTexture[] textures) {
        this.textures = textures;
        return this;
    }

    @Override
    public GuiTextureGroup setColor(int color) {
        for (IGuiTexture texture : this.textures) {
            texture.setColor(color);
        }
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void drawInternal(class_332 graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        for (IGuiTexture texture : this.textures) {
            texture.draw(graphics, mouseX, mouseY, x, y, width, height);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void updateTick() {
        for (IGuiTexture texture : this.textures) {
            texture.updateTick();
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void drawSubAreaInternal(class_332 graphics, float x, float y, float width, float height, float drawnU, float drawnV, float drawnWidth, float drawnHeight) {
        for (IGuiTexture texture : this.textures) {
            texture.drawSubArea(graphics, x, y, width, height, drawnU, drawnV, drawnWidth, drawnHeight);
        }
    }

    @Override
    public void setUIResource(Resource<IGuiTexture> texturesResource) {
        for (IGuiTexture texture : this.textures) {
            texture.setUIResource(texturesResource);
        }
    }
}

