/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_757;
import org.joml.Matrix4f;

@LDLRegister(name="animation_texture", group="texture")
public class AnimationTexture
extends TransformTexture {
    @Configurable(name="ldlib.gui.editor.name.resource")
    public class_2960 imageLocation;
    @Configurable(tips={"ldlib.gui.editor.tips.cell_size"})
    @NumberRange(range={1.0, 2.147483647E9})
    protected int cellSize;
    @Configurable(tips={"ldlib.gui.editor.tips.cell_from"})
    @NumberRange(range={0.0, 2.147483647E9})
    protected int from;
    @Configurable(tips={"ldlib.gui.editor.tips.cell_to"})
    @NumberRange(range={0.0, 2.147483647E9})
    protected int to;
    @Configurable(tips={"ldlib.gui.editor.tips.cell_animation"})
    @NumberRange(range={0.0, 2.147483647E9})
    protected int animation;
    @Configurable
    @NumberColor
    protected int color = -1;
    protected int currentFrame;
    protected int currentTime;
    private long lastTick;

    public AnimationTexture() {
        this("ldlib:textures/gui/particles.png");
        this.setCellSize(8).setAnimation(32, 44).setAnimation(1);
    }

    public AnimationTexture(String imageLocation) {
        this.imageLocation = new class_2960(imageLocation);
    }

    public AnimationTexture(class_2960 imageLocation) {
        this.imageLocation = imageLocation;
    }

    public AnimationTexture copy() {
        return new AnimationTexture(this.imageLocation).setCellSize(this.cellSize).setAnimation(this.from, this.to).setAnimation(this.animation).setColor(this.color);
    }

    public AnimationTexture setCellSize(int cellSize) {
        this.cellSize = cellSize;
        return this;
    }

    public AnimationTexture setAnimation(int from, int to) {
        this.currentFrame = from;
        this.from = from;
        this.to = to;
        return this;
    }

    public AnimationTexture setAnimation(int animation) {
        this.animation = animation;
        return this;
    }

    @Override
    public AnimationTexture setColor(int color) {
        this.color = color;
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void updateTick() {
        if (class_310.method_1551().field_1687 != null) {
            long tick = class_310.method_1551().field_1687.method_8510();
            if (tick == this.lastTick) {
                return;
            }
            this.lastTick = tick;
        }
        if (this.currentTime >= this.animation) {
            this.currentTime = 0;
            ++this.currentFrame;
        } else {
            ++this.currentTime;
        }
        if (this.currentFrame > this.to) {
            this.currentFrame = this.from;
        } else if (this.currentFrame < this.from) {
            this.currentFrame = this.from;
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void drawInternal(class_332 graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        float cell = 1.0f / (float)this.cellSize;
        int X = this.currentFrame % this.cellSize;
        int Y = this.currentFrame / this.cellSize;
        float imageU = (float)X * cell;
        float imageV = (float)Y * cell;
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.imageLocation);
        Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferbuilder.method_22918(matrix4f, x, y + (float)height, 0.0f).method_22913(imageU, imageV + cell).method_39415(this.color).method_1344();
        bufferbuilder.method_22918(matrix4f, x + (float)width, y + (float)height, 0.0f).method_22913(imageU + cell, imageV + cell).method_39415(this.color).method_1344();
        bufferbuilder.method_22918(matrix4f, x + (float)width, y, 0.0f).method_22913(imageU + cell, imageV).method_39415(this.color).method_1344();
        bufferbuilder.method_22918(matrix4f, x, y, 0.0f).method_22913(imageU, imageV).method_39415(this.color).method_1344();
        tessellator.method_1350();
    }

    @Override
    public void createPreview(ConfiguratorGroup father) {
        super.createPreview(father);
        WidgetGroup widgetGroup = new WidgetGroup(0, 0, 100, 100);
        ImageWidget imageWidget = new ImageWidget(0, 0, 100, 100, new GuiTextureGroup(new ResourceTexture(this.imageLocation.toString()), this::drawGuides)).setBorder(2, ColorPattern.T_WHITE.color);
        widgetGroup.addWidget(imageWidget);
        widgetGroup.addWidget(new ButtonWidget(0, 0, 100, 100, IGuiTexture.EMPTY, cd -> {
            if (Editor.INSTANCE == null) {
                return;
            }
            File path = new File(Editor.INSTANCE.getWorkSpace(), "assets/ldlib/textures");
            DialogWidget.showFileDialog(Editor.INSTANCE, "ldlib.gui.editor.tips.select_image", path, true, DialogWidget.suffixFilter(".png"), r -> {
                if (r != null && r.isFile()) {
                    this.imageLocation = this.getTextureFromFile(path, (File)r);
                    this.cellSize = 1;
                    this.from = 0;
                    this.to = 0;
                    this.animation = 0;
                    imageWidget.setImage(new GuiTextureGroup(new ResourceTexture(this.imageLocation.toString()), this::drawGuides));
                }
            });
        }));
        WrapperConfigurator base = new WrapperConfigurator("ldlib.gui.editor.group.base_image", widgetGroup);
        base.setTips("ldlib.gui.editor.tips.click_select_image");
        father.addConfigurators(base);
    }

    private class_2960 getTextureFromFile(File path, File r) {
        return new class_2960("ldlib:" + r.getPath().replace(path.getPath(), "textures").replace('\\', '/'));
    }

    @Environment(value=EnvType.CLIENT)
    protected void drawGuides(class_332 graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        float cell = 1.0f / (float)this.cellSize;
        int X = this.from % this.cellSize;
        int Y = this.from / this.cellSize;
        float imageU = (float)X * cell;
        float imageV = (float)Y * cell;
        new ColorBorderTexture(-1, -16711936).draw(graphics, 0, 0, x + (float)width * imageU, y + (float)height * imageV, (int)((float)width * cell), (int)((float)height * cell));
        X = this.to % this.cellSize;
        Y = this.to / this.cellSize;
        imageU = (float)X * cell;
        imageV = (float)Y * cell;
        new ColorBorderTexture(-1, -65536).draw(graphics, 0, 0, x + (float)width * imageU, y + (float)height * imageV, (int)((float)width * cell), (int)((float)height * cell));
    }
}

