/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.modular;

import com.lowdragmc.lowdraglib.core.mixins.accessor.AbstractContainerMenuAccessor;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.WidgetUIAccess;
import com.lowdragmc.lowdraglib.gui.util.PerTickIntCounter;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.networking.LDLNetworking;
import com.lowdragmc.lowdraglib.networking.c2s.CPacketUIClientAction;
import com.lowdragmc.lowdraglib.networking.s2c.SPacketUIWidgetUpdate;
import io.netty.buffer.Unpooled;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_742;

public class ModularUIContainer
extends class_1703
implements WidgetUIAccess {
    private final ModularUI modularUI;
    private final PerTickIntCounter transferredPerTick = new PerTickIntCounter(0);

    public ModularUIContainer(ModularUI modularUI, int windowID) {
        super(null, windowID);
        this.modularUI = modularUI;
        this.modularUI.setModularUIContainer(this);
        modularUI.mainGroup.setUiAccess(this);
    }

    @Nonnull
    public class_1735 method_7621(@Nonnull class_1735 slotHandle) {
        OptionalInt emptySlotIndex = this.field_7761.stream().filter(it -> it instanceof EmptySlotPlaceholder).mapToInt(slot -> slot.field_7874).findFirst();
        if (emptySlotIndex.isPresent()) {
            slotHandle.field_7874 = emptySlotIndex.getAsInt();
            this.field_7761.set(slotHandle.field_7874, (Object)slotHandle);
            ((AbstractContainerMenuAccessor)((Object)this)).getLastSlots().set(slotHandle.field_7874, (Object)class_1799.field_8037);
            ((AbstractContainerMenuAccessor)((Object)this)).getRemoteSlots().set(slotHandle.field_7874, (Object)class_1799.field_8037);
        } else {
            slotHandle.field_7874 = this.field_7761.size();
            this.field_7761.add((Object)slotHandle);
            ((AbstractContainerMenuAccessor)((Object)this)).getLastSlots().add((Object)class_1799.field_8037);
            ((AbstractContainerMenuAccessor)((Object)this)).getRemoteSlots().add((Object)class_1799.field_8037);
        }
        return slotHandle;
    }

    public void removeSlot(class_1735 slotHandle) {
        EmptySlotPlaceholder emptySlotPlaceholder = new EmptySlotPlaceholder();
        emptySlotPlaceholder.field_7874 = slotHandle.field_7874;
        this.field_7761.set(slotHandle.field_7874, (Object)emptySlotPlaceholder);
        ((AbstractContainerMenuAccessor)((Object)this)).getLastSlots().set(slotHandle.field_7874, (Object)class_1799.field_8037);
        ((AbstractContainerMenuAccessor)((Object)this)).getRemoteSlots().set(slotHandle.field_7874, (Object)class_1799.field_8037);
    }

    public ModularUI getModularUI() {
        return this.modularUI;
    }

    public void method_7595(@Nonnull class_1657 playerIn) {
        super.method_7595(playerIn);
        this.modularUI.triggerCloseListeners();
    }

    public void method_7596(@Nonnull class_1712 pListener) {
        super.method_7596(pListener);
        this.modularUI.mainGroup.detectAndSendChanges();
    }

    public void method_7623() {
        class_1657 class_16572;
        super.method_7623();
        if (this.modularUI.holder.isInvalid() && (class_16572 = this.modularUI.entityPlayer) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            serverPlayer.method_7346();
        }
        this.modularUI.mainGroup.detectAndSendChanges();
        this.modularUI.addTick();
    }

    public void method_7593(int slotId, int dragType, @Nonnull class_1713 clickTypeIn, @Nonnull class_1657 player) {
        if (slotId >= 0 && slotId < this.field_7761.size()) {
            class_1735 slot = this.method_7611(slotId);
            class_1799 result = this.modularUI.getSlotMap().get(slot).slotClick(dragType, clickTypeIn, player);
            if (result == null) {
                super.method_7593(slotId, dragType, clickTypeIn, player);
            }
        }
        if (slotId == -999) {
            super.method_7593(slotId, dragType, clickTypeIn, player);
        }
    }

    private List<SlotWidget> getShiftClickSlots(class_1799 itemStack, boolean fromContainer) {
        return this.modularUI.getSlotMap().values().stream().filter(it -> it.canMergeSlot(itemStack)).filter(it -> it.isPlayerContainer == fromContainer).sorted(Comparator.comparing(s -> (fromContainer ? -1 : 1) * s.getHandle().field_7874)).collect(Collectors.toList());
    }

    @Override
    public boolean attemptMergeStack(class_1799 itemStack, boolean fromContainer, boolean simulate) {
        List<class_1735> slots = this.getShiftClickSlots(itemStack, fromContainer).stream().map(SlotWidget::getHandle).collect(Collectors.toList());
        return ModularUIContainer.mergeItemStack(itemStack, slots, simulate);
    }

    public static boolean mergeItemStack(class_1799 itemStack, List<class_1735> slots, boolean simulate) {
        if (itemStack.method_7960()) {
            return false;
        }
        boolean merged = false;
        for (class_1735 slot : slots) {
            class_1799 stackInSlot;
            if (!slot.method_7680(itemStack) || !class_1799.method_7984((class_1799)itemStack, (class_1799)(stackInSlot = slot.method_7677())) || !class_1799.method_31577((class_1799)itemStack, (class_1799)stackInSlot)) continue;
            int slotMaxStackSize = Math.min(stackInSlot.method_7914(), slot.method_7676(stackInSlot));
            int amountToInsert = Math.min(itemStack.method_7947(), slotMaxStackSize - stackInSlot.method_7947());
            if (amountToInsert == 0) continue;
            if (!simulate) {
                stackInSlot.method_7933(amountToInsert);
            }
            itemStack.method_7934(amountToInsert);
            slot.method_7668();
            merged = true;
            if (!itemStack.method_7960()) continue;
            return true;
        }
        for (class_1735 slot : slots) {
            int amountToInsert;
            if (!slot.method_7680(itemStack) || slot.method_7681() || (amountToInsert = Math.min(itemStack.method_7947(), slot.method_7676(itemStack))) == 0) continue;
            class_1799 stackInSlot = itemStack.method_7971(amountToInsert);
            if (!simulate) {
                slot.method_7673(stackInSlot);
            }
            merged = true;
            if (!itemStack.method_7960()) continue;
            return true;
        }
        return merged;
    }

    @Nonnull
    public class_1799 method_7601(@Nonnull class_1657 player, int index) {
        boolean fromContainer;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (!slot.method_7674(player)) {
            return class_1799.field_8037;
        }
        if (!slot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 stackInSlot = slot.method_7677();
        class_1799 stackToMerge = stackInSlot.method_7972();
        boolean bl = fromContainer = !this.modularUI.getSlotMap().get((Object)slot).isPlayerContainer;
        if (!this.attemptMergeStack(stackToMerge, fromContainer, true)) {
            return class_1799.field_8037;
        }
        int itemsMerged = stackToMerge.method_7960() || this.modularUI.getSlotMap().get(slot).canMergeSlot(stackToMerge) ? stackInSlot.method_7947() - stackToMerge.method_7947() : stackInSlot.method_7947();
        int itemsToExtract = itemsMerged;
        if ((itemsMerged += this.transferredPerTick.get(player.method_37908())) > stackInSlot.method_7914()) {
            return class_1799.field_8037;
        }
        this.transferredPerTick.increment(player.method_37908(), itemsToExtract);
        class_1799 extractedStack = stackInSlot.method_7971(itemsToExtract);
        if (stackInSlot.method_7960()) {
            slot.method_7673(class_1799.field_8037);
        } else {
            slot.method_7668();
        }
        class_1799 resultStack = extractedStack.method_7972();
        if (!this.attemptMergeStack(extractedStack, fromContainer, false)) {
            resultStack = class_1799.field_8037;
        }
        if (!extractedStack.method_7960()) {
            player.method_7329(extractedStack, false, false);
            resultStack = class_1799.field_8037;
        }
        return resultStack;
    }

    public boolean method_7613(@Nonnull class_1799 stack, @Nonnull class_1735 slotIn) {
        return this.modularUI.getSlotMap().get(slotIn).canMergeSlot(stack);
    }

    public boolean method_7597(@Nonnull class_1657 playerIn) {
        return true;
    }

    @Override
    public void writeClientAction(Widget widget, int updateId, Consumer<class_2540> payloadWriter) {
        class_2540 packetBuffer = new class_2540(Unpooled.buffer());
        packetBuffer.method_10804(updateId);
        payloadWriter.accept(packetBuffer);
        if (this.modularUI.entityPlayer instanceof class_742) {
            LDLNetworking.NETWORK.sendToServer(new CPacketUIClientAction(this.field_7763, packetBuffer));
        }
    }

    @Override
    public void writeUpdateInfo(Widget widget, int updateId, Consumer<class_2540> payloadWriter) {
        class_2540 packetBuffer = new class_2540(Unpooled.buffer());
        packetBuffer.method_10804(updateId);
        payloadWriter.accept(packetBuffer);
        if (this.modularUI.entityPlayer instanceof class_3222) {
            SPacketUIWidgetUpdate widgetUpdate = new SPacketUIWidgetUpdate(this.field_7763, packetBuffer);
            LDLNetworking.NETWORK.sendToPlayer(widgetUpdate, (class_3222)this.modularUI.entityPlayer);
        }
    }

    public void handleClientAction(CPacketUIClientAction packet) {
        if (packet.windowId == this.field_7763) {
            int updateId = packet.updateData.method_10816();
            this.modularUI.mainGroup.handleClientAction(updateId, packet.updateData);
        }
    }

    private static class EmptySlotPlaceholder
    extends class_1735 {
        private static final class_1263 EMPTY_INVENTORY = new class_1277(0);

        public EmptySlotPlaceholder() {
            super(EMPTY_INVENTORY, 0, -100000, -100000);
        }

        @Nonnull
        public class_1799 method_7677() {
            return class_1799.field_8037;
        }

        public void method_7673(@Nonnull class_1799 stack) {
        }

        public boolean method_7680(@Nonnull class_1799 stack) {
            return false;
        }

        public boolean method_7674(@Nonnull class_1657 playerIn) {
            return false;
        }

        public boolean method_7682() {
            return false;
        }
    }
}

