/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.factory;

import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.core.mixins.accessor.ServerPlayerAccessor;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIContainer;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.lowdragmc.lowdraglib.networking.LDLNetworking;
import com.lowdragmc.lowdraglib.networking.s2c.SPacketUIOpen;
import com.lowdragmc.lowdraglib.side.ForgeEventHooks;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_746;

public abstract class UIFactory<T> {
    public final class_2960 uiFactoryId;
    public static final Map<class_2960, UIFactory<?>> FACTORIES = new HashMap();

    public UIFactory(class_2960 uiFactoryId) {
        this.uiFactoryId = uiFactoryId;
    }

    public static void register(UIFactory<?> factory) {
        FACTORIES.put(factory.uiFactoryId, factory);
    }

    public final boolean openUI(T holder, class_3222 player) {
        ModularUI uiTemplate = this.createUITemplate(holder, (class_1657)player);
        if (uiTemplate == null) {
            return false;
        }
        uiTemplate.initWidgets();
        if (player.field_7512 != player.field_7498) {
            player.method_7346();
        }
        ((ServerPlayerAccessor)player).callNextContainerCounter();
        int currentWindowId = ((ServerPlayerAccessor)player).getContainerCounter();
        class_2540 serializedHolder = new class_2540(Unpooled.buffer());
        this.writeHolderToSyncData(serializedHolder, holder);
        ModularUIContainer container = new ModularUIContainer(uiTemplate, currentWindowId);
        uiTemplate.mainGroup.writeInitialData(serializedHolder);
        LDLNetworking.NETWORK.sendToPlayer(new SPacketUIOpen(this.uiFactoryId, serializedHolder, currentWindowId), player);
        ((ServerPlayerAccessor)player).callInitMenu(container);
        player.field_7512 = container;
        if (Platform.isForge()) {
            ForgeEventHooks.postPlayerContainerEvent((class_1657)player, (class_1703)container);
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public final void initClientUI(class_2540 serializedHolder, int windowId) {
        T holder = this.readHolderFromSyncData(serializedHolder);
        class_310 minecraft = class_310.method_1551();
        class_746 entityPlayer = minecraft.field_1724;
        ModularUI uiTemplate = this.createUITemplate(holder, (class_1657)entityPlayer);
        if (uiTemplate == null) {
            return;
        }
        uiTemplate.initWidgets();
        ModularUIGuiContainer ModularUIGuiContainer2 = new ModularUIGuiContainer(uiTemplate, windowId);
        uiTemplate.mainGroup.readInitialData(serializedHolder);
        minecraft.method_1507((class_437)ModularUIGuiContainer2);
        minecraft.field_1724.field_7512 = ModularUIGuiContainer2.method_17577();
    }

    protected abstract ModularUI createUITemplate(T var1, class_1657 var2);

    @Environment(value=EnvType.CLIENT)
    protected abstract T readHolderFromSyncData(class_2540 var1);

    protected abstract void writeHolderToSyncData(class_2540 var1, T var2);
}

