/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.menu;

import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.ui.menu.MenuTab;
import com.lowdragmc.lowdraglib.gui.editor.ui.view.FloatViewWidget;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;

@LDLRegister(name="view", group="editor", priority=100)
public class ViewMenu
extends MenuTab {
    public final Map<String, FloatViewWidget> openedViews = new HashMap<String, FloatViewWidget>();

    @Override
    protected TreeBuilder.Menu createMenu() {
        TreeBuilder.Menu viewMenu = TreeBuilder.Menu.start();
        boolean added = false;
        for (AnnotationDetector.Wrapper<LDLRegister, FloatViewWidget> wrapper : AnnotationDetector.REGISTER_FLOAT_VIEWS) {
            if (!this.editor.name().startsWith(wrapper.annotation().group())) continue;
            String translateKey = "ldlib.gui.editor.register.%s.%s".formatted(wrapper.annotation().group(), wrapper.annotation().name());
            String name = wrapper.annotation().name();
            if (this.openedViews.containsKey(name)) {
                viewMenu.leaf(Icons.CHECK, translateKey, () -> this.removeView(name));
            } else {
                viewMenu.leaf(translateKey, () -> {
                    FloatViewWidget view = (FloatViewWidget)wrapper.creator().get();
                    this.openView(view);
                });
            }
            added = true;
        }
        return added ? viewMenu : null;
    }

    public void openView(FloatViewWidget view) {
        if (!this.isViewOpened(view.name())) {
            this.openedViews.put(view.name(), view);
            this.editor.getFloatView().addWidget(view);
        }
    }

    public void removeView(String viewName) {
        if (this.isViewOpened(viewName)) {
            this.editor.getFloatView().removeWidget(this.openedViews.get(viewName));
            this.openedViews.remove(viewName);
        }
    }

    public boolean isViewOpened(String viewName) {
        return this.openedViews.containsKey(viewName);
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 tag = super.serializeNBT();
        for (FloatViewWidget floatViewWidget : this.openedViews.values()) {
        }
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        super.deserializeNBT(nbt);
    }
}

