/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.menu;

import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.ui.menu.MenuTab;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2507;

@LDLRegister(name="file", group="editor", priority=101)
public class FileMenu
extends MenuTab {
    protected Predicate<IProject> projectFilter = project -> project.group().startsWith(this.editor.name());

    @Override
    protected TreeBuilder.Menu createMenu() {
        return TreeBuilder.Menu.start().branch("ldlib.gui.editor.menu.new", this::newProject).crossLine().leaf(Icons.OPEN_FILE, "ldlib.gui.editor.menu.open", this::openProject).leaf(Icons.SAVE, "ldlib.gui.editor.menu.save", this::saveProject).crossLine().branch(Icons.IMPORT, "ldlib.gui.editor.menu.import", menu -> menu.leaf("ldlib.gui.editor.menu.resource", this::importResource)).branch(Icons.EXPORT, "ldlib.gui.editor.menu.export", menu -> menu.leaf("ldlib.gui.editor.menu.resource", this::exportResource));
    }

    private void exportResource() {
        Resources resources = this.editor.getResourcePanel().getResources();
        if (resources != null) {
            DialogWidget.showFileDialog(this.editor, "ldlib.gui.editor.tips.save_resource", this.editor.getWorkSpace(), false, DialogWidget.suffixFilter(".resource"), r -> {
                if (r != null && !r.isDirectory()) {
                    if (!r.getName().endsWith(".resource")) {
                        r = new File(r.getParentFile(), r.getName() + ".resource");
                    }
                    try {
                        class_2507.method_10630((class_2487)resources.serializeNBT(), (File)r);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void importResource() {
        IProject currentProject = this.editor.getCurrentProject();
        if (currentProject != null) {
            DialogWidget.showFileDialog(this.editor, "ldlib.gui.editor.tips.load_resource", this.editor.getWorkSpace(), true, DialogWidget.suffixFilter(".resource"), r -> {
                if (r != null && r.isFile()) {
                    try {
                        class_2487 tag = class_2507.method_10633((File)r);
                        if (tag != null) {
                            this.editor.getResourcePanel().loadResource(currentProject.loadResources(tag), true);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected Predicate<IProject> getProjectPredicate() {
        return this.projectFilter;
    }

    private void newProject(TreeBuilder.Menu menu) {
        for (IProject project : AnnotationDetector.REGISTER_PROJECTS.stream().filter(this.getProjectPredicate()).toList()) {
            menu = menu.leaf(project.getTranslateKey(), () -> this.editor.loadProject(project.newEmptyProject()));
        }
    }

    private void saveProject() {
        IProject project = this.editor.getCurrentProject();
        if (project != null) {
            String suffix = "." + project.getSuffix();
            DialogWidget.showFileDialog(this.editor, "ldlib.gui.editor.tips.save_project", this.editor.getWorkSpace(), false, DialogWidget.suffixFilter(suffix), file -> {
                if (file != null && !file.isDirectory()) {
                    if (!file.getName().endsWith(suffix)) {
                        file = new File(file.getParentFile(), file.getName() + suffix);
                    }
                    project.saveProject((File)file);
                }
            });
        }
    }

    private void openProject() {
        Set suffixes = AnnotationDetector.REGISTER_PROJECTS.stream().filter(this.getProjectPredicate()).map(IProject::getSuffix).collect(Collectors.toSet());
        DialogWidget.showFileDialog(this.editor, "ldlib.gui.editor.tips.load_project", this.editor.getWorkSpace(), true, node -> {
            if (node.isLeaf() && ((File)node.getContent()).isFile()) {
                String file = ((File)node.getContent()).getName().toLowerCase();
                for (String suffix : suffixes) {
                    if (!file.endsWith(suffix.toLowerCase())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }, r -> {
            if (r != null && r.isFile()) {
                String file = r.getName().toLowerCase();
                for (IProject project : AnnotationDetector.REGISTER_PROJECTS.stream().filter(this.getProjectPredicate()).toList()) {
                    IProject p;
                    if (!file.endsWith("." + project.getSuffix()) || (p = project.loadProject((File)r)) == null) continue;
                    this.editor.loadProject(p);
                    break;
                }
            }
        });
    }

    public void setProjectFilter(Predicate<IProject> projectFilter) {
        this.projectFilter = projectFilter;
    }
}

