/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui;

import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.editor.ui.MainPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.tool.WidgetToolBox;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.WidgetTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

public record UIWrapper(MainPanel panel, IConfigurableWidget inner) implements IConfigurable
{
    public boolean isSelected() {
        return this.panel.getSelectedUIs().contains(this);
    }

    public boolean isHover() {
        return this.panel.getHoverUI() == this;
    }

    public boolean checkAcceptable(UIWrapper uiWrapper) {
        IConfigurableWidgetGroup group;
        IConfigurableWidget iConfigurableWidget = this.inner;
        return iConfigurableWidget instanceof IConfigurableWidgetGroup && (group = (IConfigurableWidgetGroup)iConfigurableWidget).canWidgetAccepted(uiWrapper.inner);
    }

    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@Nonnull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        Position pos = this.inner.widget().getPosition();
        Size size = this.inner.widget().getSize();
        int borderColor = 0;
        if (this.isSelected()) {
            borderColor = -65536;
        }
        if (this.isHover()) {
            UIWrapper[] uiWrappers;
            WidgetToolBox.IWidgetPanelDragging widgetPanelDragging;
            if (!this.isSelected()) {
                borderColor = 0x4F0000FF;
            }
            Object dragging = this.panel.getGui().getModularUIGui().getDraggingElement();
            boolean drawDragging = false;
            if (this.inner.canDragIn(dragging)) {
                drawDragging = true;
            } else if (dragging instanceof WidgetToolBox.IWidgetPanelDragging && this.checkAcceptable(new UIWrapper(this.panel, (IConfigurableWidget)(widgetPanelDragging = (WidgetToolBox.IWidgetPanelDragging)dragging).get()))) {
                drawDragging = true;
            } else if (dragging instanceof UIWrapper[] && Arrays.stream(uiWrappers = (UIWrapper[])dragging).allMatch(this::checkAcceptable)) {
                drawDragging = true;
            }
            if (drawDragging) {
                borderColor = -11163051;
            }
        }
        if (borderColor != 0) {
            new ColorBorderTexture(1, borderColor).draw(graphics, mouseX, mouseY, pos.x, pos.y, size.width, size.height);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isHover()) {
            Object dragging = this.panel.getGui().getModularUIGui().getDraggingElement();
            if (dragging instanceof WidgetToolBox.IWidgetPanelDragging) {
                WidgetToolBox.IWidgetPanelDragging widgetPanelDragging = (WidgetToolBox.IWidgetPanelDragging)dragging;
                UIWrapper uiWrapper = new UIWrapper(this.panel, (IConfigurableWidget)widgetPanelDragging.get());
                IConfigurableWidget iConfigurableWidget = this.inner;
                if (iConfigurableWidget instanceof IConfigurableWidgetGroup) {
                    IConfigurableWidgetGroup group = (IConfigurableWidgetGroup)iConfigurableWidget;
                    if (this.checkAcceptable(uiWrapper)) {
                        WidgetGroup parent = uiWrapper.inner.widget().getParent();
                        if (parent != null) {
                            parent.onWidgetRemoved(uiWrapper.inner);
                        }
                        Position position = new Position((int)mouseX, (int)mouseY).subtract(group.widget().getPosition());
                        uiWrapper.inner.widget().setSelfPosition(new Position(position.x - uiWrapper.inner.widget().getSize().width / 2, position.y - uiWrapper.inner.widget().getSize().height / 2));
                        group.acceptWidget(uiWrapper.inner);
                        return true;
                    }
                }
            } else {
                UIWrapper[] uIWrapperArray = this.inner;
                if (uIWrapperArray instanceof IConfigurableWidgetGroup) {
                    UIWrapper[] uiWrappers;
                    IConfigurableWidgetGroup group = (IConfigurableWidgetGroup)uIWrapperArray;
                    if (dragging instanceof UIWrapper[] && Arrays.stream(uiWrappers = (UIWrapper[])dragging).allMatch(this::checkAcceptable)) {
                        for (UIWrapper uiWrapper : uiWrappers) {
                            WidgetGroup parent = uiWrapper.inner.widget().getParent();
                            if (parent != null) {
                                parent.onWidgetRemoved(uiWrapper.inner);
                            }
                            Position position = new Position((int)mouseX, (int)mouseY).subtract(this.inner.widget().getPosition());
                            uiWrapper.inner.widget().setSelfPosition(new Position(position.x - uiWrapper.inner.widget().getSize().width / 2, position.y - uiWrapper.inner.widget().getSize().height / 2));
                            group.acceptWidget(uiWrapper.inner);
                        }
                        return true;
                    }
                }
                return this.inner.handleDragging(dragging);
            }
        }
        return false;
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        if (this.inner.isLDLRegister()) {
            ConfiguratorGroup common = new ConfiguratorGroup(this.inner.getTranslateKey(), false);
            common.setCanCollapse(false);
            father.addConfigurators(common);
            father = common;
        }
        this.inner.buildConfigurator(father);
    }

    public void remove() {
        WidgetGroup parent = this.inner.widget().getParent();
        if (this.inner.widget() != this.panel.root) {
            parent.waitToRemoved(this.inner.widget());
        }
    }

    public void onDragPosition(int deltaX, int deltaY) {
        this.inner().widget().addSelfPosition(deltaX, deltaY);
    }

    public void onDragSize(int deltaX, int deltaY) {
        Widget selected = this.inner().widget();
        selected.setSize(new Size(selected.getSize().width + deltaX, selected.getSize().getHeight() + deltaY));
    }

    public boolean is(IConfigurableWidget configurableWidget) {
        return this.inner == configurableWidget;
    }

    public IGuiTexture toDraggingTexture(int mouseX, int mouseY) {
        return new WidgetTexture(mouseX, mouseY, this.inner.widget());
    }
}

