/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui;

import com.lowdragmc.lowdraglib.gui.animation.Transform;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TabButton;
import com.lowdragmc.lowdraglib.gui.widget.TabContainer;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.interpolate.Eases;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class ToolPanel
extends WidgetGroup {
    public static final int WIDTH = 100;
    protected final Editor editor;
    protected final List<Widget> toolBoxes = new ArrayList<Widget>();
    protected ButtonWidget buttonHide;
    protected TabContainer tabContainer;
    protected ImageWidget tabsBackground;
    protected boolean isShow;

    public ToolPanel(Editor editor) {
        super(-100, 30, 100, Math.max(100, editor.getSize().getHeight() - 100 - 30));
        this.setClientSideWidget();
        this.editor = editor;
    }

    @Override
    public void initWidget() {
        Size size = this.getSize();
        this.setBackground(ColorPattern.BLACK.rectTexture());
        this.addWidget(new LabelWidget(3, 3, "ldlib.gui.editor.group.tool_box"));
        this.tabsBackground = new ImageWidget(100, 15, 20, 0, ColorPattern.BLACK.rectTexture().setRightRadius(8.0f));
        this.addWidget(this.tabsBackground);
        this.tabContainer = new TabContainer(0, 15, 100, size.height - 15);
        this.addWidget(this.tabContainer);
        this.tabContainer.setBackground(ColorPattern.T_GRAY.borderTexture(-1));
        this.buttonHide = new ButtonWidget(87, 3, 10, 10, new GuiTextureGroup(ColorPattern.BLACK.rectTexture(), ColorPattern.T_GRAY.borderTexture(1), Icons.RIGHT), cd -> {
            if (this.isShow()) {
                this.hide();
            } else {
                this.show();
            }
        }).setHoverBorderTexture(1, -1);
        this.addWidget(this.buttonHide);
        super.initWidget();
    }

    @Override
    public void clearAllWidgets() {
        this.toolBoxes.clear();
        this.tabContainer.clearAllWidgets();
    }

    public void addNewToolBox(String name, ResourceTexture texture, WidgetGroup toolBox) {
        toolBox.setSize(new Size(100, this.getSize().height - 15));
        this.tabContainer.addTab((TabButton)new TabButton(104, 4 + this.toolBoxes.size() * 20, 12, 12){

            @Override
            @Environment(value=EnvType.CLIENT)
            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.isMouseOverElement(mouseX, mouseY)) {
                    ToolPanel.this.show();
                }
                return super.mouseClicked(mouseX, mouseY, button);
            }
        }.setTexture(texture, texture.copy().setColor(ColorPattern.T_GREEN.color)).setHoverTooltips(name), toolBox);
        this.toolBoxes.add(toolBox);
        this.tabsBackground.setSize(new Size(20, this.toolBoxes.size() * 20));
    }

    public void hide() {
        if (this.isShow() && !this.inAnimate()) {
            this.isShow = !this.isShow;
            this.animation(new Transform().offset(-100, 0).ease(Eases.EaseQuadOut).duration(500L).onFinish(() -> {
                this.addSelfPosition(-100, 0);
                this.buttonHide.setButtonTexture(ColorPattern.BLACK.rectTexture(), ColorPattern.T_GRAY.borderTexture(1), Icons.RIGHT);
            }));
        }
    }

    public void show() {
        if (!this.isShow() && !this.inAnimate()) {
            this.isShow = !this.isShow;
            this.animation(new Transform().offset(100, 0).ease(Eases.EaseQuadOut).duration(500L).onFinish(() -> {
                this.addSelfPosition(100, 0);
                this.buttonHide.setButtonTexture(ColorPattern.BLACK.rectTexture(), ColorPattern.T_GRAY.borderTexture(1), Icons.LEFT);
            }));
        }
    }

    public Editor getEditor() {
        return this.editor;
    }

    public boolean isShow() {
        return this.isShow;
    }
}

