/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui;

import com.lowdragmc.lowdraglib.gui.editor.ILDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.ui.ConfigPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.MenuPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.ToolPanel;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.util.TreeNode;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.MenuWidget;
import com.lowdragmc.lowdraglib.gui.widget.TabContainer;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.io.File;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public abstract class Editor
extends WidgetGroup
implements ILDLRegister {
    @Environment(value=EnvType.CLIENT)
    public static Editor INSTANCE;
    protected final File workSpace;
    protected IProject currentProject;
    protected MenuPanel menuPanel;
    protected TabContainer tabPages;
    protected ConfigPanel configPanel;
    protected ResourcePanel resourcePanel;
    protected WidgetGroup floatView;
    protected ToolPanel toolPanel;
    protected String copyType;
    protected Object copied;

    public Editor(File workSpace) {
        super(0, 0, 10, 10);
        this.setClientSideWidget();
        this.workSpace = workSpace;
    }

    @Override
    public void setGui(ModularUI gui) {
        super.setGui(gui);
        if (this.isRemote()) {
            if (gui == null) {
                INSTANCE = null;
            } else {
                INSTANCE = this;
                this.getGui().registerCloseListener(() -> {
                    INSTANCE = null;
                });
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onScreenSizeUpdate(int screenWidth, int screenHeight) {
        this.setSize(new Size(screenWidth, screenHeight));
        super.onScreenSizeUpdate(screenWidth, screenHeight);
        this.clearAllWidgets();
        this.initEditorViews();
        this.loadProject(this.currentProject);
    }

    public void initEditorViews() {
        this.tabPages = new TabContainer(0, 0, this.getSize().width, this.getSize().height);
        this.addWidget(this.tabPages);
        this.toolPanel = new ToolPanel(this);
        this.addWidget(this.toolPanel);
        this.configPanel = new ConfigPanel(this);
        this.addWidget(this.configPanel);
        this.resourcePanel = new ResourcePanel(this);
        this.addWidget(this.resourcePanel);
        this.menuPanel = new MenuPanel(this);
        this.addWidget(this.menuPanel);
        this.floatView = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.addWidget(this.floatView);
    }

    public DialogWidget openDialog(DialogWidget dialog) {
        this.addWidget(dialog);
        Position pos = dialog.getPosition();
        Size size = dialog.getSize();
        if (pos.x + size.width > this.getGui().getScreenWidth()) {
            dialog.addSelfPosition(pos.x + size.width - this.getGui().getScreenWidth(), 0);
        } else if (pos.x < 0) {
            dialog.addSelfPosition(-pos.x, 0);
        }
        if (pos.y + size.height > this.getGui().getScreenHeight()) {
            dialog.addSelfPosition(0, pos.y + size.height - this.getGui().getScreenHeight());
        } else if (pos.y < 0) {
            dialog.addSelfPosition(0, -pos.y);
        }
        return dialog;
    }

    public <T, C> MenuWidget<T, C> openMenu(double posX, double posY, TreeNode<T, C> menuNode) {
        MenuWidget<T, C> menu = new MenuWidget<T, C>((int)posX, (int)posY, 14, menuNode).setNodeTexture(MenuWidget.NODE_TEXTURE).setLeafTexture(MenuWidget.LEAF_TEXTURE).setNodeHoverTexture(MenuWidget.NODE_HOVER_TEXTURE);
        this.waitToAdded(menu.setBackground(MenuWidget.BACKGROUND));
        return menu;
    }

    public void openMenu(double posX, double posY, TreeBuilder.Menu menuBuilder) {
        if (menuBuilder == null) {
            return;
        }
        this.openMenu(posX, posY, menuBuilder.build()).setCrossLinePredicate(TreeBuilder.Menu::isCrossLine).setKeyIconSupplier(TreeBuilder.Menu::getIcon).setKeyNameSupplier(TreeBuilder.Menu::getName).setOnNodeClicked(TreeBuilder.Menu::handle);
    }

    public void loadProject(IProject project) {
        if (this.currentProject != null) {
            this.currentProject.onClosed(this);
        }
        this.currentProject = project;
        this.tabPages.clearAllWidgets();
        this.toolPanel.clearAllWidgets();
        if (this.currentProject != null) {
            this.currentProject.onLoad(this);
        }
    }

    public void setCopy(String copyType, Object copied) {
        this.copied = copied;
        this.copyType = copyType;
    }

    public void ifCopiedPresent(String copyType, Consumer<Object> consumer) {
        if (Objects.equals(copyType, this.copyType)) {
            consumer.accept(this.copied);
        }
    }

    public File getWorkSpace() {
        return this.workSpace;
    }

    public IProject getCurrentProject() {
        return this.currentProject;
    }

    public MenuPanel getMenuPanel() {
        return this.menuPanel;
    }

    public TabContainer getTabPages() {
        return this.tabPages;
    }

    public ConfigPanel getConfigPanel() {
        return this.configPanel;
    }

    public ResourcePanel getResourcePanel() {
        return this.resourcePanel;
    }

    public WidgetGroup getFloatView() {
        return this.floatView;
    }

    public ToolPanel getToolPanel() {
        return this.toolPanel;
    }

    public String getCopyType() {
        return this.copyType;
    }

    public Object getCopied() {
        return this.copied;
    }
}

