/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.HsbColorWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.TabButton;
import com.lowdragmc.lowdraglib.gui.widget.TabContainer;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ConfigPanel
extends WidgetGroup {
    public static final int WIDTH = 252;
    protected final Editor editor;
    protected final Map<Tab, IConfigurable> focus = new HashMap<Tab, IConfigurable>(Tab.TABS.size());
    protected final Map<Tab, DraggableScrollableWidgetGroup> configuratorGroup = new HashMap<Tab, DraggableScrollableWidgetGroup>(Tab.TABS.size());
    protected final Map<Tab, List<Configurator>> configurators = new HashMap<Tab, List<Configurator>>(Tab.TABS.size());
    protected TabContainer tabContainer;
    protected HsbColorWidget palette;

    public ConfigPanel(Editor editor) {
        super(editor.getSize().getWidth() - 252, 0, 252, editor.getSize().height);
        this.setClientSideWidget();
        this.editor = editor;
    }

    @Override
    public void initWidget() {
        this.setBackground(ColorPattern.T_BLACK.rectTexture());
        this.addWidget(new ImageWidget(0, 10, 252, 10, new TextTexture("ldlib.gui.editor.configurator").setWidth(202)));
        this.addWidget(new ImageWidget(-20, 30, 20, Tab.TABS.size() * 20, ColorPattern.T_BLACK.rectTexture().setLeftRadius(8.0f)));
        this.tabContainer = new TabContainer(0, 0, 252, this.editor.getSize().height);
        this.addWidget(this.tabContainer);
        int y = 34;
        for (Tab tab : Tab.TABS) {
            this.tabContainer.addTab(new TabButton(-16, y, 12, 12).setTexture(tab.icon, tab.icon.copy().setColor(ColorPattern.T_GREEN.color)), this.configuratorGroup.computeIfAbsent(tab, key -> new DraggableScrollableWidgetGroup(0, 25, 252, this.editor.getSize().height - 25).setYScrollBarWidth(2).setYBarStyle(null, ColorPattern.T_WHITE.rectTexture().setRadius(1.0f))));
            this.configurators.put(tab, new ArrayList());
            y += 20;
        }
        super.initWidget();
    }

    public void clearAllConfigurators(Tab tab) {
        this.focus.remove(tab);
        this.configuratorGroup.get(tab).clearAllWidgets();
        this.configurators.get(tab).clear();
    }

    public void openConfigurator(Tab tab, IConfigurable configurable) {
        this.switchTag(tab);
        if (Objects.equals(configurable, this.focus.get(tab))) {
            return;
        }
        this.clearAllConfigurators(tab);
        this.focus.put(tab, configurable);
        ConfiguratorGroup group = new ConfiguratorGroup("", false);
        tab.configurable.accept(group);
        configurable.buildConfigurator(group);
        for (Configurator configurator : group.getConfigurators()) {
            configurator.setConfigPanel(this, tab);
            configurator.init(250);
            this.configurators.get(tab).add(configurator);
            this.configuratorGroup.get(tab).addWidget(configurator);
        }
        this.computeLayout(tab);
        this.configuratorGroup.get(tab).setScrollYOffset(0);
    }

    public void switchTag(Tab tab) {
        this.tabContainer.switchTag(this.configuratorGroup.get(tab));
    }

    public void computeLayout(Tab tab) {
        int height = 0;
        for (Configurator configurator : this.configurators.get(tab)) {
            configurator.computeHeight();
            configurator.setSelfPosition(new Position(0, height - this.configuratorGroup.get(tab).getScrollYOffset()));
            height += configurator.getSize().height + 5;
        }
        this.configuratorGroup.get(tab).computeMax();
    }

    public Editor getEditor() {
        return this.editor;
    }

    public Map<Tab, IConfigurable> getFocus() {
        return this.focus;
    }

    public HsbColorWidget getPalette() {
        return this.palette;
    }

    public static class Tab {
        public static List<Tab> TABS = new ArrayList<Tab>();
        public static final Tab WIDGET = Tab.registerTab(Icons.WIDGET_SETTING);
        public static final Tab RESOURCE = Tab.registerTab(Icons.RESOURCE_SETTING);
        public final ResourceTexture icon;
        public final Consumer<ConfiguratorGroup> configurable;

        private Tab(ResourceTexture icon, Consumer<ConfiguratorGroup> configurable) {
            this.icon = icon;
            this.configurable = configurable;
        }

        public static Tab registerTab(ResourceTexture icon) {
            return Tab.registerTab(icon, father -> {});
        }

        public static Tab registerTab(ResourceTexture icon, Consumer<ConfiguratorGroup> configurable) {
            Tab tab = new Tab(icon, configurable);
            TABS.add(tab);
            return tab;
        }
    }
}

