/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.runtime;

import com.lowdragmc.lowdraglib.gui.editor.accessors.ArrayConfiguratorAccessor;
import com.lowdragmc.lowdraglib.gui.editor.accessors.CollectionConfiguratorAccessor;
import com.lowdragmc.lowdraglib.gui.editor.accessors.IConfiguratorAccessor;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.utils.ReflectionUtils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConfiguratorAccessors {
    private static final Map<Class<?>, IConfiguratorAccessor<?>> ACCESSOR_MAP = new ConcurrentHashMap();

    public static IConfiguratorAccessor<?> findByType(Type clazz) {
        if (clazz instanceof GenericArrayType) {
            GenericArrayType array = (GenericArrayType)clazz;
            Type componentType = array.getGenericComponentType();
            IConfiguratorAccessor<?> childAccessor = ConfiguratorAccessors.findByType(componentType);
            Class<?> rawType = ReflectionUtils.getRawType(componentType);
            return new ArrayConfiguratorAccessor(rawType == null ? Object.class : rawType, childAccessor);
        }
        Class<?> rawType = ReflectionUtils.getRawType(clazz);
        if (rawType != null) {
            if (rawType.isArray()) {
                Class<?> componentType = rawType.getComponentType();
                IConfiguratorAccessor<?> childAccessor = ConfiguratorAccessors.findByType(componentType);
                return new ArrayConfiguratorAccessor(componentType, childAccessor);
            }
            if (Collection.class.isAssignableFrom(rawType)) {
                Type componentType = ((ParameterizedType)clazz).getActualTypeArguments()[0];
                IConfiguratorAccessor<?> childAccessor = ConfiguratorAccessors.findByType(componentType);
                Class<?> rawComponentType = ReflectionUtils.getRawType(componentType);
                return new CollectionConfiguratorAccessor(rawType, rawComponentType == null ? Object.class : rawComponentType, childAccessor);
            }
            return ConfiguratorAccessors.findByClass(rawType);
        }
        return IConfiguratorAccessor.DEFAULT;
    }

    public static IConfiguratorAccessor<?> findByClass(Class<?> clazz) {
        return ACCESSOR_MAP.computeIfAbsent(clazz, c -> {
            for (IConfiguratorAccessor<?> accessor : AnnotationDetector.CONFIGURATOR_ACCESSORS) {
                if (!accessor.test((Class<?>)c)) continue;
                return accessor;
            }
            return IConfiguratorAccessor.DEFAULT;
        });
    }
}

