/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.data.resource;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.TexturesResourceContainer;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.TabContainer;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

@LDLRegister(name="ldlib.gui.editor.group.textures", group="resource")
public class TexturesResource
extends Resource<IGuiTexture> {
    public static final String RESOURCE_NAME = "ldlib.gui.editor.group.textures";

    public TexturesResource() {
        this.data.put("empty", IGuiTexture.EMPTY);
    }

    @Override
    public void buildDefault() {
        this.data.put("border background", ResourceBorderTexture.BORDERED_BACKGROUND);
        this.data.put("button", ResourceBorderTexture.BUTTON_COMMON);
        this.data.put("slot", new ResourceTexture("ldlib:textures/gui/slot.png"));
        this.data.put("fluid slot", new ResourceTexture("ldlib:textures/gui/fluid_slot.png"));
        this.data.put("tab", TabContainer.TABS_LEFT.getSubTexture(0.0f, 0.0f, 0.5f, 0.33333334f));
        this.data.put("tab pressed", TabContainer.TABS_LEFT.getSubTexture(0.5f, 0.0f, 0.5f, 0.33333334f));
        for (AnnotationDetector.Wrapper<LDLRegister, IGuiTexture> wrapper : AnnotationDetector.REGISTER_TEXTURES) {
            this.data.put("ldlib.gui.editor.register.texture." + wrapper.annotation().name(), wrapper.creator().get());
        }
    }

    @Override
    public String name() {
        return RESOURCE_NAME;
    }

    @Override
    public ResourceContainer<IGuiTexture, ImageWidget> createContainer(ResourcePanel panel) {
        return new TexturesResourceContainer(this, panel);
    }

    @Override
    public class_2520 serialize(IGuiTexture value) {
        return IGuiTexture.serializeWrapper(value);
    }

    @Override
    public IGuiTexture deserialize(class_2520 nbt) {
        if (nbt instanceof class_2487) {
            class_2487 tag = (class_2487)nbt;
            return IGuiTexture.deserializeWrapper(tag);
        }
        return null;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.data.clear();
        this.data.put("empty", IGuiTexture.EMPTY);
        for (String key : nbt.method_10541()) {
            this.data.put(key, this.deserialize(nbt.method_10580(key)));
        }
        for (IGuiTexture texture : this.data.values()) {
            texture.setUIResource(this);
        }
    }
}

