/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.data.resource;

import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public abstract class Resource<T> {
    protected final Map<String, T> data = new LinkedHashMap<String, T>();

    public void buildDefault() {
    }

    public void onLoad() {
    }

    public void unLoad() {
    }

    public T removeResource(String key) {
        return this.data.remove(key);
    }

    public boolean hasResource(String key) {
        return this.data.containsKey(key);
    }

    public void addResource(String key, T resource) {
        this.data.put(key, resource);
    }

    public Set<Map.Entry<String, T>> allResources() {
        return this.data.entrySet();
    }

    public T getResource(String key) {
        return this.data.get(key);
    }

    public T getResourceOrDefault(String key, T defaultValue) {
        return this.data.getOrDefault(key, defaultValue);
    }

    public void merge(Resource<T> resource) {
        resource.data.forEach((k, v) -> {
            if (!this.data.containsKey(k)) {
                this.data.put((String)k, (T)v);
            }
        });
    }

    public abstract String name();

    public abstract ResourceContainer<T, ? extends Widget> createContainer(ResourcePanel var1);

    @Nullable
    public abstract class_2520 serialize(T var1);

    public abstract T deserialize(class_2520 var1);

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        this.data.forEach((key, value) -> {
            class_2520 nbt = this.serialize(value);
            if (nbt != null) {
                tag.method_10566(key, nbt);
            }
        });
        return tag;
    }

    public void deserializeNBT(class_2487 nbt) {
        this.data.clear();
        for (String key : nbt.method_10541()) {
            this.data.put(key, this.deserialize(nbt.method_10580(key)));
        }
    }

    public Map<String, T> getData() {
        return this.data;
    }
}

