/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.data;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.MainPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.tool.WidgetToolBox;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.TabButton;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.io.File;
import java.io.IOException;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;

@LDLRegister(name="ui", group="editor.ui")
public class UIProject
implements IProject {
    public Resources resources;
    public WidgetGroup root;

    private UIProject() {
    }

    public UIProject(Resources resources, WidgetGroup root) {
        this.resources = resources;
        this.root = root;
    }

    public UIProject(class_2487 tag) {
        this.deserializeNBT(tag);
    }

    @Override
    public UIProject newEmptyProject() {
        return new UIProject(Resources.defaultResource(), (WidgetGroup)new WidgetGroup(30, 30, 200, 200).setBackground(ResourceBorderTexture.BORDERED_BACKGROUND));
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10566("resources", (class_2520)this.resources.serializeNBT());
        tag.method_10566("root", (class_2520)IConfigurableWidget.serializeNBT(this.root, this.resources, true));
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        this.resources = this.loadResources(tag.method_10562("resources"));
        this.root = new WidgetGroup();
        IConfigurableWidget.deserializeNBT(this.root, tag.method_10562("root"), this.resources, true);
    }

    @Override
    public Resources getResources() {
        return this.resources;
    }

    @Override
    public void saveProject(File file) {
        try {
            class_2507.method_10630((class_2487)this.serializeNBT(), (File)file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public IProject loadProject(File file) {
        try {
            class_2487 tag = class_2507.method_10633((File)file);
            if (tag != null) {
                return new UIProject(tag);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void onLoad(Editor editor) {
        IProject.super.onLoad(editor);
        editor.getTabPages().addTab(new TabButton(50, 16, 60, 14).setTexture(new GuiTextureGroup(ColorPattern.T_GREEN.rectTexture().setBottomRadius(10.0f).transform(0.0f, 0.4f), new TextTexture("Main")), new GuiTextureGroup(ColorPattern.T_RED.rectTexture().setBottomRadius(10.0f).transform(0.0f, 0.4f), new TextTexture("Main"))), new MainPanel(editor, this.root));
        for (WidgetToolBox.Default tab : WidgetToolBox.Default.TABS) {
            editor.getToolPanel().addNewToolBox("ldlib.gui.editor.group." + tab.groupName, tab.icon, tab.createToolBox());
        }
    }
}

