/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class Resources {
    public final Map<String, Resource<?>> resources;

    protected Resources() {
        this.resources = new LinkedHashMap();
        for (AnnotationDetector.Wrapper<LDLRegister, Resource> wrapper : AnnotationDetector.REGISTER_RESOURCES) {
            Resource resource = wrapper.creator().get();
            this.resources.put(resource.name(), resource);
        }
    }

    public Resources(Map<String, Resource<?>> resources) {
        this.resources = resources;
    }

    public static Resources emptyResource() {
        return new Resources(new LinkedHashMap());
    }

    public static Resources fromNBT(class_2487 tag) {
        Resources resource = new Resources();
        resource.deserializeNBT(tag);
        return resource;
    }

    public static Resources defaultResource() {
        Resources resources = new Resources();
        resources.resources.values().forEach(Resource::buildDefault);
        return resources;
    }

    public void merge(Resources resources) {
        this.resources.forEach((k, v) -> {
            if (resources.resources.containsKey(k)) {
                Resource<?> f = resources.resources.get(k);
                v.merge(f);
            }
        });
    }

    public void load() {
        this.resources.values().forEach(Resource::onLoad);
    }

    public void dispose() {
        this.resources.values().forEach(Resource::unLoad);
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        this.resources.forEach((key, resource) -> tag.method_10566(key, (class_2520)resource.serializeNBT()));
        return tag;
    }

    public void deserializeNBT(class_2487 nbt) {
        this.resources.forEach((k, v) -> v.deserializeNBT(nbt.method_10562(k)));
    }
}

