/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class Vector3Configurator
extends ValueConfigurator<Vector3f> {
    protected Number min;
    protected Number max;
    protected Number wheel;

    public Vector3Configurator(String name, Supplier<Vector3f> supplier, Consumer<Vector3f> onUpdate, @NotNull Vector3f defaultValue, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        if (this.value == null) {
            this.value = defaultValue;
        }
        this.setWheel(Float.valueOf(0.1f));
    }

    public Vector3Configurator setRange(Number min, Number max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public Vector3Configurator setWheel(Number wheel) {
        if (wheel.doubleValue() == 0.0) {
            return this;
        }
        this.wheel = wheel;
        return this;
    }

    @Override
    protected void onValueUpdate(Vector3f newValue) {
        if (newValue == null) {
            newValue = (Vector3f)this.defaultValue;
        }
        if (newValue.equals(this.value)) {
            return;
        }
        super.onValueUpdate(newValue);
    }

    @Override
    public void init(int width) {
        super.init(width);
        assert (this.value != null);
        int w = (width - this.leftWidth - this.rightWidth) / 3;
        NumberConfigurator x = new NumberConfigurator("x", () -> Float.valueOf(((Vector3f)this.value).x), number -> {
            ((Vector3f)this.value).x = (float)number.doubleValue();
            this.updateValue();
        }, Float.valueOf(((Vector3f)this.defaultValue).x), this.forceUpdate);
        x.setRange(this.min, this.max);
        x.setWheel(this.wheel);
        x.setConfigPanel(this.configPanel, this.tab);
        x.init(w);
        x.addSelfPosition(this.leftWidth, 0);
        this.addWidget(x);
        NumberConfigurator y = new NumberConfigurator("y", () -> Float.valueOf(((Vector3f)this.value).y), number -> {
            ((Vector3f)this.value).y = (float)number.doubleValue();
            this.updateValue();
        }, Float.valueOf(((Vector3f)this.defaultValue).y), this.forceUpdate);
        y.setRange(this.min, this.max);
        y.setWheel(this.wheel);
        y.setConfigPanel(this.configPanel, this.tab);
        y.init(w);
        y.addSelfPosition(this.leftWidth + w, 0);
        this.addWidget(y);
        NumberConfigurator z = new NumberConfigurator("z", () -> Float.valueOf(((Vector3f)this.value).z), number -> {
            ((Vector3f)this.value).z = (float)number.doubleValue();
            this.updateValue();
        }, Float.valueOf(((Vector3f)this.defaultValue).z), this.forceUpdate);
        z.setRange(this.min, this.max);
        z.setWheel(this.wheel);
        z.setConfigPanel(this.configPanel, this.tab);
        z.init(w);
        z.addSelfPosition(this.leftWidth + w * 2, 0);
        this.addWidget(z);
    }
}

