/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ValueConfigurator<T>
extends Configurator {
    protected boolean forceUpdate;
    @Nullable
    protected T value;
    @Nonnull
    protected T defaultValue;
    protected Consumer<T> onUpdate;
    protected Supplier<T> supplier;

    public ValueConfigurator(String name, Supplier<T> supplier, Consumer<T> onUpdate, @Nonnull T defaultValue, boolean forceUpdate) {
        super(name);
        this.setClientSideWidget();
        this.supplier = supplier;
        this.onUpdate = onUpdate;
        this.defaultValue = defaultValue;
        this.forceUpdate = forceUpdate;
        this.value = supplier.get();
        this.name = name;
    }

    protected void updateValue() {
        if (this.onUpdate != null) {
            this.onUpdate.accept(this.value);
        }
    }

    protected void onValueUpdate(T newValue) {
        this.value = newValue;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.forceUpdate) {
            this.onValueUpdate(this.supplier.get());
        }
    }

    public void setOnUpdate(Consumer<T> onUpdate) {
        this.onUpdate = onUpdate;
    }

    public void setSupplier(Supplier<T> supplier) {
        this.supplier = supplier;
    }
}

