/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.SelectorWidget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class SelectorConfigurator<T>
extends ValueConfigurator<T> {
    protected List<T> candidates;
    protected Function<T, String> mapping;
    protected Map<String, T> nameMap;
    protected SelectorWidget selector;
    protected int max = 5;
    protected boolean isUp = true;

    public SelectorConfigurator(String name, Supplier<T> supplier, Consumer<T> onUpdate, @Nonnull T defaultValue, boolean forceUpdate, List<T> candidates, Function<T, String> mapping) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        this.candidates = candidates;
        this.mapping = mapping;
        this.nameMap = new HashMap<String, T>();
        for (T candidate : candidates) {
            this.nameMap.put(mapping.apply(candidate), candidate);
        }
    }

    @Override
    protected void onValueUpdate(T newValue) {
        if (newValue == null) {
            newValue = this.defaultValue;
        }
        if (newValue.equals(this.value)) {
            return;
        }
        super.onValueUpdate(newValue);
        this.selector.setValue(this.mapping.apply(newValue));
    }

    @Override
    public void init(int width) {
        super.init(width);
        this.selector = new SelectorWidget(this.leftWidth, 2, width - this.leftWidth - 3 - this.rightWidth, 10, this.nameMap.keySet().stream().toList(), -1).setOnChanged(s -> {
            this.value = this.nameMap.get(s);
            this.updateValue();
        }).setMaxCount(this.max).setIsUp(this.isUp).setButtonBackground(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)).setBackground((IGuiTexture)ColorPattern.BLACK.rectTexture()).setValue(this.mapping.apply(this.value));
        this.addWidget(this.selector);
    }

    public SelectorWidget getSelector() {
        return this.selector;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setUp(boolean isUp) {
        this.isUp = isUp;
    }
}

